
package org.jpmml.model.visitors;

import java.util.ArrayDeque;
import java.util.Deque;
import org.dmg.pmml.Aggregate;
import org.dmg.pmml.Annotation;
import org.dmg.pmml.Anova;
import org.dmg.pmml.AnovaRow;
import org.dmg.pmml.AnyDistribution;
import org.dmg.pmml.Application;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Array;
import org.dmg.pmml.BinarySimilarity;
import org.dmg.pmml.BlockIndicator;
import org.dmg.pmml.BoundaryValueMeans;
import org.dmg.pmml.BoundaryValues;
import org.dmg.pmml.Cell;
import org.dmg.pmml.Chebychev;
import org.dmg.pmml.ChildParent;
import org.dmg.pmml.CityBlock;
import org.dmg.pmml.ClassLabels;
import org.dmg.pmml.ClusteringModelQuality;
import org.dmg.pmml.ComparisonMeasure;
import org.dmg.pmml.ComplexScoreDistribution;
import org.dmg.pmml.CompoundPredicate;
import org.dmg.pmml.ConfusionMatrix;
import org.dmg.pmml.Constant;
import org.dmg.pmml.ContStats;
import org.dmg.pmml.CorrelationFields;
import org.dmg.pmml.CorrelationMethods;
import org.dmg.pmml.CorrelationValues;
import org.dmg.pmml.Correlations;
import org.dmg.pmml.Counts;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.Decision;
import org.dmg.pmml.Decisions;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.DiscrStats;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.DiscretizeBin;
import org.dmg.pmml.Euclidean;
import org.dmg.pmml.Extension;
import org.dmg.pmml.False;
import org.dmg.pmml.FieldColumnPair;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.GaussianDistribution;
import org.dmg.pmml.Header;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.IntSparseArray;
import org.dmg.pmml.Interval;
import org.dmg.pmml.Jaccard;
import org.dmg.pmml.Lag;
import org.dmg.pmml.LiftData;
import org.dmg.pmml.LiftGraph;
import org.dmg.pmml.LinearNorm;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.MatCell;
import org.dmg.pmml.Matrix;
import org.dmg.pmml.MiningBuildTask;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Minkowski;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelLiftGraph;
import org.dmg.pmml.ModelQuality;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.MultivariateStat;
import org.dmg.pmml.MultivariateStats;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.NumericInfo;
import org.dmg.pmml.OptimumLiftGraph;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMML;
import org.dmg.pmml.ParameterField;
import org.dmg.pmml.Partition;
import org.dmg.pmml.PartitionFieldStats;
import org.dmg.pmml.PoissonDistribution;
import org.dmg.pmml.PredictiveModelQuality;
import org.dmg.pmml.Quantile;
import org.dmg.pmml.ROC;
import org.dmg.pmml.ROCGraph;
import org.dmg.pmml.RandomLiftGraph;
import org.dmg.pmml.RealSparseArray;
import org.dmg.pmml.ResultField;
import org.dmg.pmml.Row;
import org.dmg.pmml.SimpleMatching;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.SquaredEuclidean;
import org.dmg.pmml.Stats;
import org.dmg.pmml.TableLocator;
import org.dmg.pmml.Tanimoto;
import org.dmg.pmml.Target;
import org.dmg.pmml.TargetValue;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Taxonomy;
import org.dmg.pmml.TextIndex;
import org.dmg.pmml.TextIndexNormalization;
import org.dmg.pmml.Timestamp;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.True;
import org.dmg.pmml.UnivariateStats;
import org.dmg.pmml.Value;
import org.dmg.pmml.VerificationField;
import org.dmg.pmml.VerificationFields;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.XCoordinates;
import org.dmg.pmml.YCoordinates;
import org.dmg.pmml.anomaly_detection.AnomalyDetectionModel;
import org.dmg.pmml.anomaly_detection.MeanClusterDistances;
import org.dmg.pmml.association.AssociationModel;
import org.dmg.pmml.association.AssociationRule;
import org.dmg.pmml.association.Item;
import org.dmg.pmml.association.ItemRef;
import org.dmg.pmml.association.Itemset;
import org.dmg.pmml.baseline.Alternate;
import org.dmg.pmml.baseline.Baseline;
import org.dmg.pmml.baseline.BaselineModel;
import org.dmg.pmml.baseline.CountTable;
import org.dmg.pmml.baseline.FieldValue;
import org.dmg.pmml.baseline.FieldValueCount;
import org.dmg.pmml.baseline.TestDistributions;
import org.dmg.pmml.bayesian_network.BayesianNetworkModel;
import org.dmg.pmml.bayesian_network.BayesianNetworkNodes;
import org.dmg.pmml.bayesian_network.ContinuousConditionalProbability;
import org.dmg.pmml.bayesian_network.ContinuousNode;
import org.dmg.pmml.bayesian_network.DiscreteConditionalProbability;
import org.dmg.pmml.bayesian_network.DiscreteNode;
import org.dmg.pmml.bayesian_network.LognormalDistribution;
import org.dmg.pmml.bayesian_network.Lower;
import org.dmg.pmml.bayesian_network.Mean;
import org.dmg.pmml.bayesian_network.NormalDistribution;
import org.dmg.pmml.bayesian_network.ParentValue;
import org.dmg.pmml.bayesian_network.TriangularDistribution;
import org.dmg.pmml.bayesian_network.Upper;
import org.dmg.pmml.bayesian_network.ValueProbability;
import org.dmg.pmml.bayesian_network.Variance;
import org.dmg.pmml.clustering.CenterFields;
import org.dmg.pmml.clustering.Cluster;
import org.dmg.pmml.clustering.ClusteringField;
import org.dmg.pmml.clustering.ClusteringModel;
import org.dmg.pmml.clustering.Comparisons;
import org.dmg.pmml.clustering.Covariances;
import org.dmg.pmml.clustering.KohonenMap;
import org.dmg.pmml.clustering.MissingValueWeights;
import org.dmg.pmml.gaussian_process.ARDSquaredExponentialKernel;
import org.dmg.pmml.gaussian_process.AbsoluteExponentialKernel;
import org.dmg.pmml.gaussian_process.GaussianProcessModel;
import org.dmg.pmml.gaussian_process.GeneralizedExponentialKernel;
import org.dmg.pmml.gaussian_process.Lambda;
import org.dmg.pmml.general_regression.BaseCumHazardTables;
import org.dmg.pmml.general_regression.BaselineCell;
import org.dmg.pmml.general_regression.BaselineStratum;
import org.dmg.pmml.general_regression.Categories;
import org.dmg.pmml.general_regression.Category;
import org.dmg.pmml.general_regression.CovariateList;
import org.dmg.pmml.general_regression.EventValues;
import org.dmg.pmml.general_regression.FactorList;
import org.dmg.pmml.general_regression.GeneralRegressionModel;
import org.dmg.pmml.general_regression.PCell;
import org.dmg.pmml.general_regression.PCovCell;
import org.dmg.pmml.general_regression.PCovMatrix;
import org.dmg.pmml.general_regression.PPCell;
import org.dmg.pmml.general_regression.PPMatrix;
import org.dmg.pmml.general_regression.ParamMatrix;
import org.dmg.pmml.general_regression.Parameter;
import org.dmg.pmml.general_regression.ParameterList;
import org.dmg.pmml.general_regression.Predictor;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segment;
import org.dmg.pmml.mining.Segmentation;
import org.dmg.pmml.mining.VariableWeight;
import org.dmg.pmml.naive_bayes.BayesInput;
import org.dmg.pmml.naive_bayes.BayesInputs;
import org.dmg.pmml.naive_bayes.BayesOutput;
import org.dmg.pmml.naive_bayes.NaiveBayesModel;
import org.dmg.pmml.naive_bayes.PairCounts;
import org.dmg.pmml.naive_bayes.TargetValueCount;
import org.dmg.pmml.naive_bayes.TargetValueCounts;
import org.dmg.pmml.naive_bayes.TargetValueStat;
import org.dmg.pmml.naive_bayes.TargetValueStats;
import org.dmg.pmml.nearest_neighbor.InstanceField;
import org.dmg.pmml.nearest_neighbor.InstanceFields;
import org.dmg.pmml.nearest_neighbor.KNNInput;
import org.dmg.pmml.nearest_neighbor.KNNInputs;
import org.dmg.pmml.nearest_neighbor.NearestNeighborModel;
import org.dmg.pmml.nearest_neighbor.TrainingInstances;
import org.dmg.pmml.neural_network.Connection;
import org.dmg.pmml.neural_network.NeuralInput;
import org.dmg.pmml.neural_network.NeuralInputs;
import org.dmg.pmml.neural_network.NeuralLayer;
import org.dmg.pmml.neural_network.NeuralNetwork;
import org.dmg.pmml.neural_network.NeuralOutput;
import org.dmg.pmml.neural_network.NeuralOutputs;
import org.dmg.pmml.neural_network.Neuron;
import org.dmg.pmml.regression.CategoricalPredictor;
import org.dmg.pmml.regression.NumericPredictor;
import org.dmg.pmml.regression.PredictorTerm;
import org.dmg.pmml.regression.Regression;
import org.dmg.pmml.regression.RegressionModel;
import org.dmg.pmml.regression.RegressionTable;
import org.dmg.pmml.rule_set.CompoundRule;
import org.dmg.pmml.rule_set.RuleSelectionMethod;
import org.dmg.pmml.rule_set.RuleSet;
import org.dmg.pmml.rule_set.RuleSetModel;
import org.dmg.pmml.rule_set.SimpleRule;
import org.dmg.pmml.scorecard.Attribute;
import org.dmg.pmml.scorecard.Characteristic;
import org.dmg.pmml.scorecard.Characteristics;
import org.dmg.pmml.scorecard.ComplexPartialScore;
import org.dmg.pmml.scorecard.Scorecard;
import org.dmg.pmml.sequence.AntecedentSequence;
import org.dmg.pmml.sequence.ConsequentSequence;
import org.dmg.pmml.sequence.Constraints;
import org.dmg.pmml.sequence.Delimiter;
import org.dmg.pmml.sequence.Sequence;
import org.dmg.pmml.sequence.SequenceModel;
import org.dmg.pmml.sequence.SequenceReference;
import org.dmg.pmml.sequence.SequenceRule;
import org.dmg.pmml.sequence.SetPredicate;
import org.dmg.pmml.sequence.SetReference;
import org.dmg.pmml.sequence.Time;
import org.dmg.pmml.support_vector_machine.Coefficient;
import org.dmg.pmml.support_vector_machine.Coefficients;
import org.dmg.pmml.support_vector_machine.LinearKernel;
import org.dmg.pmml.support_vector_machine.PolynomialKernel;
import org.dmg.pmml.support_vector_machine.SigmoidKernel;
import org.dmg.pmml.support_vector_machine.SupportVector;
import org.dmg.pmml.support_vector_machine.SupportVectorMachine;
import org.dmg.pmml.support_vector_machine.SupportVectorMachineModel;
import org.dmg.pmml.support_vector_machine.SupportVectors;
import org.dmg.pmml.support_vector_machine.VectorDictionary;
import org.dmg.pmml.support_vector_machine.VectorFields;
import org.dmg.pmml.support_vector_machine.VectorInstance;
import org.dmg.pmml.text.DocumentTermMatrix;
import org.dmg.pmml.text.TextCorpus;
import org.dmg.pmml.text.TextDictionary;
import org.dmg.pmml.text.TextDocument;
import org.dmg.pmml.text.TextModel;
import org.dmg.pmml.text.TextModelNormalization;
import org.dmg.pmml.text.TextModelSimiliarity;
import org.dmg.pmml.time_series.AR;
import org.dmg.pmml.time_series.ARIMA;
import org.dmg.pmml.time_series.ARMAPart;
import org.dmg.pmml.time_series.Denominator;
import org.dmg.pmml.time_series.DynamicRegressor;
import org.dmg.pmml.time_series.ExponentialSmoothing;
import org.dmg.pmml.time_series.FinalNoise;
import org.dmg.pmml.time_series.FinalNu;
import org.dmg.pmml.time_series.FinalOmega;
import org.dmg.pmml.time_series.FinalPredictedNoise;
import org.dmg.pmml.time_series.FinalStateVector;
import org.dmg.pmml.time_series.FinalTheta;
import org.dmg.pmml.time_series.GARCH;
import org.dmg.pmml.time_series.GARCHPart;
import org.dmg.pmml.time_series.HVector;
import org.dmg.pmml.time_series.InterceptVector;
import org.dmg.pmml.time_series.KalmanState;
import org.dmg.pmml.time_series.Level;
import org.dmg.pmml.time_series.MA;
import org.dmg.pmml.time_series.MACoefficients;
import org.dmg.pmml.time_series.MaximumLikelihoodStat;
import org.dmg.pmml.time_series.MeasurementMatrix;
import org.dmg.pmml.time_series.NonseasonalComponent;
import org.dmg.pmml.time_series.NonseasonalFactor;
import org.dmg.pmml.time_series.Numerator;
import org.dmg.pmml.time_series.ObservationVarianceMatrix;
import org.dmg.pmml.time_series.OutlierEffect;
import org.dmg.pmml.time_series.PastVariances;
import org.dmg.pmml.time_series.PredictedStateCovarianceMatrix;
import org.dmg.pmml.time_series.PsiVector;
import org.dmg.pmml.time_series.RegressorValues;
import org.dmg.pmml.time_series.ResidualSquareCoefficients;
import org.dmg.pmml.time_series.Residuals;
import org.dmg.pmml.time_series.SeasonalComponent;
import org.dmg.pmml.time_series.SeasonalFactor;
import org.dmg.pmml.time_series.SeasonalTrendDecomposition;
import org.dmg.pmml.time_series.SeasonalityExpoSmooth;
import org.dmg.pmml.time_series.SelectedStateCovarianceMatrix;
import org.dmg.pmml.time_series.SpectralAnalysis;
import org.dmg.pmml.time_series.StateSpaceModel;
import org.dmg.pmml.time_series.StateVector;
import org.dmg.pmml.time_series.Theta;
import org.dmg.pmml.time_series.ThetaRecursionState;
import org.dmg.pmml.time_series.TimeAnchor;
import org.dmg.pmml.time_series.TimeCycle;
import org.dmg.pmml.time_series.TimeException;
import org.dmg.pmml.time_series.TimeSeries;
import org.dmg.pmml.time_series.TimeSeriesModel;
import org.dmg.pmml.time_series.TimeValue;
import org.dmg.pmml.time_series.TransferFunctionValues;
import org.dmg.pmml.time_series.TransitionMatrix;
import org.dmg.pmml.time_series.TrendCoefficients;
import org.dmg.pmml.time_series.TrendExpoSmooth;
import org.dmg.pmml.time_series.VarianceCoefficients;
import org.dmg.pmml.tree.ComplexNode;
import org.dmg.pmml.tree.DecisionTree;
import org.dmg.pmml.tree.TreeModel;

public abstract class AbstractVisitor
    implements Visitor
{

    private Deque<org.dmg.pmml.PMMLObject> parents = new ArrayDeque<org.dmg.pmml.PMMLObject>();

    @Override
    public Deque<org.dmg.pmml.PMMLObject> getParents() {
        return this.parents;
    }

    @Override
    public void applyTo(Visitable visitable) {
        visitable.accept(this);
    }

    public VisitorAction visit(org.dmg.pmml.PMMLObject object) {
        return VisitorAction.CONTINUE;
    }

    @Override
    public VisitorAction visit(Cell cell) {
        return visit(((org.dmg.pmml.PMMLObject) cell));
    }

    @Override
    public VisitorAction visit(org.dmg.pmml.ComparisonField<?> comparisonField) {
        return visit(((org.dmg.pmml.PMMLObject) comparisonField));
    }

    @Override
    public VisitorAction visit(org.dmg.pmml.ContinuousDistribution continuousDistribution) {
        return visit(((org.dmg.pmml.Distribution) continuousDistribution));
    }

    @Override
    public VisitorAction visit(org.dmg.pmml.DiscreteDistribution discreteDistribution) {
        return visit(((org.dmg.pmml.Distribution) discreteDistribution));
    }

    @Override
    public VisitorAction visit(org.dmg.pmml.Distance distance) {
        return visit(((org.dmg.pmml.Measure) distance));
    }

    @Override
    public VisitorAction visit(org.dmg.pmml.Distribution distribution) {
        return visit(((org.dmg.pmml.PMMLObject) distribution));
    }

    @Override
    public VisitorAction visit(org.dmg.pmml.EmbeddedModel embeddedModel) {
        return visit(((org.dmg.pmml.PMMLObject) embeddedModel));
    }

    @Override
    public VisitorAction visit(org.dmg.pmml.Entity<?> entity) {
        return visit(((org.dmg.pmml.PMMLObject) entity));
    }

    @Override
    public VisitorAction visit(org.dmg.pmml.Expression expression) {
        return visit(((org.dmg.pmml.PMMLObject) expression));
    }

    @Override
    public VisitorAction visit(org.dmg.pmml.Field<?> field) {
        return visit(((org.dmg.pmml.PMMLObject) field));
    }

    @Override
    public VisitorAction visit(org.dmg.pmml.support_vector_machine.Kernel kernel) {
        return visit(((org.dmg.pmml.PMMLObject) kernel));
    }

    @Override
    public VisitorAction visit(org.dmg.pmml.Measure measure) {
        return visit(((org.dmg.pmml.PMMLObject) measure));
    }

    @Override
    public VisitorAction visit(org.dmg.pmml.Model model) {
        return visit(((org.dmg.pmml.PMMLObject) model));
    }

    @Override
    public VisitorAction visit(org.dmg.pmml.neural_network.NeuralEntity neuralEntity) {
        return visit(((org.dmg.pmml.Entity) neuralEntity));
    }

    @Override
    public VisitorAction visit(org.dmg.pmml.tree.Node node) {
        return visit(((org.dmg.pmml.Entity) node));
    }

    @Override
    public VisitorAction visit(org.dmg.pmml.general_regression.ParameterCell parameterCell) {
        return visit(((org.dmg.pmml.PMMLObject) parameterCell));
    }

    @Override
    public VisitorAction visit(org.dmg.pmml.Predicate predicate) {
        return visit(((org.dmg.pmml.PMMLObject) predicate));
    }

    @Override
    public VisitorAction visit(org.dmg.pmml.general_regression.PredictorList predictorList) {
        return visit(((org.dmg.pmml.PMMLObject) predictorList));
    }

    @Override
    public VisitorAction visit(org.dmg.pmml.rule_set.Rule rule) {
        return visit(((org.dmg.pmml.Entity) rule));
    }

    @Override
    public VisitorAction visit(org.dmg.pmml.ScoreDistribution scoreDistribution) {
        return visit(((org.dmg.pmml.PMMLObject) scoreDistribution));
    }

    @Override
    public VisitorAction visit(org.dmg.pmml.Similarity similarity) {
        return visit(((org.dmg.pmml.Measure) similarity));
    }

    @Override
    public VisitorAction visit(org.dmg.pmml.SparseArray<?> sparseArray) {
        return visit(((org.dmg.pmml.PMMLObject) sparseArray));
    }

    @Override
    public VisitorAction visit(org.dmg.pmml.regression.Term term) {
        return visit(((org.dmg.pmml.PMMLObject) term));
    }

    @Override
    public VisitorAction visit(org.dmg.pmml.time_series.TimeSeriesAlgorithm timeSeriesAlgorithm) {
        return visit(((org.dmg.pmml.PMMLObject) timeSeriesAlgorithm));
    }

    @Override
    public VisitorAction visit(AbsoluteExponentialKernel absoluteExponentialKernel) {
        return visit(((org.dmg.pmml.PMMLObject) absoluteExponentialKernel));
    }

    @Override
    public VisitorAction visit(Aggregate aggregate) {
        return visit(((org.dmg.pmml.Expression) aggregate));
    }

    @Override
    public VisitorAction visit(Alternate alternate) {
        return visit(((org.dmg.pmml.PMMLObject) alternate));
    }

    @Override
    public VisitorAction visit(Annotation annotation) {
        return visit(((org.dmg.pmml.PMMLObject) annotation));
    }

    @Override
    public VisitorAction visit(AnomalyDetectionModel anomalyDetectionModel) {
        return visit(((org.dmg.pmml.Model) anomalyDetectionModel));
    }

    @Override
    public VisitorAction visit(Anova anova) {
        return visit(((org.dmg.pmml.PMMLObject) anova));
    }

    @Override
    public VisitorAction visit(AnovaRow anovaRow) {
        return visit(((org.dmg.pmml.PMMLObject) anovaRow));
    }

    @Override
    public VisitorAction visit(AntecedentSequence antecedentSequence) {
        return visit(((org.dmg.pmml.PMMLObject) antecedentSequence));
    }

    @Override
    public VisitorAction visit(AnyDistribution anyDistribution) {
        return visit(((org.dmg.pmml.ContinuousDistribution) anyDistribution));
    }

    @Override
    public VisitorAction visit(Application application) {
        return visit(((org.dmg.pmml.PMMLObject) application));
    }

    @Override
    public VisitorAction visit(Apply apply) {
        return visit(((org.dmg.pmml.Expression) apply));
    }

    @Override
    public VisitorAction visit(AR ar) {
        return visit(((org.dmg.pmml.PMMLObject) ar));
    }

    @Override
    public VisitorAction visit(ARDSquaredExponentialKernel ardSquaredExponentialKernel) {
        return visit(((org.dmg.pmml.PMMLObject) ardSquaredExponentialKernel));
    }

    @Override
    public VisitorAction visit(ARIMA arima) {
        return visit(((org.dmg.pmml.time_series.TimeSeriesAlgorithm) arima));
    }

    @Override
    public VisitorAction visit(ARMAPart armaPart) {
        return visit(((org.dmg.pmml.PMMLObject) armaPart));
    }

    @Override
    public VisitorAction visit(Array array) {
        return visit(((org.dmg.pmml.PMMLObject) array));
    }

    @Override
    public VisitorAction visit(AssociationModel associationModel) {
        return visit(((org.dmg.pmml.Model) associationModel));
    }

    @Override
    public VisitorAction visit(AssociationRule associationRule) {
        return visit(((org.dmg.pmml.Entity) associationRule));
    }

    @Override
    public VisitorAction visit(Attribute attribute) {
        return visit(((org.dmg.pmml.PMMLObject) attribute));
    }

    @Override
    public VisitorAction visit(BaseCumHazardTables baseCumHazardTables) {
        return visit(((org.dmg.pmml.PMMLObject) baseCumHazardTables));
    }

    @Override
    public VisitorAction visit(Baseline baseline) {
        return visit(((org.dmg.pmml.PMMLObject) baseline));
    }

    @Override
    public VisitorAction visit(BaselineCell baselineCell) {
        return visit(((org.dmg.pmml.PMMLObject) baselineCell));
    }

    @Override
    public VisitorAction visit(BaselineModel baselineModel) {
        return visit(((org.dmg.pmml.Model) baselineModel));
    }

    @Override
    public VisitorAction visit(BaselineStratum baselineStratum) {
        return visit(((org.dmg.pmml.PMMLObject) baselineStratum));
    }

    @Override
    public VisitorAction visit(BayesianNetworkModel bayesianNetworkModel) {
        return visit(((org.dmg.pmml.Model) bayesianNetworkModel));
    }

    @Override
    public VisitorAction visit(BayesianNetworkNodes bayesianNetworkNodes) {
        return visit(((org.dmg.pmml.PMMLObject) bayesianNetworkNodes));
    }

    @Override
    public VisitorAction visit(BayesInput bayesInput) {
        return visit(((org.dmg.pmml.PMMLObject) bayesInput));
    }

    @Override
    public VisitorAction visit(BayesInputs bayesInputs) {
        return visit(((org.dmg.pmml.PMMLObject) bayesInputs));
    }

    @Override
    public VisitorAction visit(BayesOutput bayesOutput) {
        return visit(((org.dmg.pmml.PMMLObject) bayesOutput));
    }

    @Override
    public VisitorAction visit(BinarySimilarity binarySimilarity) {
        return visit(((org.dmg.pmml.Similarity) binarySimilarity));
    }

    @Override
    public VisitorAction visit(BlockIndicator blockIndicator) {
        return visit(((org.dmg.pmml.PMMLObject) blockIndicator));
    }

    @Override
    public VisitorAction visit(BoundaryValueMeans boundaryValueMeans) {
        return visit(((org.dmg.pmml.PMMLObject) boundaryValueMeans));
    }

    @Override
    public VisitorAction visit(BoundaryValues boundaryValues) {
        return visit(((org.dmg.pmml.PMMLObject) boundaryValues));
    }

    @Override
    public VisitorAction visit(CategoricalPredictor categoricalPredictor) {
        return visit(((org.dmg.pmml.regression.Term) categoricalPredictor));
    }

    @Override
    public VisitorAction visit(Categories categories) {
        return visit(((org.dmg.pmml.PMMLObject) categories));
    }

    @Override
    public VisitorAction visit(Category category) {
        return visit(((org.dmg.pmml.PMMLObject) category));
    }

    @Override
    public VisitorAction visit(CenterFields centerFields) {
        return visit(((org.dmg.pmml.PMMLObject) centerFields));
    }

    @Override
    public VisitorAction visit(Characteristic characteristic) {
        return visit(((org.dmg.pmml.PMMLObject) characteristic));
    }

    @Override
    public VisitorAction visit(Characteristics characteristics) {
        return visit(((org.dmg.pmml.PMMLObject) characteristics));
    }

    @Override
    public VisitorAction visit(Chebychev chebychev) {
        return visit(((org.dmg.pmml.Distance) chebychev));
    }

    @Override
    public VisitorAction visit(ChildParent childParent) {
        return visit(((org.dmg.pmml.PMMLObject) childParent));
    }

    @Override
    public VisitorAction visit(CityBlock cityBlock) {
        return visit(((org.dmg.pmml.Distance) cityBlock));
    }

    @Override
    public VisitorAction visit(ClassLabels classLabels) {
        return visit(((org.dmg.pmml.PMMLObject) classLabels));
    }

    @Override
    public VisitorAction visit(Cluster cluster) {
        return visit(((org.dmg.pmml.Entity) cluster));
    }

    @Override
    public VisitorAction visit(ClusteringField clusteringField) {
        return visit(((org.dmg.pmml.ComparisonField) clusteringField));
    }

    @Override
    public VisitorAction visit(ClusteringModel clusteringModel) {
        return visit(((org.dmg.pmml.Model) clusteringModel));
    }

    @Override
    public VisitorAction visit(ClusteringModelQuality clusteringModelQuality) {
        return visit(((ModelQuality) clusteringModelQuality));
    }

    @Override
    public VisitorAction visit(Coefficient coefficient) {
        return visit(((org.dmg.pmml.PMMLObject) coefficient));
    }

    @Override
    public VisitorAction visit(Coefficients coefficients) {
        return visit(((org.dmg.pmml.PMMLObject) coefficients));
    }

    @Override
    public VisitorAction visit(ComparisonMeasure comparisonMeasure) {
        return visit(((org.dmg.pmml.PMMLObject) comparisonMeasure));
    }

    @Override
    public VisitorAction visit(Comparisons comparisons) {
        return visit(((org.dmg.pmml.PMMLObject) comparisons));
    }

    @Override
    public VisitorAction visit(ComplexNode complexNode) {
        return visit(((org.dmg.pmml.tree.Node) complexNode));
    }

    @Override
    public VisitorAction visit(ComplexPartialScore complexPartialScore) {
        return visit(((org.dmg.pmml.PMMLObject) complexPartialScore));
    }

    @Override
    public VisitorAction visit(ComplexScoreDistribution complexScoreDistribution) {
        return visit(((org.dmg.pmml.ScoreDistribution) complexScoreDistribution));
    }

    @Override
    public VisitorAction visit(CompoundPredicate compoundPredicate) {
        return visit(((org.dmg.pmml.Predicate) compoundPredicate));
    }

    @Override
    public VisitorAction visit(CompoundRule compoundRule) {
        return visit(((org.dmg.pmml.rule_set.Rule) compoundRule));
    }

    @Override
    public VisitorAction visit(ConfusionMatrix confusionMatrix) {
        return visit(((org.dmg.pmml.PMMLObject) confusionMatrix));
    }

    @Override
    public VisitorAction visit(Connection connection) {
        return visit(((org.dmg.pmml.PMMLObject) connection));
    }

    @Override
    public VisitorAction visit(ConsequentSequence consequentSequence) {
        return visit(((org.dmg.pmml.PMMLObject) consequentSequence));
    }

    @Override
    public VisitorAction visit(Constant constant) {
        return visit(((org.dmg.pmml.Expression) constant));
    }

    @Override
    public VisitorAction visit(Constraints constraints) {
        return visit(((org.dmg.pmml.PMMLObject) constraints));
    }

    @Override
    public VisitorAction visit(ContinuousConditionalProbability continuousConditionalProbability) {
        return visit(((org.dmg.pmml.PMMLObject) continuousConditionalProbability));
    }

    @Override
    public VisitorAction visit(org.dmg.pmml.bayesian_network.ContinuousDistribution continuousDistribution) {
        return visit(((org.dmg.pmml.PMMLObject) continuousDistribution));
    }

    @Override
    public VisitorAction visit(ContinuousNode continuousNode) {
        return visit(((org.dmg.pmml.PMMLObject) continuousNode));
    }

    @Override
    public VisitorAction visit(ContStats contStats) {
        return visit(((org.dmg.pmml.PMMLObject) contStats));
    }

    @Override
    public VisitorAction visit(CorrelationFields correlationFields) {
        return visit(((org.dmg.pmml.PMMLObject) correlationFields));
    }

    @Override
    public VisitorAction visit(CorrelationMethods correlationMethods) {
        return visit(((org.dmg.pmml.PMMLObject) correlationMethods));
    }

    @Override
    public VisitorAction visit(Correlations correlations) {
        return visit(((org.dmg.pmml.PMMLObject) correlations));
    }

    @Override
    public VisitorAction visit(CorrelationValues correlationValues) {
        return visit(((org.dmg.pmml.PMMLObject) correlationValues));
    }

    @Override
    public VisitorAction visit(Counts counts) {
        return visit(((org.dmg.pmml.PMMLObject) counts));
    }

    @Override
    public VisitorAction visit(CountTable countTable) {
        return visit(((org.dmg.pmml.DiscreteDistribution) countTable));
    }

    @Override
    public VisitorAction visit(Covariances covariances) {
        return visit(((org.dmg.pmml.PMMLObject) covariances));
    }

    @Override
    public VisitorAction visit(CovariateList covariateList) {
        return visit(((org.dmg.pmml.general_regression.PredictorList) covariateList));
    }

    @Override
    public VisitorAction visit(DataDictionary dataDictionary) {
        return visit(((org.dmg.pmml.PMMLObject) dataDictionary));
    }

    @Override
    public VisitorAction visit(DataField dataField) {
        return visit(((org.dmg.pmml.Field) dataField));
    }

    @Override
    public VisitorAction visit(Decision decision) {
        return visit(((org.dmg.pmml.PMMLObject) decision));
    }

    @Override
    public VisitorAction visit(Decisions decisions) {
        return visit(((org.dmg.pmml.PMMLObject) decisions));
    }

    @Override
    public VisitorAction visit(DecisionTree decisionTree) {
        return visit(((org.dmg.pmml.EmbeddedModel) decisionTree));
    }

    @Override
    public VisitorAction visit(DefineFunction defineFunction) {
        return visit(((org.dmg.pmml.PMMLObject) defineFunction));
    }

    @Override
    public VisitorAction visit(Delimiter delimiter) {
        return visit(((org.dmg.pmml.PMMLObject) delimiter));
    }

    @Override
    public VisitorAction visit(Denominator denominator) {
        return visit(((org.dmg.pmml.PMMLObject) denominator));
    }

    @Override
    public VisitorAction visit(DerivedField derivedField) {
        return visit(((org.dmg.pmml.Field) derivedField));
    }

    @Override
    public VisitorAction visit(DiscreteConditionalProbability discreteConditionalProbability) {
        return visit(((org.dmg.pmml.PMMLObject) discreteConditionalProbability));
    }

    @Override
    public VisitorAction visit(DiscreteNode discreteNode) {
        return visit(((org.dmg.pmml.PMMLObject) discreteNode));
    }

    @Override
    public VisitorAction visit(Discretize discretize) {
        return visit(((org.dmg.pmml.Expression) discretize));
    }

    @Override
    public VisitorAction visit(DiscretizeBin discretizeBin) {
        return visit(((org.dmg.pmml.PMMLObject) discretizeBin));
    }

    @Override
    public VisitorAction visit(DiscrStats discrStats) {
        return visit(((org.dmg.pmml.PMMLObject) discrStats));
    }

    @Override
    public VisitorAction visit(DocumentTermMatrix documentTermMatrix) {
        return visit(((org.dmg.pmml.PMMLObject) documentTermMatrix));
    }

    @Override
    public VisitorAction visit(DynamicRegressor dynamicRegressor) {
        return visit(((org.dmg.pmml.PMMLObject) dynamicRegressor));
    }

    @Override
    public VisitorAction visit(Euclidean euclidean) {
        return visit(((org.dmg.pmml.Distance) euclidean));
    }

    @Override
    public VisitorAction visit(EventValues eventValues) {
        return visit(((org.dmg.pmml.PMMLObject) eventValues));
    }

    @Override
    public VisitorAction visit(ExponentialSmoothing exponentialSmoothing) {
        return visit(((org.dmg.pmml.time_series.TimeSeriesAlgorithm) exponentialSmoothing));
    }

    @Override
    public VisitorAction visit(Extension extension) {
        return visit(((org.dmg.pmml.PMMLObject) extension));
    }

    @Override
    public VisitorAction visit(FactorList factorList) {
        return visit(((org.dmg.pmml.general_regression.PredictorList) factorList));
    }

    @Override
    public VisitorAction visit(False _false) {
        return visit(((org.dmg.pmml.Predicate) _false));
    }

    @Override
    public VisitorAction visit(FieldColumnPair fieldColumnPair) {
        return visit(((org.dmg.pmml.PMMLObject) fieldColumnPair));
    }

    @Override
    public VisitorAction visit(FieldRef fieldRef) {
        return visit(((org.dmg.pmml.Expression) fieldRef));
    }

    @Override
    public VisitorAction visit(FieldValue fieldValue) {
        return visit(((org.dmg.pmml.PMMLObject) fieldValue));
    }

    @Override
    public VisitorAction visit(FieldValueCount fieldValueCount) {
        return visit(((org.dmg.pmml.PMMLObject) fieldValueCount));
    }

    @Override
    public VisitorAction visit(FinalNoise finalNoise) {
        return visit(((org.dmg.pmml.PMMLObject) finalNoise));
    }

    @Override
    public VisitorAction visit(FinalNu finalNu) {
        return visit(((org.dmg.pmml.PMMLObject) finalNu));
    }

    @Override
    public VisitorAction visit(FinalOmega finalOmega) {
        return visit(((org.dmg.pmml.PMMLObject) finalOmega));
    }

    @Override
    public VisitorAction visit(FinalPredictedNoise finalPredictedNoise) {
        return visit(((org.dmg.pmml.PMMLObject) finalPredictedNoise));
    }

    @Override
    public VisitorAction visit(FinalStateVector finalStateVector) {
        return visit(((org.dmg.pmml.PMMLObject) finalStateVector));
    }

    @Override
    public VisitorAction visit(FinalTheta finalTheta) {
        return visit(((org.dmg.pmml.PMMLObject) finalTheta));
    }

    @Override
    public VisitorAction visit(GARCH garch) {
        return visit(((org.dmg.pmml.time_series.TimeSeriesAlgorithm) garch));
    }

    @Override
    public VisitorAction visit(GARCHPart garchPart) {
        return visit(((org.dmg.pmml.PMMLObject) garchPart));
    }

    @Override
    public VisitorAction visit(GaussianDistribution gaussianDistribution) {
        return visit(((org.dmg.pmml.ContinuousDistribution) gaussianDistribution));
    }

    @Override
    public VisitorAction visit(GaussianProcessModel gaussianProcessModel) {
        return visit(((org.dmg.pmml.Model) gaussianProcessModel));
    }

    @Override
    public VisitorAction visit(GeneralizedExponentialKernel generalizedExponentialKernel) {
        return visit(((org.dmg.pmml.PMMLObject) generalizedExponentialKernel));
    }

    @Override
    public VisitorAction visit(GeneralRegressionModel generalRegressionModel) {
        return visit(((org.dmg.pmml.Model) generalRegressionModel));
    }

    @Override
    public VisitorAction visit(Header header) {
        return visit(((org.dmg.pmml.PMMLObject) header));
    }

    @Override
    public VisitorAction visit(HVector hVector) {
        return visit(((org.dmg.pmml.PMMLObject) hVector));
    }

    @Override
    public VisitorAction visit(InlineTable inlineTable) {
        return visit(((org.dmg.pmml.PMMLObject) inlineTable));
    }

    @Override
    public VisitorAction visit(InstanceField instanceField) {
        return visit(((org.dmg.pmml.PMMLObject) instanceField));
    }

    @Override
    public VisitorAction visit(InstanceFields instanceFields) {
        return visit(((org.dmg.pmml.PMMLObject) instanceFields));
    }

    @Override
    public VisitorAction visit(InterceptVector interceptVector) {
        return visit(((org.dmg.pmml.PMMLObject) interceptVector));
    }

    @Override
    public VisitorAction visit(Interval interval) {
        return visit(((org.dmg.pmml.PMMLObject) interval));
    }

    @Override
    public VisitorAction visit(IntSparseArray intSparseArray) {
        return visit(((org.dmg.pmml.SparseArray) intSparseArray));
    }

    @Override
    public VisitorAction visit(Item item) {
        return visit(((org.dmg.pmml.PMMLObject) item));
    }

    @Override
    public VisitorAction visit(ItemRef itemRef) {
        return visit(((org.dmg.pmml.PMMLObject) itemRef));
    }

    @Override
    public VisitorAction visit(Itemset itemset) {
        return visit(((org.dmg.pmml.PMMLObject) itemset));
    }

    @Override
    public VisitorAction visit(Jaccard jaccard) {
        return visit(((org.dmg.pmml.Similarity) jaccard));
    }

    @Override
    public VisitorAction visit(KalmanState kalmanState) {
        return visit(((org.dmg.pmml.PMMLObject) kalmanState));
    }

    @Override
    public VisitorAction visit(KNNInput knnInput) {
        return visit(((org.dmg.pmml.ComparisonField) knnInput));
    }

    @Override
    public VisitorAction visit(KNNInputs knnInputs) {
        return visit(((org.dmg.pmml.PMMLObject) knnInputs));
    }

    @Override
    public VisitorAction visit(KohonenMap kohonenMap) {
        return visit(((org.dmg.pmml.PMMLObject) kohonenMap));
    }

    @Override
    public VisitorAction visit(Lag lag) {
        return visit(((org.dmg.pmml.Expression) lag));
    }

    @Override
    public VisitorAction visit(Lambda lambda) {
        return visit(((org.dmg.pmml.PMMLObject) lambda));
    }

    @Override
    public VisitorAction visit(Level level) {
        return visit(((org.dmg.pmml.PMMLObject) level));
    }

    @Override
    public VisitorAction visit(LiftData liftData) {
        return visit(((org.dmg.pmml.PMMLObject) liftData));
    }

    @Override
    public VisitorAction visit(LiftGraph liftGraph) {
        return visit(((org.dmg.pmml.PMMLObject) liftGraph));
    }

    @Override
    public VisitorAction visit(LinearKernel linearKernel) {
        return visit(((org.dmg.pmml.support_vector_machine.Kernel) linearKernel));
    }

    @Override
    public VisitorAction visit(LinearNorm linearNorm) {
        return visit(((org.dmg.pmml.PMMLObject) linearNorm));
    }

    @Override
    public VisitorAction visit(LocalTransformations localTransformations) {
        return visit(((org.dmg.pmml.PMMLObject) localTransformations));
    }

    @Override
    public VisitorAction visit(LognormalDistribution lognormalDistribution) {
        return visit(((org.dmg.pmml.PMMLObject) lognormalDistribution));
    }

    @Override
    public VisitorAction visit(Lower lower) {
        return visit(((org.dmg.pmml.PMMLObject) lower));
    }

    @Override
    public VisitorAction visit(MA ma) {
        return visit(((org.dmg.pmml.PMMLObject) ma));
    }

    @Override
    public VisitorAction visit(MACoefficients maCoefficients) {
        return visit(((org.dmg.pmml.PMMLObject) maCoefficients));
    }

    @Override
    public VisitorAction visit(MapValues mapValues) {
        return visit(((org.dmg.pmml.Expression) mapValues));
    }

    @Override
    public VisitorAction visit(MatCell matCell) {
        return visit(((org.dmg.pmml.PMMLObject) matCell));
    }

    @Override
    public VisitorAction visit(Matrix matrix) {
        return visit(((org.dmg.pmml.PMMLObject) matrix));
    }

    @Override
    public VisitorAction visit(MaximumLikelihoodStat maximumLikelihoodStat) {
        return visit(((org.dmg.pmml.PMMLObject) maximumLikelihoodStat));
    }

    @Override
    public VisitorAction visit(Mean mean) {
        return visit(((org.dmg.pmml.PMMLObject) mean));
    }

    @Override
    public VisitorAction visit(MeanClusterDistances meanClusterDistances) {
        return visit(((org.dmg.pmml.PMMLObject) meanClusterDistances));
    }

    @Override
    public VisitorAction visit(MeasurementMatrix measurementMatrix) {
        return visit(((org.dmg.pmml.PMMLObject) measurementMatrix));
    }

    @Override
    public VisitorAction visit(MiningBuildTask miningBuildTask) {
        return visit(((org.dmg.pmml.PMMLObject) miningBuildTask));
    }

    @Override
    public VisitorAction visit(MiningField miningField) {
        return visit(((org.dmg.pmml.PMMLObject) miningField));
    }

    @Override
    public VisitorAction visit(MiningModel miningModel) {
        return visit(((org.dmg.pmml.Model) miningModel));
    }

    @Override
    public VisitorAction visit(MiningSchema miningSchema) {
        return visit(((org.dmg.pmml.PMMLObject) miningSchema));
    }

    @Override
    public VisitorAction visit(Minkowski minkowski) {
        return visit(((org.dmg.pmml.Distance) minkowski));
    }

    @Override
    public VisitorAction visit(MissingValueWeights missingValueWeights) {
        return visit(((org.dmg.pmml.PMMLObject) missingValueWeights));
    }

    @Override
    public VisitorAction visit(ModelExplanation modelExplanation) {
        return visit(((org.dmg.pmml.PMMLObject) modelExplanation));
    }

    @Override
    public VisitorAction visit(ModelLiftGraph modelLiftGraph) {
        return visit(((org.dmg.pmml.PMMLObject) modelLiftGraph));
    }

    @Override
    public VisitorAction visit(ModelStats modelStats) {
        return visit(((org.dmg.pmml.PMMLObject) modelStats));
    }

    @Override
    public VisitorAction visit(ModelVerification modelVerification) {
        return visit(((org.dmg.pmml.PMMLObject) modelVerification));
    }

    @Override
    public VisitorAction visit(MultivariateStat multivariateStat) {
        return visit(((org.dmg.pmml.PMMLObject) multivariateStat));
    }

    @Override
    public VisitorAction visit(MultivariateStats multivariateStats) {
        return visit(((Stats) multivariateStats));
    }

    @Override
    public VisitorAction visit(NaiveBayesModel naiveBayesModel) {
        return visit(((org.dmg.pmml.Model) naiveBayesModel));
    }

    @Override
    public VisitorAction visit(NearestNeighborModel nearestNeighborModel) {
        return visit(((org.dmg.pmml.Model) nearestNeighborModel));
    }

    @Override
    public VisitorAction visit(NeuralInput neuralInput) {
        return visit(((org.dmg.pmml.neural_network.NeuralEntity) neuralInput));
    }

    @Override
    public VisitorAction visit(NeuralInputs neuralInputs) {
        return visit(((org.dmg.pmml.PMMLObject) neuralInputs));
    }

    @Override
    public VisitorAction visit(NeuralLayer neuralLayer) {
        return visit(((org.dmg.pmml.PMMLObject) neuralLayer));
    }

    @Override
    public VisitorAction visit(NeuralNetwork neuralNetwork) {
        return visit(((org.dmg.pmml.Model) neuralNetwork));
    }

    @Override
    public VisitorAction visit(NeuralOutput neuralOutput) {
        return visit(((org.dmg.pmml.PMMLObject) neuralOutput));
    }

    @Override
    public VisitorAction visit(NeuralOutputs neuralOutputs) {
        return visit(((org.dmg.pmml.PMMLObject) neuralOutputs));
    }

    @Override
    public VisitorAction visit(Neuron neuron) {
        return visit(((org.dmg.pmml.neural_network.NeuralEntity) neuron));
    }

    @Override
    public VisitorAction visit(NonseasonalComponent nonseasonalComponent) {
        return visit(((org.dmg.pmml.PMMLObject) nonseasonalComponent));
    }

    @Override
    public VisitorAction visit(NonseasonalFactor nonseasonalFactor) {
        return visit(((org.dmg.pmml.PMMLObject) nonseasonalFactor));
    }

    @Override
    public VisitorAction visit(NormalDistribution normalDistribution) {
        return visit(((org.dmg.pmml.PMMLObject) normalDistribution));
    }

    @Override
    public VisitorAction visit(NormContinuous normContinuous) {
        return visit(((org.dmg.pmml.Expression) normContinuous));
    }

    @Override
    public VisitorAction visit(NormDiscrete normDiscrete) {
        return visit(((org.dmg.pmml.Expression) normDiscrete));
    }

    @Override
    public VisitorAction visit(Numerator numerator) {
        return visit(((org.dmg.pmml.PMMLObject) numerator));
    }

    @Override
    public VisitorAction visit(NumericInfo numericInfo) {
        return visit(((org.dmg.pmml.PMMLObject) numericInfo));
    }

    @Override
    public VisitorAction visit(NumericPredictor numericPredictor) {
        return visit(((org.dmg.pmml.regression.Term) numericPredictor));
    }

    @Override
    public VisitorAction visit(ObservationVarianceMatrix observationVarianceMatrix) {
        return visit(((org.dmg.pmml.PMMLObject) observationVarianceMatrix));
    }

    @Override
    public VisitorAction visit(OptimumLiftGraph optimumLiftGraph) {
        return visit(((org.dmg.pmml.PMMLObject) optimumLiftGraph));
    }

    @Override
    public VisitorAction visit(OutlierEffect outlierEffect) {
        return visit(((org.dmg.pmml.PMMLObject) outlierEffect));
    }

    @Override
    public VisitorAction visit(Output output) {
        return visit(((org.dmg.pmml.PMMLObject) output));
    }

    @Override
    public VisitorAction visit(OutputField outputField) {
        return visit(((org.dmg.pmml.Field) outputField));
    }

    @Override
    public VisitorAction visit(PairCounts pairCounts) {
        return visit(((org.dmg.pmml.PMMLObject) pairCounts));
    }

    @Override
    public VisitorAction visit(Parameter parameter) {
        return visit(((org.dmg.pmml.PMMLObject) parameter));
    }

    @Override
    public VisitorAction visit(ParameterField parameterField) {
        return visit(((org.dmg.pmml.Field) parameterField));
    }

    @Override
    public VisitorAction visit(ParameterList parameterList) {
        return visit(((org.dmg.pmml.PMMLObject) parameterList));
    }

    @Override
    public VisitorAction visit(ParamMatrix paramMatrix) {
        return visit(((org.dmg.pmml.PMMLObject) paramMatrix));
    }

    @Override
    public VisitorAction visit(ParentValue parentValue) {
        return visit(((org.dmg.pmml.PMMLObject) parentValue));
    }

    @Override
    public VisitorAction visit(Partition partition) {
        return visit(((org.dmg.pmml.PMMLObject) partition));
    }

    @Override
    public VisitorAction visit(PartitionFieldStats partitionFieldStats) {
        return visit(((org.dmg.pmml.PMMLObject) partitionFieldStats));
    }

    @Override
    public VisitorAction visit(PastVariances pastVariances) {
        return visit(((org.dmg.pmml.PMMLObject) pastVariances));
    }

    @Override
    public VisitorAction visit(PCell pCell) {
        return visit(((org.dmg.pmml.general_regression.ParameterCell) pCell));
    }

    @Override
    public VisitorAction visit(PCovCell pCovCell) {
        return visit(((org.dmg.pmml.PMMLObject) pCovCell));
    }

    @Override
    public VisitorAction visit(PCovMatrix pCovMatrix) {
        return visit(((org.dmg.pmml.PMMLObject) pCovMatrix));
    }

    @Override
    public VisitorAction visit(PMML pmml) {
        return visit(((org.dmg.pmml.PMMLObject) pmml));
    }

    @Override
    public VisitorAction visit(PoissonDistribution poissonDistribution) {
        return visit(((org.dmg.pmml.ContinuousDistribution) poissonDistribution));
    }

    @Override
    public VisitorAction visit(PolynomialKernel polynomialKernel) {
        return visit(((org.dmg.pmml.support_vector_machine.Kernel) polynomialKernel));
    }

    @Override
    public VisitorAction visit(PPCell ppCell) {
        return visit(((org.dmg.pmml.general_regression.ParameterCell) ppCell));
    }

    @Override
    public VisitorAction visit(PPMatrix ppMatrix) {
        return visit(((org.dmg.pmml.PMMLObject) ppMatrix));
    }

    @Override
    public VisitorAction visit(PredictedStateCovarianceMatrix predictedStateCovarianceMatrix) {
        return visit(((org.dmg.pmml.PMMLObject) predictedStateCovarianceMatrix));
    }

    @Override
    public VisitorAction visit(PredictiveModelQuality predictiveModelQuality) {
        return visit(((ModelQuality) predictiveModelQuality));
    }

    @Override
    public VisitorAction visit(Predictor predictor) {
        return visit(((org.dmg.pmml.PMMLObject) predictor));
    }

    @Override
    public VisitorAction visit(PredictorTerm predictorTerm) {
        return visit(((org.dmg.pmml.regression.Term) predictorTerm));
    }

    @Override
    public VisitorAction visit(PsiVector psiVector) {
        return visit(((org.dmg.pmml.PMMLObject) psiVector));
    }

    @Override
    public VisitorAction visit(Quantile quantile) {
        return visit(((org.dmg.pmml.PMMLObject) quantile));
    }

    @Override
    public VisitorAction visit(org.dmg.pmml.gaussian_process.RadialBasisKernel radialBasisKernel) {
        return visit(((org.dmg.pmml.PMMLObject) radialBasisKernel));
    }

    @Override
    public VisitorAction visit(org.dmg.pmml.support_vector_machine.RadialBasisKernel radialBasisKernel) {
        return visit(((org.dmg.pmml.support_vector_machine.Kernel) radialBasisKernel));
    }

    @Override
    public VisitorAction visit(RandomLiftGraph randomLiftGraph) {
        return visit(((org.dmg.pmml.PMMLObject) randomLiftGraph));
    }

    @Override
    public VisitorAction visit(RealSparseArray realSparseArray) {
        return visit(((org.dmg.pmml.SparseArray) realSparseArray));
    }

    @Override
    public VisitorAction visit(Regression regression) {
        return visit(((org.dmg.pmml.EmbeddedModel) regression));
    }

    @Override
    public VisitorAction visit(RegressionModel regressionModel) {
        return visit(((org.dmg.pmml.Model) regressionModel));
    }

    @Override
    public VisitorAction visit(RegressionTable regressionTable) {
        return visit(((org.dmg.pmml.PMMLObject) regressionTable));
    }

    @Override
    public VisitorAction visit(RegressorValues regressorValues) {
        return visit(((org.dmg.pmml.PMMLObject) regressorValues));
    }

    @Override
    public VisitorAction visit(Residuals residuals) {
        return visit(((org.dmg.pmml.PMMLObject) residuals));
    }

    @Override
    public VisitorAction visit(ResidualSquareCoefficients residualSquareCoefficients) {
        return visit(((org.dmg.pmml.PMMLObject) residualSquareCoefficients));
    }

    @Override
    public VisitorAction visit(ResultField resultField) {
        return visit(((org.dmg.pmml.Field) resultField));
    }

    @Override
    public VisitorAction visit(ROC roc) {
        return visit(((org.dmg.pmml.PMMLObject) roc));
    }

    @Override
    public VisitorAction visit(ROCGraph rocGraph) {
        return visit(((org.dmg.pmml.PMMLObject) rocGraph));
    }

    @Override
    public VisitorAction visit(Row row) {
        return visit(((org.dmg.pmml.PMMLObject) row));
    }

    @Override
    public VisitorAction visit(RuleSelectionMethod ruleSelectionMethod) {
        return visit(((org.dmg.pmml.PMMLObject) ruleSelectionMethod));
    }

    @Override
    public VisitorAction visit(RuleSet ruleSet) {
        return visit(((org.dmg.pmml.PMMLObject) ruleSet));
    }

    @Override
    public VisitorAction visit(RuleSetModel ruleSetModel) {
        return visit(((org.dmg.pmml.Model) ruleSetModel));
    }

    @Override
    public VisitorAction visit(Scorecard scorecard) {
        return visit(((org.dmg.pmml.Model) scorecard));
    }

    @Override
    public VisitorAction visit(SeasonalComponent seasonalComponent) {
        return visit(((org.dmg.pmml.PMMLObject) seasonalComponent));
    }

    @Override
    public VisitorAction visit(SeasonalFactor seasonalFactor) {
        return visit(((org.dmg.pmml.PMMLObject) seasonalFactor));
    }

    @Override
    public VisitorAction visit(SeasonalityExpoSmooth seasonalityExpoSmooth) {
        return visit(((org.dmg.pmml.PMMLObject) seasonalityExpoSmooth));
    }

    @Override
    public VisitorAction visit(SeasonalTrendDecomposition seasonalTrendDecomposition) {
        return visit(((org.dmg.pmml.time_series.TimeSeriesAlgorithm) seasonalTrendDecomposition));
    }

    @Override
    public VisitorAction visit(Segment segment) {
        return visit(((org.dmg.pmml.Entity) segment));
    }

    @Override
    public VisitorAction visit(Segmentation segmentation) {
        return visit(((org.dmg.pmml.PMMLObject) segmentation));
    }

    @Override
    public VisitorAction visit(SelectedStateCovarianceMatrix selectedStateCovarianceMatrix) {
        return visit(((org.dmg.pmml.PMMLObject) selectedStateCovarianceMatrix));
    }

    @Override
    public VisitorAction visit(Sequence sequence) {
        return visit(((org.dmg.pmml.PMMLObject) sequence));
    }

    @Override
    public VisitorAction visit(SequenceModel sequenceModel) {
        return visit(((org.dmg.pmml.Model) sequenceModel));
    }

    @Override
    public VisitorAction visit(SequenceReference sequenceReference) {
        return visit(((org.dmg.pmml.PMMLObject) sequenceReference));
    }

    @Override
    public VisitorAction visit(SequenceRule sequenceRule) {
        return visit(((org.dmg.pmml.Entity) sequenceRule));
    }

    @Override
    public VisitorAction visit(SetPredicate setPredicate) {
        return visit(((org.dmg.pmml.PMMLObject) setPredicate));
    }

    @Override
    public VisitorAction visit(SetReference setReference) {
        return visit(((org.dmg.pmml.PMMLObject) setReference));
    }

    @Override
    public VisitorAction visit(SigmoidKernel sigmoidKernel) {
        return visit(((org.dmg.pmml.support_vector_machine.Kernel) sigmoidKernel));
    }

    @Override
    public VisitorAction visit(SimpleMatching simpleMatching) {
        return visit(((org.dmg.pmml.Similarity) simpleMatching));
    }

    @Override
    public VisitorAction visit(SimplePredicate simplePredicate) {
        return visit(((org.dmg.pmml.Predicate) simplePredicate));
    }

    @Override
    public VisitorAction visit(SimpleRule simpleRule) {
        return visit(((org.dmg.pmml.rule_set.Rule) simpleRule));
    }

    @Override
    public VisitorAction visit(SimpleSetPredicate simpleSetPredicate) {
        return visit(((org.dmg.pmml.Predicate) simpleSetPredicate));
    }

    @Override
    public VisitorAction visit(SpectralAnalysis spectralAnalysis) {
        return visit(((org.dmg.pmml.time_series.TimeSeriesAlgorithm) spectralAnalysis));
    }

    @Override
    public VisitorAction visit(SquaredEuclidean squaredEuclidean) {
        return visit(((org.dmg.pmml.Distance) squaredEuclidean));
    }

    @Override
    public VisitorAction visit(StateSpaceModel stateSpaceModel) {
        return visit(((org.dmg.pmml.time_series.TimeSeriesAlgorithm) stateSpaceModel));
    }

    @Override
    public VisitorAction visit(StateVector stateVector) {
        return visit(((org.dmg.pmml.PMMLObject) stateVector));
    }

    @Override
    public VisitorAction visit(SupportVector supportVector) {
        return visit(((org.dmg.pmml.PMMLObject) supportVector));
    }

    @Override
    public VisitorAction visit(SupportVectorMachine supportVectorMachine) {
        return visit(((org.dmg.pmml.PMMLObject) supportVectorMachine));
    }

    @Override
    public VisitorAction visit(SupportVectorMachineModel supportVectorMachineModel) {
        return visit(((org.dmg.pmml.Model) supportVectorMachineModel));
    }

    @Override
    public VisitorAction visit(SupportVectors supportVectors) {
        return visit(((org.dmg.pmml.PMMLObject) supportVectors));
    }

    @Override
    public VisitorAction visit(TableLocator tableLocator) {
        return visit(((org.dmg.pmml.PMMLObject) tableLocator));
    }

    @Override
    public VisitorAction visit(Tanimoto tanimoto) {
        return visit(((org.dmg.pmml.Similarity) tanimoto));
    }

    @Override
    public VisitorAction visit(Target target) {
        return visit(((org.dmg.pmml.PMMLObject) target));
    }

    @Override
    public VisitorAction visit(Targets targets) {
        return visit(((org.dmg.pmml.PMMLObject) targets));
    }

    @Override
    public VisitorAction visit(TargetValue targetValue) {
        return visit(((org.dmg.pmml.PMMLObject) targetValue));
    }

    @Override
    public VisitorAction visit(TargetValueCount targetValueCount) {
        return visit(((org.dmg.pmml.PMMLObject) targetValueCount));
    }

    @Override
    public VisitorAction visit(TargetValueCounts targetValueCounts) {
        return visit(((org.dmg.pmml.PMMLObject) targetValueCounts));
    }

    @Override
    public VisitorAction visit(TargetValueStat targetValueStat) {
        return visit(((org.dmg.pmml.PMMLObject) targetValueStat));
    }

    @Override
    public VisitorAction visit(TargetValueStats targetValueStats) {
        return visit(((org.dmg.pmml.PMMLObject) targetValueStats));
    }

    @Override
    public VisitorAction visit(Taxonomy taxonomy) {
        return visit(((org.dmg.pmml.PMMLObject) taxonomy));
    }

    @Override
    public VisitorAction visit(TestDistributions testDistributions) {
        return visit(((org.dmg.pmml.PMMLObject) testDistributions));
    }

    @Override
    public VisitorAction visit(TextCorpus textCorpus) {
        return visit(((org.dmg.pmml.PMMLObject) textCorpus));
    }

    @Override
    public VisitorAction visit(TextDictionary textDictionary) {
        return visit(((org.dmg.pmml.PMMLObject) textDictionary));
    }

    @Override
    public VisitorAction visit(TextDocument textDocument) {
        return visit(((org.dmg.pmml.PMMLObject) textDocument));
    }

    @Override
    public VisitorAction visit(TextIndex textIndex) {
        return visit(((org.dmg.pmml.Expression) textIndex));
    }

    @Override
    public VisitorAction visit(TextIndexNormalization textIndexNormalization) {
        return visit(((org.dmg.pmml.PMMLObject) textIndexNormalization));
    }

    @Override
    public VisitorAction visit(TextModel textModel) {
        return visit(((org.dmg.pmml.Model) textModel));
    }

    @Override
    public VisitorAction visit(TextModelNormalization textModelNormalization) {
        return visit(((org.dmg.pmml.PMMLObject) textModelNormalization));
    }

    @Override
    public VisitorAction visit(TextModelSimiliarity textModelSimiliarity) {
        return visit(((org.dmg.pmml.PMMLObject) textModelSimiliarity));
    }

    @Override
    public VisitorAction visit(Theta theta) {
        return visit(((org.dmg.pmml.PMMLObject) theta));
    }

    @Override
    public VisitorAction visit(ThetaRecursionState thetaRecursionState) {
        return visit(((org.dmg.pmml.PMMLObject) thetaRecursionState));
    }

    @Override
    public VisitorAction visit(Time time) {
        return visit(((org.dmg.pmml.PMMLObject) time));
    }

    @Override
    public VisitorAction visit(TimeAnchor timeAnchor) {
        return visit(((org.dmg.pmml.PMMLObject) timeAnchor));
    }

    @Override
    public VisitorAction visit(TimeCycle timeCycle) {
        return visit(((org.dmg.pmml.PMMLObject) timeCycle));
    }

    @Override
    public VisitorAction visit(TimeException timeException) {
        return visit(((org.dmg.pmml.PMMLObject) timeException));
    }

    @Override
    public VisitorAction visit(TimeSeries timeSeries) {
        return visit(((org.dmg.pmml.PMMLObject) timeSeries));
    }

    @Override
    public VisitorAction visit(TimeSeriesModel timeSeriesModel) {
        return visit(((org.dmg.pmml.Model) timeSeriesModel));
    }

    @Override
    public VisitorAction visit(Timestamp timestamp) {
        return visit(((org.dmg.pmml.PMMLObject) timestamp));
    }

    @Override
    public VisitorAction visit(TimeValue timeValue) {
        return visit(((org.dmg.pmml.PMMLObject) timeValue));
    }

    @Override
    public VisitorAction visit(TrainingInstances trainingInstances) {
        return visit(((org.dmg.pmml.PMMLObject) trainingInstances));
    }

    @Override
    public VisitorAction visit(TransferFunctionValues transferFunctionValues) {
        return visit(((org.dmg.pmml.PMMLObject) transferFunctionValues));
    }

    @Override
    public VisitorAction visit(TransformationDictionary transformationDictionary) {
        return visit(((org.dmg.pmml.PMMLObject) transformationDictionary));
    }

    @Override
    public VisitorAction visit(TransitionMatrix transitionMatrix) {
        return visit(((org.dmg.pmml.PMMLObject) transitionMatrix));
    }

    @Override
    public VisitorAction visit(TreeModel treeModel) {
        return visit(((org.dmg.pmml.Model) treeModel));
    }

    @Override
    public VisitorAction visit(TrendCoefficients trendCoefficients) {
        return visit(((org.dmg.pmml.PMMLObject) trendCoefficients));
    }

    @Override
    public VisitorAction visit(TrendExpoSmooth trendExpoSmooth) {
        return visit(((org.dmg.pmml.PMMLObject) trendExpoSmooth));
    }

    @Override
    public VisitorAction visit(TriangularDistribution triangularDistribution) {
        return visit(((org.dmg.pmml.PMMLObject) triangularDistribution));
    }

    @Override
    public VisitorAction visit(True _true) {
        return visit(((org.dmg.pmml.Predicate) _true));
    }

    @Override
    public VisitorAction visit(org.dmg.pmml.bayesian_network.UniformDistribution uniformDistribution) {
        return visit(((org.dmg.pmml.PMMLObject) uniformDistribution));
    }

    @Override
    public VisitorAction visit(org.dmg.pmml.UniformDistribution uniformDistribution) {
        return visit(((org.dmg.pmml.ContinuousDistribution) uniformDistribution));
    }

    @Override
    public VisitorAction visit(UnivariateStats univariateStats) {
        return visit(((Stats) univariateStats));
    }

    @Override
    public VisitorAction visit(Upper upper) {
        return visit(((org.dmg.pmml.PMMLObject) upper));
    }

    @Override
    public VisitorAction visit(Value value) {
        return visit(((org.dmg.pmml.PMMLObject) value));
    }

    @Override
    public VisitorAction visit(ValueProbability valueProbability) {
        return visit(((org.dmg.pmml.PMMLObject) valueProbability));
    }

    @Override
    public VisitorAction visit(VariableWeight variableWeight) {
        return visit(((org.dmg.pmml.PMMLObject) variableWeight));
    }

    @Override
    public VisitorAction visit(Variance variance) {
        return visit(((org.dmg.pmml.PMMLObject) variance));
    }

    @Override
    public VisitorAction visit(VarianceCoefficients varianceCoefficients) {
        return visit(((org.dmg.pmml.PMMLObject) varianceCoefficients));
    }

    @Override
    public VisitorAction visit(VectorDictionary vectorDictionary) {
        return visit(((org.dmg.pmml.PMMLObject) vectorDictionary));
    }

    @Override
    public VisitorAction visit(VectorFields vectorFields) {
        return visit(((org.dmg.pmml.PMMLObject) vectorFields));
    }

    @Override
    public VisitorAction visit(VectorInstance vectorInstance) {
        return visit(((org.dmg.pmml.PMMLObject) vectorInstance));
    }

    @Override
    public VisitorAction visit(VerificationField verificationField) {
        return visit(((org.dmg.pmml.PMMLObject) verificationField));
    }

    @Override
    public VisitorAction visit(VerificationFields verificationFields) {
        return visit(((org.dmg.pmml.PMMLObject) verificationFields));
    }

    @Override
    public VisitorAction visit(XCoordinates xCoordinates) {
        return visit(((org.dmg.pmml.PMMLObject) xCoordinates));
    }

    @Override
    public VisitorAction visit(YCoordinates yCoordinates) {
        return visit(((org.dmg.pmml.PMMLObject) yCoordinates));
    }

}
