
package org.dmg.pmml.naive_bayes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasTargetFieldReference;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Optional;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "BayesOutput", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "targetValueCounts"
})
@JsonRootName("BayesOutput")
@JsonPropertyOrder({
    "targetField",
    "extensions",
    "targetValueCounts"
})
public class BayesOutput
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<BayesOutput> , HasTargetFieldReference<BayesOutput>
{

    @XmlAttribute(name = "fieldName")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @Optional((org.dmg.pmml.Version.XPMML))
    @JsonProperty("fieldName")
    private String targetField;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "TargetValueCounts", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("TargetValueCounts")
    private TargetValueCounts targetValueCounts;
    private final static long serialVersionUID = 67371270L;

    public BayesOutput() {
    }

    @ValueConstructor
    public BayesOutput(
        @org.jpmml.model.annotations.Property("targetValueCounts")
        TargetValueCounts targetValueCounts) {
        this.targetValueCounts = targetValueCounts;
    }

    @Override
    public String getTargetField() {
        return targetField;
    }

    @Override
    public BayesOutput setTargetField(
        @org.jpmml.model.annotations.Property("targetField")
        String targetField) {
        this.targetField = targetField;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public BayesOutput addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public TargetValueCounts requireTargetValueCounts() {
        if (this.targetValueCounts == null) {
            throw new MissingElementException(this, PMMLElements.BAYESOUTPUT_TARGETVALUECOUNTS);
        }
        return this.targetValueCounts;
    }

    public TargetValueCounts getTargetValueCounts() {
        return targetValueCounts;
    }

    public BayesOutput setTargetValueCounts(
        @org.jpmml.model.annotations.Property("targetValueCounts")
        TargetValueCounts targetValueCounts) {
        this.targetValueCounts = targetValueCounts;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getTargetValueCounts());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
