
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.model.annotations.Property;

@XmlRootElement(name = "UnivariateStats", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "counts",
    "numericInfo",
    "discrStats",
    "contStats",
    "anova"
})
@JsonRootName("UnivariateStats")
@JsonPropertyOrder({
    "field",
    "weighted",
    "extensions",
    "counts",
    "numericInfo",
    "discrStats",
    "contStats",
    "anova"
})
public class UnivariateStats
    extends Stats
    implements HasExtensions<UnivariateStats> , HasFieldReference<UnivariateStats>
{

    @XmlAttribute(name = "field")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("field")
    private String field;
    @XmlAttribute(name = "weighted")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("weighted")
    private UnivariateStats.Weighted weighted;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "Counts", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Counts")
    private Counts counts;
    @XmlElement(name = "NumericInfo", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("NumericInfo")
    private NumericInfo numericInfo;
    @XmlElement(name = "DiscrStats", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("DiscrStats")
    private DiscrStats discrStats;
    @XmlElement(name = "ContStats", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ContStats")
    private ContStats contStats;
    @XmlElement(name = "Anova", namespace = "http://www.dmg.org/PMML-4_4")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("Anova")
    private Anova anova;
    private final static long serialVersionUID = 67371270L;

    @Override
    public String getField() {
        return field;
    }

    @Override
    public UnivariateStats setField(
        @Property("field")
        String field) {
        this.field = field;
        return this;
    }

    public UnivariateStats.Weighted getWeighted() {
        if (weighted == null) {
            return UnivariateStats.Weighted.ZERO;
        } else {
            return weighted;
        }
    }

    public UnivariateStats setWeighted(
        @Property("weighted")
        UnivariateStats.Weighted weighted) {
        this.weighted = weighted;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public UnivariateStats addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public Counts getCounts() {
        return counts;
    }

    public UnivariateStats setCounts(
        @Property("counts")
        Counts counts) {
        this.counts = counts;
        return this;
    }

    public NumericInfo getNumericInfo() {
        return numericInfo;
    }

    public UnivariateStats setNumericInfo(
        @Property("numericInfo")
        NumericInfo numericInfo) {
        this.numericInfo = numericInfo;
        return this;
    }

    public DiscrStats getDiscrStats() {
        return discrStats;
    }

    public UnivariateStats setDiscrStats(
        @Property("discrStats")
        DiscrStats discrStats) {
        this.discrStats = discrStats;
        return this;
    }

    public ContStats getContStats() {
        return contStats;
    }

    public UnivariateStats setContStats(
        @Property("contStats")
        ContStats contStats) {
        this.contStats = contStats;
        return this;
    }

    public Anova getAnova() {
        return anova;
    }

    public UnivariateStats setAnova(
        @Property("anova")
        Anova anova) {
        this.anova = anova;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getCounts(), getNumericInfo(), getDiscrStats(), getContStats(), getAnova());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Weighted
        implements StringValue<UnivariateStats.Weighted>
    {

        @XmlEnumValue("0")
        @JsonProperty("0")
        ZERO("0"),
        @XmlEnumValue("1")
        @JsonProperty("1")
        ONE("1");
        private final String value;

        Weighted(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static UnivariateStats.Weighted fromValue(String v) {
            for (UnivariateStats.Weighted c: UnivariateStats.Weighted.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
