
package org.dmg.pmml.time_series;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.NonNegativeIntegerAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "SeasonalComponent", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "ar",
    "ma"
})
@Added((org.dmg.pmml.Version.PMML_4_4))
@JsonRootName("SeasonalComponent")
@JsonPropertyOrder({
    "p",
    "d",
    "q",
    "period",
    "extensions",
    "ar",
    "ma"
})
public class SeasonalComponent
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<SeasonalComponent>
{

    @XmlAttribute(name = "P")
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("P")
    private Integer p;
    @XmlAttribute(name = "D")
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("D")
    private Integer d;
    @XmlAttribute(name = "Q")
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("Q")
    private Integer q;
    @XmlAttribute(name = "period", required = true)
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("period")
    private Integer period;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "AR", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("AR")
    private AR ar;
    @XmlElement(name = "MA", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("MA")
    private MA ma;
    private final static Integer DEFAULT_P = new NonNegativeIntegerAdapter().unmarshal("0");
    private final static Integer DEFAULT_D = new NonNegativeIntegerAdapter().unmarshal("0");
    private final static Integer DEFAULT_Q = new NonNegativeIntegerAdapter().unmarshal("0");
    private final static long serialVersionUID = 67371268L;

    public SeasonalComponent() {
    }

    @ValueConstructor
    public SeasonalComponent(
        @org.jpmml.model.annotations.Property("period")
        Integer period) {
        this.period = period;
    }

    public Integer getP() {
        if (p == null) {
            return DEFAULT_P;
        } else {
            return p;
        }
    }

    public SeasonalComponent setP(
        @org.jpmml.model.annotations.Property("p")
        Integer p) {
        this.p = p;
        return this;
    }

    public Integer getD() {
        if (d == null) {
            return DEFAULT_D;
        } else {
            return d;
        }
    }

    public SeasonalComponent setD(
        @org.jpmml.model.annotations.Property("d")
        Integer d) {
        this.d = d;
        return this;
    }

    public Integer getQ() {
        if (q == null) {
            return DEFAULT_Q;
        } else {
            return q;
        }
    }

    public SeasonalComponent setQ(
        @org.jpmml.model.annotations.Property("q")
        Integer q) {
        this.q = q;
        return this;
    }

    public Integer getPeriod() {
        return period;
    }

    public SeasonalComponent setPeriod(
        @org.jpmml.model.annotations.Property("period")
        Integer period) {
        this.period = period;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public SeasonalComponent addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public AR getAR() {
        return ar;
    }

    public SeasonalComponent setAR(
        @org.jpmml.model.annotations.Property("ar")
        AR ar) {
        this.ar = ar;
        return this;
    }

    public MA getMA() {
        return ma;
    }

    public SeasonalComponent setMA(
        @org.jpmml.model.annotations.Property("ma")
        MA ma) {
        this.ma = ma;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getAR(), getMA());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
