
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "VerificationFields", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "verificationFields"
})
@JsonRootName("VerificationFields")
@JsonPropertyOrder({
    "extensions",
    "verificationFields"
})
public class VerificationFields
    extends org.dmg.pmml.PMMLObject
    implements Iterable<VerificationField> , HasExtensions<VerificationFields>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "VerificationField", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("VerificationField")
    private List<VerificationField> verificationFields;
    private final static long serialVersionUID = 67371268L;

    public VerificationFields() {
    }

    @ValueConstructor
    public VerificationFields(
        @Property("verificationFields")
        List<VerificationField> verificationFields) {
        this.verificationFields = verificationFields;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public VerificationFields addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public Iterator<VerificationField> iterator() {
        return getVerificationFields().iterator();
    }

    public boolean hasVerificationFields() {
        return ((this.verificationFields!= null)&&(this.verificationFields.size()> 0));
    }

    public List<VerificationField> getVerificationFields() {
        if (verificationFields == null) {
            verificationFields = new ArrayList<VerificationField>();
        }
        return this.verificationFields;
    }

    public VerificationFields addVerificationFields(VerificationField... verificationFields) {
        getVerificationFields().addAll(Arrays.asList(verificationFields));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasVerificationFields()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getVerificationFields());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
