/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.SparseArray;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.IntegerAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"indices", "entries"})
@XmlRootElement(name="INT-SparseArray", namespace="http://www.dmg.org/PMML-4_2")
public class IntSparseArray
extends SparseArray<Integer> {
    @XmlAttribute(name="n")
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    protected Integer n;
    @XmlAttribute(name="defaultValue")
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    protected Integer defaultValue;
    @XmlList
    @XmlElement(name="Indices", namespace="http://www.dmg.org/PMML-4_2", type=Integer.class)
    protected List<Integer> indices;
    @XmlList
    @XmlElement(name="INT-Entries", namespace="http://www.dmg.org/PMML-4_2", type=Integer.class)
    protected List<Integer> entries;

    @Override
    public Integer getN() {
        return this.n;
    }

    @Override
    public void setN(Integer value) {
        this.n = value;
    }

    public int getDefaultValue() {
        if (this.defaultValue == null) {
            return new IntegerAdapter().unmarshal("0");
        }
        return this.defaultValue;
    }

    public void setDefaultValue(Integer value) {
        this.defaultValue = value;
    }

    @Override
    public List<Integer> getIndices() {
        if (this.indices == null) {
            this.indices = new ArrayList<Integer>();
        }
        return this.indices;
    }

    @Override
    public List<Integer> getEntries() {
        if (this.entries == null) {
            this.entries = new ArrayList<Integer>();
        }
        return this.entries;
    }

    public IntSparseArray withN(Integer value) {
        this.setN(value);
        return this;
    }

    public IntSparseArray withDefaultValue(Integer value) {
        this.setDefaultValue(value);
        return this;
    }

    public IntSparseArray withIndices(Integer ... values) {
        if (values != null) {
            for (Integer value : values) {
                this.getIndices().add(value);
            }
        }
        return this;
    }

    public IntSparseArray withIndices(Collection<Integer> values) {
        if (values != null) {
            this.getIndices().addAll(values);
        }
        return this;
    }

    public IntSparseArray withEntries(Integer ... values) {
        if (values != null) {
            for (Integer value : values) {
                this.getEntries().add(value);
            }
        }
        return this;
    }

    public IntSparseArray withEntries(Collection<Integer> values) {
        if (values != null) {
            this.getEntries().addAll(values);
        }
        return this;
    }

    public boolean hasIndices() {
        return this.indices != null && this.indices.size() > 0;
    }

    public boolean hasEntries() {
        return this.entries != null && this.entries.size() > 0;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

