/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.spark;

import java.util.List;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.VectorUDT;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.HasProbability;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.spark.ColumnProducer;

class ProbabilityColumnProducer
extends ColumnProducer<TargetField> {
    private List<String> labels = null;

    ProbabilityColumnProducer(TargetField field, String columnName, List<String> labels) {
        super(field, columnName != null ? columnName : "probability");
        this.setLabels(labels);
    }

    @Override
    public StructField init(Evaluator evaluator) {
        return DataTypes.createStructField((String)this.getColumnName(), (DataType)new VectorUDT(), (boolean)false);
    }

    public Vector format(Object value) {
        List<String> labels = this.getLabels();
        HasProbability hasProbability = (HasProbability)value;
        double[] probabilities = new double[labels.size()];
        for (int i = 0; i < labels.size(); ++i) {
            String label = labels.get(i);
            probabilities[i] = hasProbability.getProbability(label);
        }
        return new DenseVector(probabilities);
    }

    public List<String> getLabels() {
        return this.labels;
    }

    private void setLabels(List<String> labels) {
        this.labels = labels;
    }
}

