/*
 * ===========================================
 * Java Pdf Extraction Decoding Access Library
 * ===========================================
 *
 * Project Info:  http://www.idrsolutions.com
 * Help section for developers at http://www.idrsolutions.com/support/
 *
 * (C) Copyright 1997-2015 IDRsolutions and Contributors.
 *
 * This file is part of JPedal/JPDF2HTML5
 *
     This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


 *
 * ---------------
 * CIDEncodings.java
 * ---------------
 */
package org.jpedal.objects.raw;

public class CIDEncodings {

	public static final int CMAP_83pv_RKSJ_H=1763648115;
	public static final int CMAP_90msp_RKSJ_H=1813470326;
	public static final int CMAP_90msp_RKSJ_V=1813470340;
	public static final int CMAP_90ms_RKSJ_H=1713381232;
	public static final int CMAP_90ms_RKSJ_UCS2=2105099041;
	public static final int CMAP_90ms_RKSJ_V=1713381246;
	public static final int CMAP_90pv_RKSJ_H=1763712883;
	public static final int CMAP_90pv_RKSJ_UCS2=-2139339999;
	public static final int CMAP_90pv_RKSJ_UCS2C=2084774291;
	public static final int CMAP_Add_RKSJ_H=1461137511;
	public static final int CMAP_Add_RKSJ_V=1461137525;
	public static final int CMAP_Adobe_CNS1_3=1764904787;
	public static final int CMAP_Adobe_CNS1_UCS2=1971082577;
	public static final int CMAP_Adobe_GB1_4=1145515610;
	public static final int CMAP_Adobe_GB1_UCS2=2069326384;
	public static final int CMAP_Adobe_Japan1_4=-1755020442;
	public static final int CMAP_Adobe_Japan1_UCS2=-2018867323;
	public static final int CMAP_Adobe_Korea1_2=-1955429016;
	public static final int CMAP_Adobe_Korea1_UCS2=-1952541305;
	public static final int CMAP_B5pc_H=1077088029;
	public static final int CMAP_B5pc_UCS2=710104593;
	public static final int CMAP_B5pc_UCS2C=1398149437;
	public static final int CMAP_B5pc_V=1077088043;
	public static final int CMAP_CNS_EUC_H=1127610944;
	public static final int CMAP_CNS_EUC_V=1127610958;
	public static final int CMAP_ETen_B5_H=909785898;
	public static final int CMAP_ETen_B5_UCS2=927554877;
	public static final int CMAP_ETen_B5_V=909785912;
	public static final int CMAP_euc_h=1160969581;
	public static final int CMAP_euc_v=1160969595;
	public static final int CMAP_Ext_RKSJ_H=1729574011;
	public static final int CMAP_Ext_RKSJ_V=1729574025;
	public static final int CMAP_gb_euc_h=2086992493;
	public static final int CMAP_gb_euc_v=2086992507;
	public static final int CMAP_gbk2k_h=41037683;
	public static final int CMAP_gbk2k_v=41037697;
	public static final int CMAP_GBK_EUC_H=925760068;
	public static final int CMAP_GBK_EUC_UCS2=1363824892;
	public static final int CMAP_GBK_EUC_V=925760082;
	public static final int CMAP_GBKp_EUC_H=1079185727;
	public static final int CMAP_GBKp_EUC_V=1079185741;
	public static final int CMAP_GBpc_EUC_H=1699090751;
	public static final int CMAP_GBpc_EUC_UCS2=1282959635;
	public static final int CMAP_GBpc_EUC_UCS2C=2020152159;
	public static final int CMAP_GBpc_EUC_V=1699090765;
	public static final int CMAP_GBT_EUC_H=926349892;
	public static final int CMAP_GBT_EUC_V=926349906;
	public static final int CMAP_h=56;
	public static final int CMAP_HKscs_B5_H=1429755952;
	public static final int CMAP_HKscs_B5_V=1429755966;
	public static final int CMAP_KSC_EUC_H=1210448456;
	public static final int CMAP_KSC_EUC_V=1210448470;
	public static final int CMAP_KSCms_UHC_H=1433476432;
	public static final int CMAP_KSCms_UHC_HW_H=1350331957;
	public static final int CMAP_KSCms_UHC_HW_V=1350331971;
	public static final int CMAP_KSCms_UHC_UCS2=1567134751;
	public static final int CMAP_KSCms_UHC_V=1433476446;
	public static final int CMAP_KSCpc_EUC_H=1700863296;
	public static final int CMAP_KSCpc_EUC_UCS2=1299743775;
	public static final int CMAP_KSCpc_EUC_UCS2C=2021924704;
	public static final int CMAP_UniCNS_UCS2_H=-2076691090;
	public static final int CMAP_UniCNS_UCS2_V=-2076691076;
	public static final int CMAP_UniGB_UCS2_H=1513970498;
	public static final int CMAP_UniGB_UCS2_V=1513970512;
	public static final int CMAP_UniJIS_UCS2_H=-2076689303;
	public static final int CMAP_UniJIS_UCS2_HW_H=1772827988;
	public static final int CMAP_UniJIS_UCS2_HW_V=1772828002;
	public static final int CMAP_UniJIS_UCS2_V=-2076689289;
	public static final int CMAP_UniKS_UCS2_H=1799183174;
	public static final int CMAP_UniKS_UCS2_V=1799183188;
	public static final int CMAP_v=70;

	public static final int CMAP_ETenms_B5_H=1347904586;

	public static final int CMAP_ETenms_B5_V=1347904600;

	public static int getConstant(final int id) {

		switch(id){


		case CMAP_83pv_RKSJ_H :
			return CMAP_83pv_RKSJ_H;

		case CMAP_90msp_RKSJ_H :
			return CMAP_90msp_RKSJ_H;

		case CMAP_90msp_RKSJ_V :
			return CMAP_90msp_RKSJ_V;

		case CMAP_90ms_RKSJ_H :
			return CMAP_90ms_RKSJ_H;

		case CMAP_90ms_RKSJ_UCS2 :
			return CMAP_90ms_RKSJ_UCS2;

		case CMAP_90ms_RKSJ_V :
			return CMAP_90ms_RKSJ_V;

		case CMAP_90pv_RKSJ_H :
			return CMAP_90pv_RKSJ_H;

		case CMAP_90pv_RKSJ_UCS2 :
			return CMAP_90pv_RKSJ_UCS2;

		case CMAP_90pv_RKSJ_UCS2C :
			return CMAP_90pv_RKSJ_UCS2C;

		case CMAP_Add_RKSJ_H :
			return CMAP_Add_RKSJ_H;

		case CMAP_Add_RKSJ_V :
			return CMAP_Add_RKSJ_V;

		case CMAP_Adobe_CNS1_3 :
			return CMAP_Adobe_CNS1_3;

		case CMAP_Adobe_CNS1_UCS2 :
			return CMAP_Adobe_CNS1_UCS2;

		case CMAP_Adobe_GB1_4 :
			return CMAP_Adobe_GB1_4;

		case CMAP_Adobe_GB1_UCS2 :
			return CMAP_Adobe_GB1_UCS2;

		case CMAP_Adobe_Japan1_4 :
			return CMAP_Adobe_Japan1_4;

		case CMAP_Adobe_Japan1_UCS2 :
			return CMAP_Adobe_Japan1_UCS2;

		case CMAP_Adobe_Korea1_2 :
			return CMAP_Adobe_Korea1_2;

		case CMAP_Adobe_Korea1_UCS2 :
			return CMAP_Adobe_Korea1_UCS2;

		case CMAP_B5pc_H :
			return CMAP_B5pc_H;

		case CMAP_B5pc_UCS2 :
			return CMAP_B5pc_UCS2;

		case CMAP_B5pc_UCS2C :
			return CMAP_B5pc_UCS2C;

		case CMAP_B5pc_V :
			return CMAP_B5pc_V;

		case CMAP_CNS_EUC_H :
			return CMAP_CNS_EUC_H;

		case CMAP_CNS_EUC_V :
			return CMAP_CNS_EUC_V;

		case CMAP_ETen_B5_H :
			return CMAP_ETen_B5_H;

		case CMAP_ETen_B5_UCS2 :
			return CMAP_ETen_B5_UCS2;

		case CMAP_ETen_B5_V :
			return CMAP_ETen_B5_V;

		case CMAP_euc_h :
			return CMAP_euc_h;

		case CMAP_euc_v :
			return CMAP_euc_v;

		case CMAP_Ext_RKSJ_H :
			return CMAP_Ext_RKSJ_H;

		case CMAP_Ext_RKSJ_V :
			return CMAP_Ext_RKSJ_V;

		case CMAP_gb_euc_h :
			return CMAP_gb_euc_h;

		case CMAP_gb_euc_v :
			return CMAP_gb_euc_v;

		case CMAP_gbk2k_h :
			return CMAP_gbk2k_h;

		case CMAP_gbk2k_v :
			return CMAP_gbk2k_v;

		case CMAP_GBK_EUC_H :
			return CMAP_GBK_EUC_H;

		case CMAP_GBK_EUC_UCS2 :
			return CMAP_GBK_EUC_UCS2;

		case CMAP_GBK_EUC_V :
			return CMAP_GBK_EUC_V;

		case CMAP_GBKp_EUC_H :
			return CMAP_GBKp_EUC_H;

		case CMAP_GBKp_EUC_V :
			return CMAP_GBKp_EUC_V;

		case CMAP_GBpc_EUC_H :
			return CMAP_GBpc_EUC_H;

		case CMAP_GBpc_EUC_UCS2 :
			return CMAP_GBpc_EUC_UCS2;

		case CMAP_GBpc_EUC_UCS2C :
			return CMAP_GBpc_EUC_UCS2C;

		case CMAP_GBpc_EUC_V :
			return CMAP_GBpc_EUC_V;

		case CMAP_GBT_EUC_H :
			return CMAP_GBT_EUC_H;

		case CMAP_GBT_EUC_V :
			return CMAP_GBT_EUC_V;

		case CMAP_h :
			return CMAP_h;

		case CMAP_HKscs_B5_H :
			return CMAP_HKscs_B5_H;

		case CMAP_HKscs_B5_V :
			return CMAP_HKscs_B5_V;

		case CMAP_KSC_EUC_H :
			return CMAP_KSC_EUC_H;

		case CMAP_KSC_EUC_V :
			return CMAP_KSC_EUC_V;

		case CMAP_KSCms_UHC_H :
			return CMAP_KSCms_UHC_H;

		case CMAP_KSCms_UHC_HW_H :
			return CMAP_KSCms_UHC_HW_H;

		case CMAP_KSCms_UHC_HW_V :
			return CMAP_KSCms_UHC_HW_V;

		case CMAP_KSCms_UHC_UCS2 :
			return CMAP_KSCms_UHC_UCS2;

		case CMAP_KSCms_UHC_V :
			return CMAP_KSCms_UHC_V;

		case CMAP_KSCpc_EUC_H :
			return CMAP_KSCpc_EUC_H;

		case CMAP_KSCpc_EUC_UCS2 :
			return CMAP_KSCpc_EUC_UCS2;

		case CMAP_KSCpc_EUC_UCS2C :
			return CMAP_KSCpc_EUC_UCS2C;

		case CMAP_UniCNS_UCS2_H :
			return CMAP_UniCNS_UCS2_H;

		case CMAP_UniCNS_UCS2_V :
			return CMAP_UniCNS_UCS2_V;

		case CMAP_UniGB_UCS2_H :
			return CMAP_UniGB_UCS2_H;

		case CMAP_UniGB_UCS2_V :
			return CMAP_UniGB_UCS2_V;

		case CMAP_UniJIS_UCS2_H :
			return CMAP_UniJIS_UCS2_H;

		case CMAP_UniJIS_UCS2_HW_H :
			return CMAP_UniJIS_UCS2_HW_H;

		case CMAP_UniJIS_UCS2_HW_V :
			return CMAP_UniJIS_UCS2_HW_V;

		case CMAP_UniJIS_UCS2_V :
			return CMAP_UniJIS_UCS2_V;

		case CMAP_UniKS_UCS2_H :
			return CMAP_UniKS_UCS2_H;

		case CMAP_UniKS_UCS2_V :
			return CMAP_UniKS_UCS2_V;

		case CMAP_v :
			return CMAP_v;

		case CMAP_ETenms_B5_H:
			return CMAP_ETenms_B5_H;

		case CMAP_ETenms_B5_V:
			return CMAP_ETenms_B5_V;
			
		default:	
			return PdfDictionary.Unknown;

		}

	}

    public static String getNameForEncoding(final int encodingType) {

		switch(encodingType){

		case CMAP_83pv_RKSJ_H :
			return "83pv-RKSJ-H";

		case CMAP_90msp_RKSJ_H :
			return "90msp-RKSJ-H";

		case CMAP_90msp_RKSJ_V :
			return "90msp-RKSJ-V";

		case CMAP_90ms_RKSJ_H :
			return "90ms-RKSJ-H";

		case CMAP_90ms_RKSJ_UCS2 :
			return "90ms-RKSJ-UCS2";

		case CMAP_90ms_RKSJ_V :
			return "90ms-RKSJ-V";

		case CMAP_90pv_RKSJ_H :
			return "90pv-RKSJ-H";

		case CMAP_90pv_RKSJ_UCS2 :
			return "90pv-RKSJ-UCS2";

		case CMAP_90pv_RKSJ_UCS2C :
			return "90pv-RKSJ-UCS2C";

		case CMAP_Add_RKSJ_H :
			return "Add-RKSJ-H";

		case CMAP_Add_RKSJ_V :
			return "Add-RKSJ-V";

		case CMAP_Adobe_CNS1_3 :
			return "Adobe-CNS1-3";

		case CMAP_Adobe_CNS1_UCS2 :
			return "Adobe-CNS1-UCS2";

		case CMAP_Adobe_GB1_4 :
			return "Adobe-GB1-4";

		case CMAP_Adobe_GB1_UCS2 :
			return "Adobe-GB1-UCS2";

		case CMAP_Adobe_Japan1_4 :
			return "Adobe-Japan1-4";

		case CMAP_Adobe_Japan1_UCS2 :
			return "Adobe-Japan1-UCS2";

		case CMAP_Adobe_Korea1_2 :
			return "Adobe-Korea1-2";

		case CMAP_Adobe_Korea1_UCS2 :
			return "Adobe-Korea1-UCS2";

		case CMAP_B5pc_H :
			return "B5pc-H";

		case CMAP_B5pc_UCS2 :
			return "B5pc-UCS2";

		case CMAP_B5pc_UCS2C :
			return "B5pc-UCS2C";

		case CMAP_B5pc_V :
			return "B5pc-V";

		case CMAP_CNS_EUC_H :
			return "CNS-EUC-H";

		case CMAP_CNS_EUC_V :
			return "CNS-EUC-V";

		case CMAP_ETen_B5_H :
			return "ETen-B5-H";

		case CMAP_ETen_B5_UCS2 :
			return "ETen-B5-UCS2";

		case CMAP_ETen_B5_V :
			return "ETen-B5-V";

		case CMAP_euc_h :
			return "euc-h";

		case CMAP_euc_v :
			return "euc-v";

		case CMAP_Ext_RKSJ_H :
			return "Ext-RKSJ-H";

		case CMAP_Ext_RKSJ_V :
			return "Ext-RKSJ-V";

		case CMAP_gb_euc_h :
			return "gb-euc-h";

		case CMAP_gb_euc_v :
			return "gb-euc-v";

		case CMAP_gbk2k_h :
			return "gbk2k-h";

		case CMAP_gbk2k_v :
			return "gbk2k-v";

		case CMAP_GBK_EUC_H :
			return "GBK-EUC-H";

		case CMAP_GBK_EUC_UCS2 :
			return "GBK-EUC-UCS2";

		case CMAP_GBK_EUC_V :
			return "GBK-EUC-V";

		case CMAP_GBKp_EUC_H :
			return "GBKp-EUC-H";

		case CMAP_GBKp_EUC_V :
			return "GBKp-EUC-V";

		case CMAP_GBpc_EUC_H :
			return "GBpc-EUC-H";

		case CMAP_GBpc_EUC_UCS2 :
			return "GBpc-EUC-UCS2";

		case CMAP_GBpc_EUC_UCS2C :
			return "GBpc-EUC-UCS2C";

		case CMAP_GBpc_EUC_V :
			return "GBpc-EUC-V";

		case CMAP_GBT_EUC_H :
			return "GBT-EUC-H";

		case CMAP_GBT_EUC_V :
			return "GBT-EUC-V";

		case CMAP_h :
			return "h";

		case CMAP_HKscs_B5_H :
			return "HKscs-B5-H";

		case CMAP_HKscs_B5_V :
			return "HKscs-B5-V";

		case CMAP_KSC_EUC_H :
			return "KSC-EUC-H";

		case CMAP_KSC_EUC_V :
			return "KSC-EUC-V";

		case CMAP_KSCms_UHC_H :
			return "KSCms-UHC-H";

		case CMAP_KSCms_UHC_HW_H :
			return "KSCms-UHC-HW-H";

		case CMAP_KSCms_UHC_HW_V :
			return "KSCms-UHC-HW-V";

		case CMAP_KSCms_UHC_UCS2 :
			return "KSCms-UHC-UCS2";

		case CMAP_KSCms_UHC_V :
			return "KSCms-UHC-V";

		case CMAP_KSCpc_EUC_H :
			return "KSCpc-EUC-H";

		case CMAP_KSCpc_EUC_UCS2 :
			return "KSCpc-EUC-UCS2";

		case CMAP_KSCpc_EUC_UCS2C :
			return "KSCpc-EUC-UCS2C";

		case CMAP_UniCNS_UCS2_H :
			return "UniCNS-UCS2-H";

		case CMAP_UniCNS_UCS2_V :
			return "UniCNS-UCS2-V";

		case CMAP_UniGB_UCS2_H :
			return "UniGB-UCS2-H";

		case CMAP_UniGB_UCS2_V :
			return "UniGB-UCS2-V";

		case CMAP_UniJIS_UCS2_H :
			return "UniJIS-UCS2-H";

		case CMAP_UniJIS_UCS2_HW_H :
			return "UniJIS-UCS2-HW-H";

		case CMAP_UniJIS_UCS2_HW_V :
			return "UniJIS-UCS2-HW-V";

		case CMAP_UniJIS_UCS2_V :
			return "UniJIS-UCS2-V";

		case CMAP_UniKS_UCS2_H :
			return "UniKS-UCS2-H";

		case CMAP_UniKS_UCS2_V :
			return "UniKS-UCS2-V";

		case CMAP_v :
			return "v";

		case CMAP_ETenms_B5_H:
			return "ETen-B5-H";

		case CMAP_ETenms_B5_V:
			return "ETen-B5-V";	
		}
		
		return null;
	}

}
