/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.servlet;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.Part;
import org.jooby.spi.NativeUpload;

public class ServletUpload
implements NativeUpload {
    private Part upload;
    private String tmpdir;
    private File file;

    public ServletUpload(Part upload, String tmpdir) {
        this.upload = Objects.requireNonNull(upload, "A part upload is required.");
        this.tmpdir = Objects.requireNonNull(tmpdir, "A tmpdir is required.");
    }

    public void close() throws IOException {
        if (this.file != null) {
            this.file.delete();
        }
        this.upload.delete();
    }

    public String name() {
        return this.upload.getSubmittedFileName();
    }

    public List<String> headers(String name) {
        Collection headers = this.upload.getHeaders(name.toLowerCase());
        if (headers == null) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf((Collection)headers);
    }

    public File file() throws IOException {
        if (this.file == null) {
            String name = "tmp-" + Long.toHexString(System.currentTimeMillis()) + "." + this.name();
            this.upload.write(name);
            this.file = new File(this.tmpdir, name);
        }
        return this.file;
    }
}

