/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.servlet;

import com.google.inject.Binder;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValueFactory;
import java.util.Objects;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.jooby.Env;
import org.jooby.Jooby;
import org.jooby.servlet.ServletContainer;
import org.jooby.spi.Server;

public class ServerInitializer
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent sce) {
        ServletContext ctx = sce.getServletContext();
        String appClass = ctx.getInitParameter("application.class");
        Objects.requireNonNull(appClass, "Context param NOT found: application.class");
        try {
            Jooby app = (Jooby)ctx.getClassLoader().loadClass(appClass).newInstance();
            app.use(ConfigFactory.empty().withValue("application.path", ConfigValueFactory.fromAnyRef((Object)ctx.getContextPath())).withValue("server.module", ConfigValueFactory.fromAnyRef((Object)ServletModule.class.getName())));
            app.start();
            ctx.setAttribute(Jooby.class.getName(), (Object)app);
        }
        catch (Throwable ex) {
            throw new IllegalStateException("App didn't to start: " + appClass, ex);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        ServletContext ctx = sce.getServletContext();
        Jooby app = (Jooby)ctx.getAttribute(Jooby.class.getName());
        if (app != null) {
            app.stop();
        }
    }

    public static class ServletModule
    implements Jooby.Module {
        public void configure(Env env, Config config, Binder binder) {
            binder.bind(Server.class).toInstance((Object)ServletContainer.NOOP);
        }
    }
}

