/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.hbm;

import java.sql.Connection;
import java.util.function.Consumer;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionImplementor;
import org.jooby.Response;
import org.jooby.Result;
import org.jooby.hbm.OpenSessionInView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrxResponse
extends Response.Forwarding {
    private final Logger log = LoggerFactory.getLogger(OpenSessionInView.class);
    private Session session;
    private EntityManager em;
    private String sessionId;
    private EntityTransaction trx;
    private boolean rollbackOnly;

    public TrxResponse(Response response, EntityManager em) {
        super(response);
        this.em = em;
        this.session = (Session)em.getDelegate();
        this.sessionId = Integer.toHexString(System.identityHashCode(this.session));
    }

    public TrxResponse begin() {
        this.trx = this.em.getTransaction();
        this.log.debug("  [{}] starting transation: {}", (Object)this.sessionId, (Object)this.trx);
        this.trx.begin();
        return this;
    }

    public void setRollbackOnly() {
        this.rollbackOnly = true;
    }

    private void trxSend(Object result) throws Throwable {
        Consumer<Boolean> setReadOnly = readOnly -> {
            try {
                Connection connection = ((SessionImplementor)this.session).connection();
                connection.setReadOnly((boolean)readOnly);
            }
            catch (Exception ex) {
                this.log.trace("  [" + this.sessionId + "] unable to setReadOnly " + readOnly, (Throwable)ex);
            }
            this.session.setDefaultReadOnly(readOnly.booleanValue());
        };
        try {
            this.log.debug("  [{}] flushing", (Object)this.sessionId);
            this.session.flush();
            if (this.trx.isActive()) {
                this.log.debug("  [{}] commiting transaction: {}", (Object)this.sessionId, (Object)this.trx);
                this.trx.commit();
            }
            EntityTransaction readOnlyTrx = null;
            try {
                this.log.debug("  [{}] setting connection to read only", (Object)this.sessionId);
                setReadOnly.accept(true);
                this.session.setFlushMode(FlushMode.MANUAL);
                readOnlyTrx = this.em.getTransaction();
                this.log.debug("  [{}] starting readonly transaction: {}", (Object)this.sessionId, (Object)readOnlyTrx);
                readOnlyTrx.begin();
                this.rsp.send(result);
                this.log.debug("  [{}] commiting readonly transaction: {}", (Object)this.sessionId, (Object)readOnlyTrx);
                readOnlyTrx.commit();
            }
            catch (Throwable ex) {
                if (readOnlyTrx != null && readOnlyTrx.isActive()) {
                    this.log.debug("  [{}] rolling back readonly transaction: {}", (Object)this.sessionId, readOnlyTrx);
                    readOnlyTrx.rollback();
                }
                throw ex;
            }
            finally {
                this.log.debug("  [{}] removing readonly mode from connection", (Object)this.sessionId);
                setReadOnly.accept(false);
            }
        }
        catch (Throwable ex) {
            this.rollbackOnly = true;
            throw ex;
        }
        finally {
            this.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        EntityManager em = this.em;
        if (em == null) {
            return;
        }
        EntityTransaction trx = this.trx;
        this.em = null;
        this.session = null;
        this.trx = null;
        try {
            if (trx.isActive()) {
                if (this.rollbackOnly) {
                    this.log.debug("  [{}] rolling back transation: {}", (Object)this.sessionId, (Object)trx);
                    trx.rollback();
                } else {
                    this.log.debug("  [{}] commiting transaction: {}", (Object)this.sessionId, (Object)trx);
                    trx.commit();
                }
            }
        }
        catch (Exception ex) {
            this.log.error("  [" + this.sessionId + "] unable trying to commit/rollback trx resulted in error", (Throwable)ex);
        }
        finally {
            this.log.debug("  [{}] closing", (Object)this.sessionId);
            em.close();
        }
    }

    public void send(Object result) throws Throwable {
        this.trxSend(result);
    }

    public void send(Result result) throws Throwable {
        this.trxSend(result);
    }
}

