/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.hbm;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.hibernate.jpa.HibernatePersistenceProvider;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HbmUnitDescriptor
implements PersistenceUnitDescriptor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ClassLoader loader;
    private DataSource dataSource;
    private Config config;
    private List<URL> jars = Collections.emptyList();
    private URL unitRoot;

    public HbmUnitDescriptor(ClassLoader loader, DataSource dataSource, Config config, Set<String> pkgs) {
        this.loader = loader;
        this.dataSource = dataSource;
        this.config = config;
        List<URL> pkgList = this.packageToScan(loader, pkgs);
        if (pkgList.size() > 0) {
            this.unitRoot = pkgList.get(0);
            this.jars = pkgList.subList(1, pkgList.size());
        }
    }

    private <T> T property(String name, T defaultValue) {
        if (this.config.hasPath(name)) {
            return (T)this.config.getAnyRef(name);
        }
        return defaultValue;
    }

    public void pushClassTransformer(List<String> entityClassNames) {
        throw new UnsupportedOperationException();
    }

    public boolean isUseQuotedIdentifiers() {
        return this.property("hibernate.useQuotedIdentifiers", false);
    }

    public boolean isExcludeUnlistedClasses() {
        return this.property("hibernate.excludeUnlistedClasses", false);
    }

    public ValidationMode getValidationMode() {
        return ValidationMode.valueOf((String)this.property("javax.persistence.validation.mode", "NONE").toUpperCase());
    }

    public PersistenceUnitTransactionType getTransactionType() {
        return PersistenceUnitTransactionType.RESOURCE_LOCAL;
    }

    public SharedCacheMode getSharedCacheMode() {
        return SharedCacheMode.valueOf((String)this.property("javax.persistence.sharedCache.mode", "UNSPECIFIED"));
    }

    public String getProviderClassName() {
        return HibernatePersistenceProvider.class.getName();
    }

    public Properties getProperties() {
        Properties $ = new Properties();
        this.config.getConfig("javax.persistence").entrySet().forEach(e -> $.put("javax.persistence." + (String)e.getKey(), ((ConfigValue)e.getValue()).unwrapped()));
        return $;
    }

    public URL getPersistenceUnitRootUrl() {
        return this.unitRoot;
    }

    public Object getNonJtaDataSource() {
        return this.dataSource;
    }

    public String getName() {
        return this.dataSource.toString();
    }

    public List<String> getMappingFileNames() {
        return Collections.emptyList();
    }

    public List<String> getManagedClassNames() {
        return Collections.emptyList();
    }

    public Object getJtaDataSource() {
        return null;
    }

    public List<URL> getJarFileUrls() {
        return this.jars;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    private List<URL> packageToScan(ClassLoader loader, Set<String> pkgs) {
        ArrayList<URL> result = new ArrayList<URL>();
        for (String pkg : pkgs) {
            try {
                Enumeration<URL> resources = loader.getResources(pkg.replace(".", "/"));
                while (resources.hasMoreElements()) {
                    URL url = resources.nextElement();
                    result.add(url);
                }
            }
            catch (IOException ex) {
                this.log.debug("Unable to load package: {}", (Object)pkg, (Object)ex);
            }
        }
        return result;
    }
}

