/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.hbm;

import com.google.inject.Key;
import java.util.List;
import javax.persistence.EntityManager;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.context.internal.ManagedSessionContext;
import org.hibernate.jpa.HibernateEntityManagerFactory;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Route;
import org.jooby.internal.hbm.TrxResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSessionInView
implements Route.Filter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private HibernateEntityManagerFactory emf;
    private List<Key<EntityManager>> keys;

    public OpenSessionInView(HibernateEntityManagerFactory emf, List<Key<EntityManager>> keys) {
        this.emf = emf;
        this.keys = keys;
    }

    public void handle(Request req, Response rsp, Route.Chain chain) throws Throwable {
        SessionFactory sf = this.emf.getSessionFactory();
        EntityManager em = this.emf.createEntityManager();
        Session session = (Session)em.getDelegate();
        String sessionId = Integer.toHexString(System.identityHashCode(session));
        this.keys.forEach(key -> req.set(key, (Object)em));
        this.log.debug("session opened: {}", (Object)sessionId);
        TrxResponse trxrsp = new TrxResponse(rsp, em);
        try {
            this.log.debug("  [{}] binding", (Object)sessionId);
            ManagedSessionContext.bind((Session)session);
            FlushMode flushMode = FlushMode.AUTO;
            this.log.debug("  [{}] flush mode: {}", (Object)sessionId, (Object)flushMode);
            session.setFlushMode(flushMode);
            trxrsp.begin();
            chain.next(req, (Response)trxrsp);
        }
        catch (Exception ex) {
            trxrsp.setRollbackOnly();
            throw ex;
        }
        finally {
            trxrsp.done();
            this.log.debug("  [{}] unbinding", (Object)sessionId);
            ManagedSessionContext.unbind((SessionFactory)sf);
            this.log.debug("session released: [{}]", (Object)sessionId);
        }
    }
}

