/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.hbm;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.hibernate.jpa.HibernateEntityManagerFactory;
import org.hibernate.jpa.boot.spi.Bootstrap;
import org.hibernate.jpa.boot.spi.EntityManagerFactoryBuilder;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.jooby.Env;
import org.jooby.Route;
import org.jooby.hbm.OpenSessionInView;
import org.jooby.internal.hbm.HbmUnitDescriptor;
import org.jooby.jdbc.Jdbc;
import org.jooby.scope.Providers;
import org.jooby.scope.RequestScoped;

public class Hbm
extends Jdbc {
    private final List<Class<?>> classes = new LinkedList();
    private Set<String> pkgs = new LinkedHashSet<String>();
    private boolean scan;

    public Hbm(String name, Class<?> ... classes) {
        super(name);
        this.classes.addAll(Arrays.asList(classes));
    }

    public Hbm(Class<?> ... classes) {
        this.classes.addAll(Arrays.asList(classes));
    }

    public Hbm scan(String ... pkgs) {
        this.scan = true;
        this.pkgs.addAll(Arrays.asList(pkgs));
        return this;
    }

    public Config config() {
        Config jdbc = super.config();
        return ConfigFactory.parseResources(((Object)((Object)this)).getClass(), (String)"hbm.conf").withFallback((ConfigMergeable)jdbc);
    }

    public void configure(Env env, Config config, Binder binder) {
        this.configure(env, config, binder, (name, ds) -> {
            if (this.scan) {
                this.pkgs.add(config.getString("application.ns"));
            }
            HbmUnitDescriptor descriptor = new HbmUnitDescriptor(((Object)((Object)this)).getClass().getClassLoader(), (DataSource)ds, config, this.pkgs);
            Map<Object, Object> integration = Hbm.config(env, config, this.classes);
            EntityManagerFactoryBuilder builder = Bootstrap.getEntityManagerFactoryBuilder((PersistenceUnitDescriptor)descriptor, integration);
            HibernateEntityManagerFactory emf = (HibernateEntityManagerFactory)builder.build();
            Env.ServiceKey serviceKey = env.serviceKey();
            serviceKey.generate(EntityManagerFactory.class, name, k -> binder.bind(k).toInstance((Object)emf));
            ArrayList<Key<EntityManager>> emkeys = new ArrayList<Key<EntityManager>>();
            serviceKey.generate(EntityManager.class, name, key -> {
                binder.bind(key).toProvider(Providers.outOfScope((Key)key)).in(RequestScoped.class);
                emkeys.add((Key<EntityManager>)key);
            });
            env.router().use("*", "*", (Route.Filter)new OpenSessionInView(emf, emkeys)).name("hbm");
            env.onStop(() -> ((HibernateEntityManagerFactory)emf).close());
        });
    }

    private static Map<Object, Object> config(Env env, Config config, List<Class<?>> classes) {
        HashMap<Object, Object> $ = new HashMap<Object, Object>();
        config.getConfig("hibernate").entrySet().forEach(e -> $.put("hibernate." + (String)e.getKey(), ((ConfigValue)e.getValue()).unwrapped()));
        if (classes.size() > 0) {
            $.put("hibernate.ejb.loaded.classes", classes);
        }
        if (!config.hasPath("hibernate.hbm2ddl.auto")) {
            String hbm2ddl = env.name().equals("dev") ? "update" : "validate";
            $.put("hibernate.hbm2ddl.auto", hbm2ddl);
        }
        return $;
    }
}

