/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.office;

import java.util.Objects;
import org.jodconverter.process.PumpStreamHandler;
import org.jodconverter.process.StreamPumper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VerboseProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(VerboseProcess.class);
    private final Process process;
    private final PumpStreamHandler streamHandler;

    VerboseProcess(Process process) {
        Objects.requireNonNull(process, "process must not be null");
        this.process = process;
        this.streamHandler = new PumpStreamHandler(new StreamPumper(process.getInputStream(), line -> LOGGER.info(line)), new StreamPumper(process.getErrorStream(), line -> LOGGER.error(line)));
        this.streamHandler.start();
    }

    Process getProcess() {
        return this.process;
    }

    Integer getExitCode() {
        try {
            int exitValue = this.process.exitValue();
            this.streamHandler.stop();
            return exitValue;
        }
        catch (IllegalThreadStateException ex) {
            LOGGER.trace("The Office process has not yet terminated.");
            return null;
        }
    }
}

