/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.office;

import com.sun.star.lib.uno.helper.UnoUrl;
import java.util.Map;

public class OfficeUrl {
    private final UnoUrl unoUrl;

    static UnoUrl pipe(String pipeName) {
        try {
            return UnoUrl.parseUnoUrl((String)("pipe,name=" + pipeName + ";urp;StarOffice.ServiceManager"));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    static UnoUrl socket(int port) {
        try {
            return UnoUrl.parseUnoUrl((String)("socket,host=127.0.0.1,port=" + port + ",tcpNoDelay=1;urp;StarOffice.ServiceManager"));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public OfficeUrl(String pipeName) {
        this.unoUrl = OfficeUrl.pipe(pipeName);
    }

    public OfficeUrl(int port) {
        this.unoUrl = OfficeUrl.socket(port);
    }

    public String getConnection() {
        return this.unoUrl.getConnection();
    }

    public String getProtocol() {
        return this.unoUrl.getProtocol();
    }

    public String getRootOid() {
        return this.unoUrl.getRootOid();
    }

    public Map<String, String> getProtocolParameters() {
        return this.unoUrl.getProtocolParameters();
    }

    public Map<String, String> getConnectionParameters() {
        return this.unoUrl.getConnectionParameters();
    }

    public String getProtocolParametersAsString() {
        return this.unoUrl.getProtocolParametersAsString();
    }

    public String getConnectionParametersAsString() {
        return this.unoUrl.getConnectionParametersAsString();
    }

    public String getProtocolAndParametersAsString() {
        return this.unoUrl.getProtocolAndParametersAsString();
    }

    public String getConnectionAndParametersAsString() {
        return this.unoUrl.getConnectionAndParametersAsString();
    }
}

