/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.office;

import com.sun.star.beans.XPropertySet;
import com.sun.star.bridge.XBridge;
import com.sun.star.bridge.XBridgeFactory;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnector;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XDesktop;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XEventListener;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.uno.XComponentContext;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jodconverter.office.LocalOfficeContext;
import org.jodconverter.office.OfficeConnectionEvent;
import org.jodconverter.office.OfficeConnectionEventListener;
import org.jodconverter.office.OfficeConnectionException;
import org.jodconverter.office.OfficeUrl;
import org.jodconverter.office.utils.Lo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OfficeConnection
implements LocalOfficeContext,
XEventListener {
    private static AtomicInteger bridgeIndex = new AtomicInteger();
    private static final Logger LOGGER = LoggerFactory.getLogger(OfficeConnection.class);
    private final OfficeUrl officeUrl;
    private Object desktopService;
    private XComponent bridgeComponent;
    private XComponentContext componentContext;
    private XComponentLoader componentLoader;
    private final List<OfficeConnectionEventListener> connectionEventListeners;
    private final AtomicBoolean connected = new AtomicBoolean();

    public OfficeConnection(OfficeUrl officeUrl) {
        this.officeUrl = officeUrl;
        this.connectionEventListeners = new ArrayList<OfficeConnectionEventListener>();
    }

    public void addConnectionEventListener(OfficeConnectionEventListener connectionEventListener) {
        this.connectionEventListeners.add(connectionEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws OfficeConnectionException {
        OfficeConnection officeConnection = this;
        synchronized (officeConnection) {
            String connectPart = this.officeUrl.getConnectionAndParametersAsString();
            LOGGER.debug("Connecting with connectString '{}'", (Object)connectPart);
            try {
                XComponentContext localContext = Bootstrap.createInitialComponentContext(null);
                XMultiComponentFactory localServiceManager = localContext.getServiceManager();
                XConnector connector = Lo.qi(XConnector.class, localServiceManager.createInstanceWithContext("com.sun.star.connection.Connector", localContext));
                XConnection connection = connector.connect(connectPart);
                XBridgeFactory bridgeFactory = Lo.qi(XBridgeFactory.class, localServiceManager.createInstanceWithContext("com.sun.star.bridge.BridgeFactory", localContext));
                String bridgeName = "jodconverter_" + bridgeIndex.getAndIncrement();
                XBridge bridge = bridgeFactory.createBridge(bridgeName, this.officeUrl.getProtocolAndParametersAsString(), connection, null);
                this.bridgeComponent = Lo.qi(XComponent.class, bridge);
                this.bridgeComponent.addEventListener((XEventListener)this);
                String rootOid = this.officeUrl.getRootOid();
                Object bridgeInstance = bridge.getInstance(rootOid);
                if (bridgeInstance == null) {
                    throw new OfficeConnectionException("Server didn't provide an instance for '" + rootOid + "'", connectPart);
                }
                XMultiComponentFactory officeMultiComponentFactory = Lo.qi(XMultiComponentFactory.class, bridgeInstance);
                XPropertySet properties = Lo.qi(XPropertySet.class, officeMultiComponentFactory);
                this.componentContext = Lo.qi(XComponentContext.class, properties.getPropertyValue("DefaultContext"));
                this.desktopService = officeMultiComponentFactory.createInstanceWithContext("com.sun.star.frame.Desktop", this.componentContext);
                this.componentLoader = Lo.qi(XComponentLoader.class, this.desktopService);
                if (this.componentLoader == null) {
                    throw new OfficeConnectionException("Could not create a desktop service", connectPart);
                }
                this.connected.set(true);
                LOGGER.info("Connected: '{}'", (Object)connectPart);
                OfficeConnectionEvent connectionEvent = new OfficeConnectionEvent(this);
                this.connectionEventListeners.stream().forEach(listener -> listener.connected(connectionEvent));
            }
            catch (OfficeConnectionException connectionEx) {
                throw connectionEx;
            }
            catch (Exception ex) {
                throw new OfficeConnectionException(String.format("Connection failed: '%s'; %s", connectPart, ex.getMessage()), connectPart, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        OfficeConnection officeConnection = this;
        synchronized (officeConnection) {
            LOGGER.debug("Disconnecting from '{}'", (Object)this.officeUrl.getConnectionAndParametersAsString());
            this.bridgeComponent.dispose();
        }
    }

    public void disposing(EventObject eventObject) {
        if (this.connected.get()) {
            this.connected.set(false);
            this.componentContext = null;
            this.componentLoader = null;
            this.desktopService = null;
            this.bridgeComponent = null;
            LOGGER.info("Disconnected: '{}'", (Object)this.officeUrl.getConnectionAndParametersAsString());
            OfficeConnectionEvent connectionEvent = new OfficeConnectionEvent(this);
            this.connectionEventListeners.stream().forEach(listener -> listener.disconnected(connectionEvent));
        }
    }

    @Override
    public XComponentContext getComponentContext() {
        return this.componentContext;
    }

    @Override
    public XComponentLoader getComponentLoader() {
        return this.componentLoader;
    }

    @Override
    public XDesktop getDesktop() {
        return Lo.qi(XDesktop.class, this.desktopService);
    }

    public boolean isConnected() {
        return this.connected.get();
    }
}

