/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.office;

import java.io.File;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.jodconverter.office.LocalOfficeManager;
import org.jodconverter.office.OfficeConnectionProtocol;
import org.jodconverter.office.OfficeManager;
import org.jodconverter.process.ProcessManager;

@Deprecated
public class DefaultOfficeManagerBuilder {
    private static final OfficeConnectionProtocol DEFAULT_PROTOCOL = OfficeConnectionProtocol.SOCKET;
    private OfficeConnectionProtocol connectionProtocol = DEFAULT_PROTOCOL;
    private String[] pipeNames;
    private int[] portNumbers;
    private File officeHome;
    private File workingDir;
    private ProcessManager processManager;
    private String[] runAsArgs;
    private File templateProfileDir;
    private boolean killExistingProcess = true;
    private long processTimeout = 120000L;
    private long processRetryInterval = 250L;
    private int maxTasksPerProcess = 200;
    private long taskExecutionTimeout = 120000L;
    private long taskQueueTimeout = 30000L;

    public OfficeManager build() {
        LocalOfficeManager.Builder builder = (LocalOfficeManager.Builder)((LocalOfficeManager.Builder)((LocalOfficeManager.Builder)LocalOfficeManager.builder().officeHome(this.officeHome).workingDir(this.workingDir)).templateProfileDir(this.templateProfileDir).killExistingProcess(this.killExistingProcess).processTimeout(this.processTimeout).processRetryInterval(this.processRetryInterval).maxTasksPerProcess(this.maxTasksPerProcess).taskExecutionTimeout(this.taskExecutionTimeout)).taskQueueTimeout(this.taskQueueTimeout);
        if (this.connectionProtocol == OfficeConnectionProtocol.SOCKET) {
            int[] nArray;
            if (ArrayUtils.isEmpty((int[])this.portNumbers)) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 2002;
            } else {
                nArray = this.portNumbers;
            }
            builder.portNumbers(nArray);
        } else {
            String[] stringArray;
            if (ArrayUtils.isEmpty((Object[])this.pipeNames)) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "office";
            } else {
                stringArray = this.pipeNames;
            }
            builder.pipeNames(stringArray);
        }
        if (this.processManager != null) {
            builder.processManager(this.processManager);
        }
        if (!ArrayUtils.isEmpty((Object[])this.runAsArgs)) {
            builder.runAsArgs(this.runAsArgs);
        }
        return builder.build();
    }

    public DefaultOfficeManagerBuilder setConnectionProtocol(OfficeConnectionProtocol connectionProtocol) {
        Validate.notNull((Object)((Object)connectionProtocol));
        this.connectionProtocol = connectionProtocol;
        return this;
    }

    public DefaultOfficeManagerBuilder setPipeNames(String ... pipeNames) {
        Validate.isTrue((pipeNames != null && pipeNames.length > 0 ? 1 : 0) != 0, (String)"The pipe name list must not be empty", (Object[])new Object[0]);
        this.pipeNames = (String[])ArrayUtils.clone((Object[])pipeNames);
        return this;
    }

    public DefaultOfficeManagerBuilder setPortNumbers(int ... portNumbers) {
        Validate.isTrue((portNumbers != null && portNumbers.length > 0 ? 1 : 0) != 0, (String)"The port number list must not be empty", (Object[])new Object[0]);
        this.portNumbers = ArrayUtils.clone((int[])portNumbers);
        return this;
    }

    public DefaultOfficeManagerBuilder setOfficeHome(File officeHome) {
        this.officeHome = officeHome;
        return this;
    }

    public DefaultOfficeManagerBuilder setOfficeHome(String officeHome) {
        return StringUtils.isBlank((CharSequence)officeHome) ? this : this.setOfficeHome(new File(officeHome));
    }

    public DefaultOfficeManagerBuilder setProcessManager(ProcessManager processManager) {
        Validate.notNull((Object)processManager);
        this.processManager = processManager;
        return this;
    }

    public DefaultOfficeManagerBuilder setProcessManager(String processManagerClass) {
        try {
            return StringUtils.isBlank((CharSequence)processManagerClass) ? this : this.setProcessManager((ProcessManager)Class.forName(processManagerClass).newInstance());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw new IllegalArgumentException("Unable to create a Process manager from the specified class name: " + processManagerClass, ex);
        }
    }

    public DefaultOfficeManagerBuilder setRunAsArgs(String ... runAsArgs) {
        Validate.isTrue((runAsArgs != null && runAsArgs.length > 0 ? 1 : 0) != 0, (String)"The runAs argument list must not be empty", (Object[])new Object[0]);
        this.runAsArgs = (String[])ArrayUtils.clone((Object[])runAsArgs);
        return this;
    }

    public DefaultOfficeManagerBuilder setWorkingDir(File workingDir) {
        this.workingDir = workingDir;
        return this;
    }

    public DefaultOfficeManagerBuilder setWorkingDir(String workingDir) {
        return StringUtils.isBlank((CharSequence)workingDir) ? this : this.setWorkingDir(new File(workingDir));
    }

    public DefaultOfficeManagerBuilder setTemplateProfileDir(File templateProfileDir) {
        this.templateProfileDir = templateProfileDir;
        return this;
    }

    public DefaultOfficeManagerBuilder setTemplateProfileDir(String templateProfileDir) {
        return StringUtils.isBlank((CharSequence)templateProfileDir) ? this : this.setTemplateProfileDir(new File(templateProfileDir));
    }

    public DefaultOfficeManagerBuilder setKillExistingProcess(boolean killExistingProcess) {
        this.killExistingProcess = killExistingProcess;
        return this;
    }

    @Deprecated
    public DefaultOfficeManagerBuilder setRetryTimeout(long retryTimeout) {
        Validate.inclusiveBetween((long)0L, (long)Long.MAX_VALUE, (long)retryTimeout, (String)String.format("The processTimeout %s must be greater than or equal to 0", retryTimeout));
        this.processTimeout = retryTimeout;
        return this;
    }

    @Deprecated
    public DefaultOfficeManagerBuilder setRetryInterval(long retryInterval) {
        Validate.inclusiveBetween((long)0L, (long)10000L, (long)retryInterval, (String)String.format("The processRetryInterval %s must be in the inclusive range of %s to %s", retryInterval, 0, 10000L));
        this.processRetryInterval = retryInterval;
        return this;
    }

    public DefaultOfficeManagerBuilder setMaxTasksPerProcess(int maxTasksPerProcess) {
        Validate.inclusiveBetween((long)1L, (long)Integer.MAX_VALUE, (long)maxTasksPerProcess, (String)String.format("The maxTasksPerProcess %s greater than 0", maxTasksPerProcess));
        this.maxTasksPerProcess = maxTasksPerProcess;
        return this;
    }

    public DefaultOfficeManagerBuilder setTaskExecutionTimeout(long taskExecutionTimeout) {
        Validate.inclusiveBetween((long)0L, (long)Long.MAX_VALUE, (long)taskExecutionTimeout, (String)String.format("The taskExecutionTimeout %s must greater than or equal to 0", taskExecutionTimeout));
        this.taskExecutionTimeout = taskExecutionTimeout;
        return this;
    }

    public DefaultOfficeManagerBuilder setTaskQueueTimeout(long taskQueueTimeout) {
        Validate.inclusiveBetween((long)0L, (long)Long.MAX_VALUE, (long)taskQueueTimeout, (String)String.format("The taskQueueTimeout %s must greater than or equal to 0", taskQueueTimeout));
        this.taskQueueTimeout = taskQueueTimeout;
        return this;
    }
}

