/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.key.query;

import java.util.Objects;
import org.jnosql.diana.api.TypeSupplier;
import org.jnosql.diana.api.Value;
import org.jnosql.query.QueryException;

final class ParamValue
implements Value {
    private final String name;
    private Object value;

    ParamValue(String name) {
        this.name = name;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object get() {
        this.validValue();
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public <T> T get(Class<T> clazz) {
        this.validValue();
        return (T)Value.of((Object)this.value).get(clazz);
    }

    public <T> T get(TypeSupplier<T> typeSupplier) {
        this.validValue();
        return (T)Value.of((Object)this.value).get(typeSupplier);
    }

    private void validValue() {
        if (Objects.isNull(this.value)) {
            throw new QueryException(String.format("The parameter %s is not defined", this.name));
        }
    }

    public String toString() {
        if (Objects.isNull(this.value)) {
            return this.name + "= ?";
        }
        return this.name + "= " + this.value;
    }
}

