/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.key.query;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jnosql.diana.api.NonUniqueResultException;
import org.jnosql.diana.api.Value;
import org.jnosql.diana.api.key.BucketManager;
import org.jnosql.diana.api.key.KeyValueEntity;
import org.jnosql.diana.api.key.KeyValuePreparedStatement;
import org.jnosql.diana.api.key.query.Params;
import org.jnosql.query.QueryException;

final class DefaultKeyValuePreparedStatement
implements KeyValuePreparedStatement {
    private final List<Value> keys;
    private final PreparedStatementType type;
    private final BucketManager manager;
    private final List<String> paramsLeft;
    private final Params params;
    private final Duration ttl;
    private final String query;
    private final Value key;
    private final Value value;

    DefaultKeyValuePreparedStatement(Value key, Value value, List<Value> keys, PreparedStatementType type, BucketManager manager, Params params, Duration ttl, String query) {
        this.key = key;
        this.value = value;
        this.keys = keys;
        this.type = type;
        this.manager = manager;
        this.params = params;
        this.paramsLeft = params.getParametersNames();
        this.ttl = ttl;
        this.query = query;
    }

    @Override
    public KeyValuePreparedStatement bind(String name, Object value) {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(value, "value is required");
        this.paramsLeft.remove(name);
        this.params.bind(name, value);
        return this;
    }

    @Override
    public List<Value> getResultList() {
        if (!this.paramsLeft.isEmpty()) {
            throw new QueryException("Check all the parameters before execute the query, params left: " + this.paramsLeft);
        }
        switch (this.type) {
            case GET: {
                Iterable<Value> values = this.manager.get(this.keys.stream().map(Value::get).collect(Collectors.toList()));
                ArrayList<Value> target = new ArrayList<Value>();
                values.forEach(target::add);
                return target;
            }
            case DEL: {
                this.manager.remove(this.keys.stream().map(Value::get).collect(Collectors.toList()));
                return Collections.emptyList();
            }
            case PUT: {
                KeyValueEntity<Object> entity = KeyValueEntity.of(this.key.get(), this.value.get());
                if (Objects.isNull(this.ttl)) {
                    this.manager.put(entity);
                } else {
                    this.manager.put(entity, this.ttl);
                }
                return Collections.emptyList();
            }
        }
        throw new UnsupportedOperationException("there is not support to operation type: " + (Object)((Object)this.type));
    }

    @Override
    public Optional<Value> getSingleResult() {
        List<Value> entities = this.getResultList();
        if (entities.isEmpty()) {
            return Optional.empty();
        }
        if (entities.size() == 1) {
            return Optional.of(entities.get(0));
        }
        throw new NonUniqueResultException("The select returns more than one entity, select: " + this.query);
    }

    static KeyValuePreparedStatement get(List<Value> keys, BucketManager manager, Params params, String query) {
        return new DefaultKeyValuePreparedStatement(null, null, keys, PreparedStatementType.GET, manager, params, null, query);
    }

    static KeyValuePreparedStatement put(Value key, Value value, BucketManager manager, Params params, Duration ttl, String query) {
        return new DefaultKeyValuePreparedStatement(key, value, null, PreparedStatementType.PUT, manager, params, ttl, query);
    }

    static KeyValuePreparedStatement del(List<Value> keys, BucketManager manager, Params params, String query) {
        return new DefaultKeyValuePreparedStatement(null, null, keys, PreparedStatementType.DEL, manager, params, null, query);
    }

    static enum PreparedStatementType {
        GET,
        PUT,
        DEL;

    }
}

