/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.column.query;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.jnosql.diana.api.Sort;
import org.jnosql.diana.api.column.ColumnEntity;
import org.jnosql.diana.api.column.ColumnFamilyManager;
import org.jnosql.diana.api.column.ColumnFamilyManagerAsync;
import org.jnosql.diana.api.column.ColumnQuery;
import org.jnosql.diana.api.column.query.BaseQueryBuilder;
import org.jnosql.diana.api.column.query.ColumnFrom;
import org.jnosql.diana.api.column.query.ColumnLimit;
import org.jnosql.diana.api.column.query.ColumnNameCondition;
import org.jnosql.diana.api.column.query.ColumnNameOrder;
import org.jnosql.diana.api.column.query.ColumnNotCondition;
import org.jnosql.diana.api.column.query.ColumnOrder;
import org.jnosql.diana.api.column.query.ColumnQueryBuild;
import org.jnosql.diana.api.column.query.ColumnSelect;
import org.jnosql.diana.api.column.query.ColumnSkip;
import org.jnosql.diana.api.column.query.ColumnWhere;
import org.jnosql.diana.api.column.query.DefaultColumnQuery;

class DefaultSelectQueryBuilder
extends BaseQueryBuilder
implements ColumnSelect,
ColumnFrom,
ColumnLimit,
ColumnSkip,
ColumnOrder,
ColumnNameCondition,
ColumnNotCondition,
ColumnNameOrder,
ColumnWhere,
ColumnQueryBuild {
    private String columnFamily;
    private long skip;
    private long limit;
    private final List<Sort> sorts = new ArrayList<Sort>();
    private final List<String> columns;

    DefaultSelectQueryBuilder(List<String> columns) {
        this.columns = columns;
    }

    @Override
    public ColumnFrom from(String columnFamily) {
        Objects.requireNonNull(columnFamily, "columnFamily is required");
        this.columnFamily = columnFamily;
        return this;
    }

    @Override
    public ColumnNameCondition where(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        return this;
    }

    @Override
    public ColumnNameCondition and(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        this.and = true;
        return this;
    }

    @Override
    public ColumnNameCondition or(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        this.and = false;
        return this;
    }

    @Override
    public ColumnSkip skip(long skip) {
        this.skip = skip;
        return this;
    }

    @Override
    public ColumnLimit limit(long limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public ColumnOrder orderBy(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        return this;
    }

    @Override
    public ColumnNotCondition not() {
        this.negate = true;
        return this;
    }

    @Override
    public <T> ColumnWhere eq(T value) {
        this.eqImpl(value);
        return this;
    }

    @Override
    public ColumnWhere like(String value) {
        this.likeImpl(value);
        return this;
    }

    @Override
    public <T> ColumnWhere gt(T value) {
        this.gtImpl(value);
        return this;
    }

    @Override
    public <T> ColumnWhere gte(T value) {
        this.gteImpl(value);
        return this;
    }

    @Override
    public <T> ColumnWhere lt(T value) {
        this.ltImpl(value);
        return this;
    }

    @Override
    public <T> ColumnWhere lte(T value) {
        this.lteImpl(value);
        return this;
    }

    @Override
    public <T> ColumnWhere between(T valueA, T valueB) {
        this.betweenImpl(valueA, valueB);
        return this;
    }

    @Override
    public <T> ColumnWhere in(Iterable<T> values) {
        this.inImpl(values);
        return this;
    }

    @Override
    public ColumnNameOrder asc() {
        this.sorts.add(Sort.of((String)this.name, (Sort.SortType)Sort.SortType.ASC));
        return this;
    }

    @Override
    public ColumnNameOrder desc() {
        this.sorts.add(Sort.of((String)this.name, (Sort.SortType)Sort.SortType.DESC));
        return this;
    }

    @Override
    public ColumnQuery build() {
        return new DefaultColumnQuery(this.limit, this.skip, this.columnFamily, this.columns, this.sorts, this.condition);
    }

    @Override
    public List<ColumnEntity> execute(ColumnFamilyManager manager) {
        Objects.requireNonNull(manager, "manager is required");
        return manager.select(this.build());
    }

    @Override
    public Optional<ColumnEntity> executeSingle(ColumnFamilyManager manager) {
        Objects.requireNonNull(manager, "manager is required");
        return manager.singleResult(this.build());
    }

    @Override
    public void execute(ColumnFamilyManagerAsync manager, Consumer<List<ColumnEntity>> callback) {
        Objects.requireNonNull(manager, "manager is required");
        Objects.requireNonNull(callback, "callback is required");
        manager.select(this.build(), callback);
    }

    @Override
    public void executeSingle(ColumnFamilyManagerAsync manager, Consumer<Optional<ColumnEntity>> callback) {
        Objects.requireNonNull(manager, "manager is required");
        Objects.requireNonNull(callback, "callback is required");
        manager.singleResult(this.build(), callback);
    }
}

