/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.column.query;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.jnosql.diana.api.QueryException;
import org.jnosql.diana.api.column.ColumnEntity;
import org.jnosql.diana.api.column.ColumnFamilyManagerAsync;
import org.jnosql.diana.api.column.ColumnObserverParser;
import org.jnosql.diana.api.column.ColumnPreparedStatementAsync;
import org.jnosql.diana.api.column.ColumnQueryParserAsync;
import org.jnosql.diana.api.column.query.DeleteQueryParser;
import org.jnosql.diana.api.column.query.InsertQueryParser;
import org.jnosql.diana.api.column.query.SelectQueryParser;
import org.jnosql.diana.api.column.query.UpdateQueryParser;

public final class DefaultColumnQueryParserAsync
implements ColumnQueryParserAsync {
    private final SelectQueryParser select = new SelectQueryParser();
    private final DeleteQueryParser delete = new DeleteQueryParser();
    private final InsertQueryParser insert = new InsertQueryParser();
    private final UpdateQueryParser update = new UpdateQueryParser();

    @Override
    public void query(String query, ColumnFamilyManagerAsync collectionManager, Consumer<List<ColumnEntity>> callBack, ColumnObserverParser observer) {
        String command;
        this.validation(query, collectionManager, callBack, observer);
        switch (command = query.substring(0, 6)) {
            case "select": {
                this.select.queryAsync(query, collectionManager, callBack, observer);
                return;
            }
            case "delete": {
                this.delete.queryAsync(query, collectionManager, callBack, observer);
                return;
            }
            case "insert": {
                this.insert.queryAsync(query, collectionManager, callBack, observer);
                return;
            }
            case "update": {
                this.update.queryAsync(query, collectionManager, callBack, observer);
                return;
            }
        }
        throw new QueryException(String.format("The command was not recognized at the query %s ", query));
    }

    @Override
    public ColumnPreparedStatementAsync prepare(String query, ColumnFamilyManagerAsync manager, ColumnObserverParser observer) {
        String command;
        this.validation(query, manager, observer);
        switch (command = query.substring(0, 6)) {
            case "select": {
                return this.select.prepareAsync(query, manager, observer);
            }
            case "delete": {
                return this.delete.prepareAsync(query, manager, observer);
            }
            case "insert": {
                return this.insert.prepareAsync(query, manager, observer);
            }
            case "update": {
                return this.update.prepareAsync(query, manager, observer);
            }
        }
        throw new QueryException(String.format("The command was not recognized at the query %s ", query));
    }

    private void validation(String query, ColumnFamilyManagerAsync manager, ColumnObserverParser observer) {
        Objects.requireNonNull(query, "query is required");
        Objects.requireNonNull(manager, "manager is required");
        Objects.requireNonNull(observer, "observer is required");
        if (query.length() < 6) {
            throw new QueryException(String.format("The query %s is invalid", query));
        }
    }

    private void validation(String query, ColumnFamilyManagerAsync manager, Consumer<List<ColumnEntity>> callBack, ColumnObserverParser observer) {
        Objects.requireNonNull(query, "query is required");
        Objects.requireNonNull(manager, "manager is required");
        Objects.requireNonNull(callBack, "callBack is required");
        Objects.requireNonNull(observer, "observer is required");
        if (query.length() < 6) {
            throw new QueryException(String.format("The query %s is invalid", query));
        }
    }
}

