/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.column.query;

import java.util.List;
import java.util.Objects;
import org.jnosql.diana.api.QueryException;
import org.jnosql.diana.api.column.ColumnEntity;
import org.jnosql.diana.api.column.ColumnFamilyManager;
import org.jnosql.diana.api.column.ColumnObserverParser;
import org.jnosql.diana.api.column.ColumnPreparedStatement;
import org.jnosql.diana.api.column.ColumnQueryParser;
import org.jnosql.diana.api.column.query.DeleteQueryParser;
import org.jnosql.diana.api.column.query.InsertQueryParser;
import org.jnosql.diana.api.column.query.SelectQueryParser;
import org.jnosql.diana.api.column.query.UpdateQueryParser;

public class DefaultColumnQueryParser
implements ColumnQueryParser {
    private final SelectQueryParser select = new SelectQueryParser();
    private final DeleteQueryParser delete = new DeleteQueryParser();
    private final InsertQueryParser insert = new InsertQueryParser();
    private final UpdateQueryParser update = new UpdateQueryParser();

    @Override
    public List<ColumnEntity> query(String query, ColumnFamilyManager manager, ColumnObserverParser observer) {
        String command;
        this.validation(query, manager, observer);
        switch (command = query.substring(0, 6)) {
            case "select": {
                return this.select.query(query, manager, observer);
            }
            case "delete": {
                return this.delete.query(query, manager, observer);
            }
            case "insert": {
                return this.insert.query(query, manager, observer);
            }
            case "update": {
                return this.update.query(query, manager, observer);
            }
        }
        throw new QueryException(String.format("The command was not recognized at the query %s ", query));
    }

    @Override
    public ColumnPreparedStatement prepare(String query, ColumnFamilyManager manager, ColumnObserverParser observer) {
        String command;
        this.validation(query, manager, observer);
        switch (command = query.substring(0, 6)) {
            case "select": {
                return this.select.prepare(query, manager, observer);
            }
            case "delete": {
                return this.delete.prepare(query, manager, observer);
            }
            case "insert": {
                return this.insert.prepare(query, manager, observer);
            }
            case "update": {
                return this.update.prepare(query, manager, observer);
            }
        }
        throw new QueryException(String.format("The command was not recognized at the query %s ", query));
    }

    private void validation(String query, ColumnFamilyManager manager, ColumnObserverParser observer) {
        Objects.requireNonNull(query, "query is required");
        Objects.requireNonNull(manager, "manager is required");
        Objects.requireNonNull(observer, "manager is observer");
        if (query.length() < 6) {
            throw new QueryException(String.format("The query %s is invalid", query));
        }
    }
}

