/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.column.query;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jnosql.diana.api.NonUniqueResultException;
import org.jnosql.diana.api.Params;
import org.jnosql.diana.api.QueryException;
import org.jnosql.diana.api.column.ColumnDeleteQuery;
import org.jnosql.diana.api.column.ColumnEntity;
import org.jnosql.diana.api.column.ColumnFamilyManager;
import org.jnosql.diana.api.column.ColumnPreparedStatement;
import org.jnosql.diana.api.column.ColumnQuery;

final class DefaultColumnPreparedStatement
implements ColumnPreparedStatement {
    private final ColumnEntity entity;
    private final ColumnQuery columnQuery;
    private final ColumnDeleteQuery columnDeleteQuery;
    private final PreparedStatementType type;
    private final Params params;
    private final String query;
    private final List<String> paramsLeft;
    private final Duration duration;
    private final ColumnFamilyManager manager;

    private DefaultColumnPreparedStatement(ColumnEntity entity, ColumnQuery columnQuery, ColumnDeleteQuery columnDeleteQuery, PreparedStatementType type, Params params, String query, List<String> paramsLeft, Duration duration, ColumnFamilyManager manager) {
        this.entity = entity;
        this.columnQuery = columnQuery;
        this.columnDeleteQuery = columnDeleteQuery;
        this.type = type;
        this.params = params;
        this.query = query;
        this.paramsLeft = paramsLeft;
        this.manager = manager;
        this.duration = duration;
    }

    @Override
    public ColumnPreparedStatement bind(String name, Object value) {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(value, "value is required");
        this.paramsLeft.remove(name);
        this.params.bind(name, value);
        return this;
    }

    @Override
    public List<ColumnEntity> getResultList() {
        if (!this.paramsLeft.isEmpty()) {
            throw new QueryException("Check all the parameters before execute the query, params left: " + this.paramsLeft);
        }
        switch (this.type) {
            case SELECT: {
                return this.manager.select(this.columnQuery);
            }
            case DELETE: {
                this.manager.delete(this.columnDeleteQuery);
                return Collections.emptyList();
            }
            case UPDATE: {
                return Collections.singletonList(this.manager.update(this.entity));
            }
            case INSERT: {
                if (Objects.isNull(this.duration)) {
                    return Collections.singletonList(this.manager.insert(this.entity));
                }
                return Collections.singletonList(this.manager.insert(this.entity, this.duration));
            }
        }
        throw new UnsupportedOperationException("there is not support to operation type: " + (Object)((Object)this.type));
    }

    @Override
    public Optional<ColumnEntity> getSingleResult() {
        List<ColumnEntity> entities = this.getResultList();
        if (entities.isEmpty()) {
            return Optional.empty();
        }
        if (entities.size() == 1) {
            return Optional.of(entities.get(0));
        }
        throw new NonUniqueResultException("The select returns more than one entity, select: " + this.query);
    }

    public String toString() {
        return this.query;
    }

    static ColumnPreparedStatement select(ColumnQuery columnQuery, Params params, String query, ColumnFamilyManager manager) {
        return new DefaultColumnPreparedStatement(null, columnQuery, null, PreparedStatementType.SELECT, params, query, params.getParametersNames(), null, manager);
    }

    static ColumnPreparedStatement delete(ColumnDeleteQuery columnDeleteQuery, Params params, String query, ColumnFamilyManager manager) {
        return new DefaultColumnPreparedStatement(null, null, columnDeleteQuery, PreparedStatementType.DELETE, params, query, params.getParametersNames(), null, manager);
    }

    static ColumnPreparedStatement insert(ColumnEntity entity, Params params, String query, Duration duration, ColumnFamilyManager manager) {
        return new DefaultColumnPreparedStatement(entity, null, null, PreparedStatementType.INSERT, params, query, params.getParametersNames(), duration, manager);
    }

    static ColumnPreparedStatement update(ColumnEntity entity, Params params, String query, ColumnFamilyManager manager) {
        return new DefaultColumnPreparedStatement(entity, null, null, PreparedStatementType.UPDATE, params, query, params.getParametersNames(), null, manager);
    }

    static enum PreparedStatementType {
        SELECT,
        DELETE,
        UPDATE,
        INSERT;

    }
}

