/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.column.query;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jnosql.diana.api.column.ColumnCondition;
import org.jnosql.diana.api.column.ColumnDeleteQuery;
import org.jnosql.diana.api.column.query.ReadOnlyColumnCondition;

class DefaultColumnDeleteQuery
implements ColumnDeleteQuery {
    private final String columnFamily;
    private final ColumnCondition condition;
    private final List<String> columns;

    DefaultColumnDeleteQuery(String columnFamily, ColumnCondition condition, List<String> columns) {
        this.columnFamily = columnFamily;
        this.condition = Optional.ofNullable(condition).map(ReadOnlyColumnCondition::new).orElse(null);
        this.columns = columns;
    }

    @Override
    public String getColumnFamily() {
        return this.columnFamily;
    }

    @Override
    public Optional<ColumnCondition> getCondition() {
        return Optional.ofNullable(this.condition);
    }

    @Override
    public List<String> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ColumnDeleteQuery)) {
            return false;
        }
        ColumnDeleteQuery that = (ColumnDeleteQuery)o;
        return Objects.equals(this.columnFamily, that.getColumnFamily()) && Objects.equals(this.condition, that.getCondition().orElse(null)) && Objects.equals(this.columns, that.getColumns());
    }

    public int hashCode() {
        return Objects.hash(this.columnFamily, this.condition, this.columns);
    }

    public String toString() {
        return "DefaultColumnDeleteQuery{columnFamily='" + this.columnFamily + '\'' + ", condition=" + this.condition + ", columns=" + this.columns + '}';
    }
}

