/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.column.query;

import java.util.List;
import org.jnosql.diana.api.Params;
import org.jnosql.diana.api.QueryException;
import org.jnosql.diana.api.column.Column;
import org.jnosql.diana.api.column.ColumnCondition;
import org.jnosql.diana.api.column.ColumnObserverParser;
import org.jnosql.diana.api.column.query.Values;
import org.jnosql.query.Condition;
import org.jnosql.query.ConditionValue;
import org.jnosql.query.Where;

final class Conditions {
    private Conditions() {
    }

    static ColumnCondition getCondition(Where where, Params params, ColumnObserverParser observer, String entity) {
        Condition condition = where.getCondition();
        return Conditions.getCondition(condition, params, observer, entity);
    }

    static ColumnCondition getCondition(Condition condition, Params parameters, ColumnObserverParser observer, String entity) {
        switch (condition.getOperator()) {
            case EQUALS: {
                return ColumnCondition.eq(Column.of(Conditions.getName(condition, observer, entity), Values.get(condition.getValue(), parameters)));
            }
            case GREATER_THAN: {
                return ColumnCondition.gt(Column.of(Conditions.getName(condition, observer, entity), Values.get(condition.getValue(), parameters)));
            }
            case GREATER_EQUALS_THAN: {
                return ColumnCondition.gte(Column.of(Conditions.getName(condition, observer, entity), Values.get(condition.getValue(), parameters)));
            }
            case LESSER_THAN: {
                return ColumnCondition.lt(Column.of(Conditions.getName(condition, observer, entity), Values.get(condition.getValue(), parameters)));
            }
            case LESSER_EQUALS_THAN: {
                return ColumnCondition.lte(Column.of(Conditions.getName(condition, observer, entity), Values.get(condition.getValue(), parameters)));
            }
            case IN: {
                return ColumnCondition.in(Column.of(Conditions.getName(condition, observer, entity), Values.get(condition.getValue(), parameters)));
            }
            case LIKE: {
                return ColumnCondition.like(Column.of(Conditions.getName(condition, observer, entity), Values.get(condition.getValue(), parameters)));
            }
            case BETWEEN: {
                return ColumnCondition.between(Column.of(Conditions.getName(condition, observer, entity), Values.get(condition.getValue(), parameters)));
            }
            case NOT: {
                return Conditions.getCondition((Condition)((List)((ConditionValue)ConditionValue.class.cast(condition.getValue())).get()).get(0), parameters, observer, entity).negate();
            }
            case OR: {
                return ColumnCondition.or((ColumnCondition[])((List)((ConditionValue)ConditionValue.class.cast(condition.getValue())).get()).stream().map(v -> Conditions.getCondition(v, parameters, observer, entity)).toArray(ColumnCondition[]::new));
            }
            case AND: {
                return ColumnCondition.and((ColumnCondition[])((List)((ConditionValue)ConditionValue.class.cast(condition.getValue())).get()).stream().map(v -> Conditions.getCondition(v, parameters, observer, entity)).toArray(ColumnCondition[]::new));
            }
        }
        throw new QueryException("There is not support the type: " + condition.getOperator());
    }

    private static String getName(Condition condition, ColumnObserverParser observer, String entity) {
        return observer.fireField(entity, condition.getName());
    }
}

