/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.column.query;

import java.util.List;
import javax.json.JsonObject;
import org.jnosql.diana.api.Params;
import org.jnosql.diana.api.QueryException;
import org.jnosql.diana.api.column.Column;
import org.jnosql.diana.api.column.ColumnCondition;
import org.jnosql.diana.api.column.ColumnEntity;
import org.jnosql.diana.api.column.ColumnObserverParser;
import org.jnosql.diana.api.column.query.ConditionQuerySupplier;
import org.jnosql.diana.api.column.query.Conditions;
import org.jnosql.diana.api.column.query.JsonObjects;
import org.jnosql.query.JSONValue;

abstract class ConditionQueryParser {
    ConditionQueryParser() {
    }

    protected ColumnEntity getEntity(ConditionQuerySupplier query, String columnFamily, Params params, ColumnObserverParser observer) {
        ColumnEntity entity = ColumnEntity.of(columnFamily);
        if (query.useJSONCondition()) {
            JSONValue jsonValue = query.getValue().orElseThrow(() -> new QueryException("It is an invalid state of either Update or Insert."));
            List<Column> columns = JsonObjects.getColumns((JsonObject)jsonValue.get());
            entity.addAll(columns);
            return entity;
        }
        query.getConditions().stream().map(c -> Conditions.getCondition(c, params, observer, columnFamily)).map(ColumnCondition::getColumn).forEach(entity::add);
        return entity;
    }
}

