/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.column.query;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.BiFunction;
import org.jnosql.diana.api.column.ColumnObserverParser;

final class CacheQuery<V> {
    private final Map<String, V> store = Collections.synchronizedMap(new WeakHashMap());
    private final BiFunction<String, ColumnObserverParser, V> supplier;

    CacheQuery(BiFunction<String, ColumnObserverParser, V> supplier) {
        this.supplier = supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(String key, ColumnObserverParser observer) {
        V value = this.store.get(key);
        if (Objects.isNull(value)) {
            String string = key;
            synchronized (string) {
                value = this.supplier.apply(key, observer);
                this.put(key, value);
            }
        }
        return value;
    }

    private V put(String key, V value) {
        return this.store.put(key, value);
    }
}

