/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.column;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jnosql.diana.api.Value;
import org.jnosql.diana.api.column.Column;
import org.jnosql.diana.api.column.ColumnEntity;

final class DefaultColumnEntity
implements ColumnEntity {
    private final Map<String, Column> columns = new HashMap<String, Column>();
    private final String name;

    DefaultColumnEntity(String name) {
        this.name = Objects.requireNonNull(name, "name is required");
    }

    static DefaultColumnEntity of(String name, Column ... columns) {
        if (columns.length == 0) {
            return new DefaultColumnEntity(name);
        }
        return DefaultColumnEntity.of(name, Arrays.asList(columns));
    }

    static DefaultColumnEntity of(String name, List<Column> columns) {
        DefaultColumnEntity columnEntity = new DefaultColumnEntity(name);
        columnEntity.addAll(columns);
        return columnEntity;
    }

    @Override
    public void addAll(List<Column> columns) {
        Objects.requireNonNull(columns, "The object column is required");
        columns.forEach(this::add);
    }

    @Override
    public void add(Column column) {
        Objects.requireNonNull(column, "Column is required");
        this.columns.put(column.getName(), column);
    }

    @Override
    public void add(String columnName, Object value) {
        Objects.requireNonNull(columnName, "columnName is required");
        Objects.requireNonNull(value, "value is required");
        this.add(Column.of(columnName, value));
    }

    @Override
    public void add(String columnName, Value value) {
        Objects.requireNonNull(columnName, "columnName is required");
        Objects.requireNonNull(value, "value is required");
        this.add(Column.of(columnName, value));
    }

    @Override
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, Column> entry : this.columns.entrySet()) {
            Column value = entry.getValue();
            map.put(value.getName(), this.convert(value.get()));
        }
        return Collections.unmodifiableMap(map);
    }

    private Object convert(Object value) {
        if (value instanceof Column) {
            Column column = (Column)Column.class.cast(value);
            return Collections.singletonMap(column.getName(), this.convert(column.get()));
        }
        if (value instanceof Iterable) {
            ArrayList list = new ArrayList();
            ((Iterable)Iterable.class.cast(value)).forEach(e -> list.add(this.convert(e)));
            return list;
        }
        return value;
    }

    @Override
    public List<Column> getColumns() {
        return this.columns.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean remove(String columnName) {
        Objects.requireNonNull(columnName, "columnName is required");
        return this.columns.remove(columnName) != null;
    }

    @Override
    public Optional<Column> find(String columnName) {
        Objects.requireNonNull(columnName, "columnName is required");
        Column column = this.columns.get(columnName);
        return Optional.ofNullable(column);
    }

    @Override
    public int size() {
        return this.columns.size();
    }

    @Override
    public boolean isEmpty() {
        return this.columns.isEmpty();
    }

    @Override
    public ColumnEntity copy() {
        DefaultColumnEntity entity = new DefaultColumnEntity(this.name);
        entity.columns.putAll(new HashMap<String, Column>(this.columns));
        return entity;
    }

    @Override
    public Set<String> getColumnNames() {
        return Collections.unmodifiableSet(this.columns.keySet());
    }

    @Override
    public Collection<Value> getValues() {
        return this.columns.values().stream().map(Column::getValue).collect(Collectors.toList());
    }

    @Override
    public boolean contains(String columnName) {
        Objects.requireNonNull(columnName, "columnName is required");
        return this.columns.containsKey(columnName);
    }

    @Override
    public void clear() {
        this.columns.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultColumnEntity that = (DefaultColumnEntity)o;
        return Objects.equals(this.columns, that.columns) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.columns, this.name);
    }

    public String toString() {
        return "DefaultColumnEntity{columns=" + this.toMap() + ", name='" + this.name + '\'' + '}';
    }
}

