/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.column;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.StreamSupport;
import org.jnosql.diana.api.Condition;
import org.jnosql.diana.api.TypeReference;
import org.jnosql.diana.api.Value;
import org.jnosql.diana.api.column.Column;
import org.jnosql.diana.api.column.ColumnCondition;

final class DefaultColumnCondition
implements ColumnCondition {
    private final Column column;
    private final Condition condition;

    private DefaultColumnCondition(Column column, Condition condition) {
        this.column = column;
        this.condition = condition;
    }

    public static DefaultColumnCondition of(Column column, Condition condition) {
        return new DefaultColumnCondition(Objects.requireNonNull(column, "Column is required"), condition);
    }

    static DefaultColumnCondition and(ColumnCondition ... conditions) {
        Objects.requireNonNull(conditions, "condition is required");
        Column column = Column.of(Condition.AND.getNameField(), Arrays.asList(conditions));
        return DefaultColumnCondition.of(column, Condition.AND);
    }

    static DefaultColumnCondition or(ColumnCondition ... conditions) {
        Objects.requireNonNull(conditions, "condition is required");
        Column column = Column.of(Condition.OR.getNameField(), Arrays.asList(conditions));
        return DefaultColumnCondition.of(column, Condition.OR);
    }

    static DefaultColumnCondition between(Column column) {
        Objects.requireNonNull(column, "column is required");
        DefaultColumnCondition.checkBetweenClause(column.get());
        return new DefaultColumnCondition(column, Condition.BETWEEN);
    }

    static DefaultColumnCondition in(Column column) {
        Objects.requireNonNull(column, "column is required");
        DefaultColumnCondition.checkInClause(column.getValue());
        return new DefaultColumnCondition(column, Condition.IN);
    }

    private static void checkInClause(Value value) {
        if (!value.isInstanceOf(Iterable.class)) {
            throw new IllegalArgumentException("On Columncondition#in you must use an iterable instead of class: " + value.getClass().getName());
        }
    }

    private static void checkBetweenClause(Object value) {
        if (Iterable.class.isInstance(value)) {
            long count = (int)StreamSupport.stream(((Iterable)Iterable.class.cast(value)).spliterator(), false).count();
            if (count != 2L) {
                throw new IllegalArgumentException("On Columncondition#between you must use an iterable with two elements");
            }
        } else {
            throw new IllegalArgumentException("On Columncondition#between you must use an iterable with two elements instead of class: " + value.getClass().getName());
        }
    }

    @Override
    public Column getColumn() {
        return this.column;
    }

    @Override
    public Condition getCondition() {
        return this.condition;
    }

    @Override
    public ColumnCondition and(ColumnCondition condition) {
        Objects.requireNonNull(condition, "Conditions is required");
        if (Condition.AND.equals((Object)this.condition)) {
            Column newColumn = this.getConditions(condition, Condition.AND);
            return new DefaultColumnCondition(newColumn, Condition.AND);
        }
        return DefaultColumnCondition.and(this, condition);
    }

    @Override
    public ColumnCondition negate() {
        if (Condition.NOT.equals((Object)this.condition)) {
            return this.column.get(ColumnCondition.class);
        }
        Column newColumn = Column.of(Condition.NOT.getNameField(), this);
        return new DefaultColumnCondition(newColumn, Condition.NOT);
    }

    @Override
    public ColumnCondition or(ColumnCondition condition) {
        Objects.requireNonNull(condition, "Condition is required");
        if (Condition.OR.equals((Object)this.condition)) {
            Column newColumn = this.getConditions(condition, Condition.OR);
            return new DefaultColumnCondition(newColumn, Condition.OR);
        }
        return DefaultColumnCondition.or(this, condition);
    }

    private Column getConditions(ColumnCondition columnCondition, Condition condition) {
        ArrayList<ColumnCondition> conditions = new ArrayList<ColumnCondition>((Collection)this.column.get(new TypeReference<List<ColumnCondition>>(){}));
        conditions.add(columnCondition);
        return Column.of(condition.getNameField(), conditions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !ColumnCondition.class.isAssignableFrom(o.getClass())) {
            return false;
        }
        ColumnCondition that = (ColumnCondition)o;
        return Objects.equals(this.column, that.getColumn()) && this.condition == that.getCondition();
    }

    public int hashCode() {
        return Objects.hash(this.column, this.condition);
    }

    public String toString() {
        return "DefaultColumnCondition{column=" + this.column + ", condition=" + this.condition + '}';
    }
}

