/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.column;

import org.jnosql.diana.api.Condition;
import org.jnosql.diana.api.column.Column;
import org.jnosql.diana.api.column.DefaultColumnCondition;

public interface ColumnCondition {
    public Column getColumn();

    public Condition getCondition();

    public ColumnCondition and(ColumnCondition var1);

    public ColumnCondition negate();

    public ColumnCondition or(ColumnCondition var1);

    public static ColumnCondition eq(Column column) {
        return DefaultColumnCondition.of(column, Condition.EQUALS);
    }

    public static ColumnCondition gt(Column column) {
        return DefaultColumnCondition.of(column, Condition.GREATER_THAN);
    }

    public static ColumnCondition gte(Column column) {
        return DefaultColumnCondition.of(column, Condition.GREATER_EQUALS_THAN);
    }

    public static ColumnCondition lt(Column column) {
        return DefaultColumnCondition.of(column, Condition.LESSER_THAN);
    }

    public static ColumnCondition lte(Column column) {
        return DefaultColumnCondition.of(column, Condition.LESSER_EQUALS_THAN);
    }

    public static ColumnCondition in(Column column) {
        return DefaultColumnCondition.in(column);
    }

    public static ColumnCondition like(Column column) {
        return DefaultColumnCondition.of(column, Condition.LIKE);
    }

    public static ColumnCondition between(Column column) {
        return DefaultColumnCondition.between(column);
    }

    public static ColumnCondition and(ColumnCondition ... conditions) {
        return DefaultColumnCondition.and(conditions);
    }

    public static ColumnCondition or(ColumnCondition ... conditions) {
        return DefaultColumnCondition.or(conditions);
    }
}

