/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.extras;

import java.io.IOException;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jibx.runtime.impl.XMLWriterNamespaceBase;

public class JDOMWriter
extends XMLWriterNamespaceBase {
    private Document document;
    private Element currentElement;

    public JDOMWriter(String[] namespaces) {
        super(namespaces);
        this.reset();
    }

    public JDOMWriter(String[] namespaces, Document document) {
        this(namespaces);
        this.document = document;
        if (document.hasRootElement()) {
            this.currentElement = document.getRootElement();
        }
    }

    public JDOMWriter(String[] namespaces, Element currentElement) {
        this(namespaces, currentElement.getDocument());
        this.currentElement = currentElement;
    }

    public void init() {
    }

    public void setIndentSpaces(int count, String newline, char indent) {
    }

    public void writeXMLDecl(String version, String encoding, String standalone) throws IOException {
    }

    public void startTagOpen(int index, String name) throws IOException {
        Element newElement = new Element(name, this.getNamespace(index));
        if (this.currentElement == null) {
            this.document.setRootElement(newElement);
        } else {
            this.currentElement.addContent((Content)newElement);
        }
        this.currentElement = newElement;
    }

    public void startTagNamespaces(int index, String name, int[] nums, String[] prefs) throws IOException {
        int[] deltas = this.openNamespaces(nums, prefs);
        this.startTagOpen(index, name);
        for (int i = 0; i < deltas.length; ++i) {
            int slot = deltas[i];
            this.currentElement.addNamespaceDeclaration(this.getNamespace(slot));
        }
    }

    public void addAttribute(int index, String name, String value) throws IOException {
        this.currentElement.setAttribute(name, value, this.getNamespace(index));
    }

    public void closeStartTag() throws IOException {
        this.incrementNesting();
    }

    public void closeEmptyTag() throws IOException {
        this.incrementNesting();
        this.decrementNesting();
        this.currentElement = this.currentElement.getParentElement();
    }

    public void startTagClosed(int index, String name) throws IOException {
        this.startTagOpen(index, name);
        this.closeStartTag();
    }

    public void endTag(int index, String name) throws IOException {
        this.decrementNesting();
        this.currentElement = this.currentElement.getParentElement();
    }

    public void writeTextContent(String text) throws IOException {
        this.currentElement.addContent((Content)new Text(text));
    }

    public void writeCData(String text) throws IOException {
        this.currentElement.addContent((Content)new CDATA(text));
    }

    public void writeComment(String text) throws IOException {
        this.currentElement.addContent((Content)new Comment(text));
    }

    public void writeEntityRef(String name) throws IOException {
        this.currentElement.addContent((Content)new EntityRef(name));
    }

    public void writeDocType(String name, String sys, String pub, String subset) throws IOException {
        DocType docType = null != pub ? new DocType(name, pub, sys) : (null != sys ? new DocType(name, sys) : new DocType(name));
        if (null != subset) {
            docType.setInternalSubset(subset);
        }
        this.document.setDocType(docType);
    }

    public void writePI(String target, String data) throws IOException {
        this.currentElement.addContent((Content)new ProcessingInstruction(target, data));
    }

    public void indent() throws IOException {
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
    }

    public void reset() {
        super.reset();
        this.document = new Document();
        this.currentElement = null;
    }

    public Document getDocument() {
        return this.document;
    }

    protected void defineNamespace(int index, String prefix) throws IOException {
    }

    protected void undefineNamespace(int index) {
    }

    private Namespace getNamespace(int index) {
        String prefix = this.getNamespacePrefix(index);
        String uri = this.getNamespaceUri(index);
        if (prefix == null) {
            return Namespace.getNamespace((String)uri);
        }
        return Namespace.getNamespace((String)prefix, (String)uri);
    }
}

