/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertStore;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.Date;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.util.encoders.Base64;
import org.globus.common.CoGProperties;
import org.globus.gsi.CredentialException;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.OpenSSLKey;
import org.globus.gsi.ProviderLoader;
import org.globus.gsi.X509ProxyCertPathParameters;
import org.globus.gsi.bc.BouncyCastleOpenSSLKey;
import org.globus.gsi.bc.BouncyCastleUtil;
import org.globus.gsi.provider.KeyStoreParametersFactory;
import org.globus.gsi.stores.ResourceCertStoreParameters;
import org.globus.gsi.stores.ResourceSigningPolicyStore;
import org.globus.gsi.stores.ResourceSigningPolicyStoreParameters;
import org.globus.gsi.trustmanager.X509ProxyCertPathValidator;
import org.globus.gsi.util.CertificateIOUtil;
import org.globus.gsi.util.CertificateLoadUtil;
import org.globus.gsi.util.CertificateUtil;
import org.globus.gsi.util.ProxyCertificateUtil;

public class X509Credential {
    public static final int BUFFER_SIZE = Integer.MAX_VALUE;
    private static Log logger = LogFactory.getLog((String)X509Credential.class.getCanonicalName());
    private OpenSSLKey opensslKey;
    private X509Certificate[] certChain;
    private static X509Credential defaultCred;
    private static long credentialLastModified;
    private static boolean credentialSet;
    private static File credentialFile;
    private static KeyStore ms_trustStore;
    private static CertStore ms_crlStore;
    private static ResourceSigningPolicyStore ms_sigPolStore;

    public X509Credential(PrivateKey initKey, X509Certificate[] initCertChain) {
        if (initKey == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        if (initCertChain == null || initCertChain.length < 1) {
            throw new IllegalArgumentException("At least one public certificate required");
        }
        this.certChain = new X509Certificate[initCertChain.length];
        System.arraycopy(initCertChain, 0, this.certChain, 0, initCertChain.length);
        this.opensslKey = new BouncyCastleOpenSSLKey(initKey);
    }

    public X509Credential(InputStream certInputStream, InputStream keyInputStream) throws CredentialException {
        if (certInputStream.markSupported()) {
            certInputStream.mark(Integer.MAX_VALUE);
        }
        this.loadKey(keyInputStream);
        this.loadCertificate(certInputStream);
        this.validateCredential();
    }

    public X509Credential(String certFile, String keyFile) throws CredentialException, IOException {
        this.loadKey(new FileInputStream(new File(keyFile)));
        this.loadCertificate(new FileInputStream(new File(certFile)));
        this.validateCredential();
    }

    public X509Credential(String proxyFile) throws CredentialException {
        if (proxyFile == null) {
            throw new IllegalArgumentException("proxy file is null");
        }
        logger.debug((Object)("Loading proxy file: " + proxyFile));
        try {
            FileInputStream in = new FileInputStream(proxyFile);
            this.load(in);
        }
        catch (FileNotFoundException f) {
            throw new CredentialException("proxy not found");
        }
    }

    public X509Credential(InputStream input) throws CredentialException {
        this.load(input);
    }

    public X509Certificate[] getCertificateChain() {
        X509Certificate[] returnArray = new X509Certificate[this.certChain.length];
        System.arraycopy(this.certChain, 0, returnArray, 0, this.certChain.length);
        return returnArray;
    }

    public PrivateKey getPrivateKey() throws CredentialException {
        return this.getPrivateKey(null);
    }

    public PrivateKey getPrivateKey(String password) throws CredentialException {
        if (this.opensslKey.isEncrypted()) {
            if (password == null) {
                throw new CredentialException("Key encrypted, password required");
            }
            try {
                this.opensslKey.decrypt(password);
            }
            catch (GeneralSecurityException exp) {
                throw new CredentialException(exp.getMessage(), exp);
            }
        }
        return this.opensslKey.getPrivateKey();
    }

    public boolean isEncryptedKey() {
        return this.opensslKey.isEncrypted();
    }

    private static byte[] getDecodedPEMObject(BufferedReader reader) throws IOException {
        String line;
        StringBuffer buf = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            if (line.indexOf("--END") != -1) {
                return Base64.decode((byte[])buf.toString().getBytes());
            }
            buf.append(line);
        }
        throw new EOFException("Missing PEM end footer");
    }

    public void saveKey(OutputStream out) throws IOException {
        this.opensslKey.writeTo(out);
        out.flush();
    }

    public void saveCertificateChain(OutputStream out) throws IOException, CertificateEncodingException {
        CertificateIOUtil.writeCertificate(out, this.certChain[0]);
        for (int i = 1; i < this.certChain.length; ++i) {
            if (this.certChain[i].getSubjectDN().equals(this.certChain[i].getIssuerDN())) continue;
            CertificateIOUtil.writeCertificate(out, this.certChain[i]);
        }
        out.flush();
    }

    public void save(OutputStream out) throws IOException, CertificateEncodingException {
        CertificateIOUtil.writeCertificate(out, this.certChain[0]);
        this.saveKey(out);
        for (int i = 1; i < this.certChain.length; ++i) {
            if (this.certChain[i].getSubjectDN().equals(this.certChain[i].getIssuerDN())) continue;
            CertificateIOUtil.writeCertificate(out, this.certChain[i]);
        }
        out.flush();
    }

    public void writeToFile(File file) throws IOException, CertificateEncodingException {
        this.writeToFile(file, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile(File certFile, File keyFile) throws IOException, CertificateEncodingException {
        FileOutputStream keyOutputStream = null;
        FileOutputStream certOutputStream = null;
        try {
            keyOutputStream = new FileOutputStream(keyFile);
            certOutputStream = new FileOutputStream(certFile);
            this.saveKey(keyOutputStream);
            this.saveCertificateChain(certOutputStream);
        }
        finally {
            try {
                if (keyOutputStream != null) {
                    keyOutputStream.close();
                }
            }
            catch (IOException e) {
                logger.warn((Object)("Could not close stream on save of key to file. " + keyFile.getPath()));
            }
            try {
                if (certOutputStream != null) {
                    certOutputStream.close();
                }
            }
            catch (IOException e) {
                logger.warn((Object)("Could not close stream on save certificate chain to file. " + certFile.getPath()));
            }
        }
    }

    public Date getNotBefore() {
        Date notBefore = this.certChain[0].getNotBefore();
        for (int i = 1; i < this.certChain.length; ++i) {
            Date date = this.certChain[i].getNotBefore();
            if (!date.before(notBefore)) continue;
            notBefore = date;
        }
        return notBefore;
    }

    public int getCertNum() {
        for (int i = this.certChain.length - 1; i >= 0; --i) {
            if (this.certChain[i].getSubjectDN().equals(this.certChain[i].getIssuerDN())) continue;
            return i + 1;
        }
        return this.certChain.length;
    }

    public int getStrength() throws CredentialException {
        return this.getStrength(null);
    }

    public int getStrength(String password) throws CredentialException {
        if (this.opensslKey == null) {
            return -1;
        }
        if (this.opensslKey.isEncrypted()) {
            if (password == null) {
                throw new CredentialException("Key encrypted, password required");
            }
            try {
                this.opensslKey.decrypt(password);
            }
            catch (GeneralSecurityException exp) {
                throw new CredentialException(exp.getMessage(), exp);
            }
        }
        return ((RSAPrivateKey)this.opensslKey.getPrivateKey()).getModulus().bitLength();
    }

    public String getSubject() {
        return this.certChain[0].getSubjectDN().getName();
    }

    public String getIssuer() {
        return this.certChain[0].getIssuerDN().getName();
    }

    public GSIConstants.CertificateType getProxyType() {
        try {
            return BouncyCastleUtil.getCertificateType(this.certChain[0]);
        }
        catch (CertificateException e) {
            logger.error((Object)"Error getting certificate type.", (Throwable)e);
            return GSIConstants.CertificateType.UNDEFINED;
        }
    }

    public long getTimeLeft() {
        Date earliestTime = null;
        for (int i = 0; i < this.certChain.length; ++i) {
            Date time = this.certChain[i].getNotAfter();
            if (earliestTime != null && !time.before(earliestTime)) continue;
            earliestTime = time;
        }
        long diff = (earliestTime.getTime() - System.currentTimeMillis()) / 1000L;
        return diff < 0L ? 0L : diff;
    }

    public String getIdentity() {
        try {
            return BouncyCastleUtil.getIdentity(this.certChain);
        }
        catch (CertificateException e) {
            logger.debug((Object)"Error getting certificate identity.", (Throwable)e);
            return null;
        }
    }

    public X509Certificate getIdentityCertificate() {
        try {
            return BouncyCastleUtil.getIdentityCertificate(this.certChain);
        }
        catch (CertificateException e) {
            logger.debug((Object)"Error getting certificate identity.", (Throwable)e);
            return null;
        }
    }

    public int getPathConstraint() {
        int pathLength = Integer.MAX_VALUE;
        try {
            for (int i = 0; i < this.certChain.length; ++i) {
                int length = BouncyCastleUtil.getProxyPathConstraint(this.certChain[i]);
                if (length == -1) {
                    length = Integer.MAX_VALUE;
                }
                if (length >= pathLength) continue;
                pathLength = length;
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Error retrieving path length.", (Throwable)e);
            pathLength = -1;
        }
        return pathLength;
    }

    private static KeyStore getTrustStore(String caCertsLocation) throws GeneralSecurityException, IOException {
        if (ms_trustStore != null) {
            return ms_trustStore;
        }
        String caCertsPattern = caCertsLocation + "/*.0";
        KeyStore keyStore = KeyStore.getInstance("PEMFilebasedKeyStore", "Globus");
        keyStore.load(KeyStoreParametersFactory.createTrustStoreParameters(caCertsPattern));
        ms_trustStore = keyStore;
        return keyStore;
    }

    private static CertStore getCRLStore(String caCertsLocation) throws GeneralSecurityException, NoSuchAlgorithmException {
        CertStore crlStore;
        if (ms_crlStore != null) {
            return ms_crlStore;
        }
        String crlPattern = caCertsLocation + "/*.r*";
        ms_crlStore = crlStore = CertStore.getInstance("PEMFilebasedCertStore", new ResourceCertStoreParameters(null, crlPattern));
        return crlStore;
    }

    private static ResourceSigningPolicyStore getSigPolStore(String caCertsLocation) throws GeneralSecurityException {
        ResourceSigningPolicyStore sigPolStore;
        if (ms_sigPolStore != null) {
            return ms_sigPolStore;
        }
        String sigPolPattern = caCertsLocation + "/*.signing_policy";
        ms_sigPolStore = sigPolStore = new ResourceSigningPolicyStore(new ResourceSigningPolicyStoreParameters(sigPolPattern));
        return sigPolStore;
    }

    public void verify() throws CredentialException {
        try {
            String caCertsLocation = "file:" + CoGProperties.getDefault().getCaCertLocations();
            KeyStore keyStore = X509Credential.getTrustStore(caCertsLocation);
            CertStore crlStore = X509Credential.getCRLStore(caCertsLocation);
            ResourceSigningPolicyStore sigPolStore = X509Credential.getSigPolStore(caCertsLocation);
            X509ProxyCertPathParameters parameters = new X509ProxyCertPathParameters(keyStore, crlStore, sigPolStore, false);
            X509ProxyCertPathValidator validator = new X509ProxyCertPathValidator();
            validator.engineValidate(CertificateUtil.getCertPath(this.certChain), parameters);
        }
        catch (Exception e) {
            throw new CredentialException(e);
        }
    }

    public static synchronized X509Credential getDefaultCredential() throws CredentialException {
        if (defaultCred == null) {
            X509Credential.reloadDefaultCredential();
        } else if (!credentialSet) {
            if (credentialFile.lastModified() == credentialLastModified) {
                defaultCred.verify();
            } else {
                defaultCred = null;
                X509Credential.reloadDefaultCredential();
            }
        }
        return defaultCred;
    }

    private static void reloadDefaultCredential() throws CredentialException {
        String proxyLocation = CoGProperties.getDefault().getProxyFile();
        defaultCred = new X509Credential(proxyLocation);
        credentialFile = new File(proxyLocation);
        credentialLastModified = credentialFile.lastModified();
        defaultCred.verify();
    }

    public static synchronized void setDefaultCredential(X509Credential cred) {
        defaultCred = cred;
        credentialSet = cred != null;
    }

    public String toString() {
        String lineSep = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        buf.append("subject    : ").append(this.getSubject()).append(lineSep);
        buf.append("issuer     : ").append(this.getIssuer()).append(lineSep);
        int strength = -1;
        try {
            strength = this.getStrength();
        }
        catch (Exception e) {
            // empty catch block
        }
        buf.append("strength   : ").append(strength).append(lineSep);
        buf.append("timeleft   : ").append(this.getTimeLeft() + " sec").append(lineSep);
        buf.append("proxy type : ").append(ProxyCertificateUtil.getProxyTypeAsString(this.getProxyType()));
        return buf.toString();
    }

    protected void load(InputStream input) throws CredentialException {
        if (input == null) {
            throw new IllegalArgumentException("input stream cannot be null");
        }
        X509Certificate cert = null;
        Vector<X509Certificate> chain = new Vector<X509Certificate>(3);
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(input));
            while ((line = reader.readLine()) != null) {
                byte[] data;
                if (line.indexOf("BEGIN CERTIFICATE") != -1) {
                    data = X509Credential.getDecodedPEMObject(reader);
                    cert = CertificateLoadUtil.loadCertificate(new ByteArrayInputStream(data));
                    chain.addElement(cert);
                    continue;
                }
                if (line.indexOf("BEGIN RSA PRIVATE KEY") == -1) continue;
                data = X509Credential.getDecodedPEMObject(reader);
                this.opensslKey = new BouncyCastleOpenSSLKey("RSA", data);
            }
        }
        catch (Exception e) {
            throw new CredentialException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        int size = chain.size();
        if (size == 0) {
            throw new CredentialException("no certs");
        }
        if (this.opensslKey == null) {
            throw new CredentialException("no key");
        }
        this.certChain = new X509Certificate[size];
        chain.copyInto(this.certChain);
    }

    protected void loadCertificate(InputStream input) throws CredentialException {
        if (input == null) {
            throw new IllegalArgumentException("Input stream to load X509Credential is null");
        }
        Vector<X509Certificate> chain = new Vector<X509Certificate>();
        BufferedReader reader = null;
        try {
            String line;
            if (input.markSupported()) {
                input.reset();
            }
            reader = new BufferedReader(new InputStreamReader(input));
            while ((line = reader.readLine()) != null) {
                if (line.indexOf("BEGIN CERTIFICATE") == -1) continue;
                byte[] data = X509Credential.getDecodedPEMObject(reader);
                X509Certificate cert = CertificateLoadUtil.loadCertificate(new ByteArrayInputStream(data));
                chain.addElement(cert);
            }
        }
        catch (IOException e) {
            throw new CredentialException(e);
        }
        catch (GeneralSecurityException e) {
            throw new CredentialException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.debug((Object)"error closing reader", (Throwable)e);
                }
            }
        }
        int size = chain.size();
        if (size > 0) {
            this.certChain = new X509Certificate[size];
            chain.copyInto(this.certChain);
        }
    }

    protected void loadKey(InputStream input) throws CredentialException {
        try {
            this.opensslKey = new BouncyCastleOpenSSLKey(input);
        }
        catch (IOException e) {
            throw new CredentialException(e.getMessage(), e);
        }
        catch (GeneralSecurityException e) {
            throw new CredentialException(e.getMessage(), e);
        }
    }

    private void validateCredential() throws CredentialException {
        if (this.certChain == null) {
            throw new CredentialException("No certificates found");
        }
        int size = this.certChain.length;
        if (size < 0) {
            throw new CredentialException("No certificates found.");
        }
        if (this.opensslKey == null) {
            throw new CredentialException("NO private key found");
        }
    }

    static {
        credentialLastModified = -1L;
        credentialSet = false;
        credentialFile = null;
        ms_trustStore = null;
        ms_crlStore = null;
        ms_sigPolStore = null;
        new ProviderLoader();
    }
}

