/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.common.CoGProperties;
import org.globus.gsi.ProviderLoader;
import org.globus.gsi.SigningPolicy;
import org.globus.gsi.provider.KeyStoreParametersFactory;
import org.globus.gsi.stores.ResourceSigningPolicyStore;
import org.globus.gsi.stores.ResourceSigningPolicyStoreParameters;
import org.globus.gsi.util.CertificateUtil;
import org.globus.gsi.util.KeyStoreUtil;

public class TrustedCertificates
implements Serializable {
    private static Log logger = LogFactory.getLog((String)TrustedCertificates.class.getName());
    public static final CertFilter certFileFilter;
    private static TrustedCertificates trustedCertificates;
    private Map certSubjectDNMap;
    private Map policyDNMap;
    private Vector certList;
    private final Set<X500Principal> invalidPolicies = new HashSet<X500Principal>();
    private boolean changed;
    public static String SIGNING_POLICY_FILE_SUFFIX;
    private static KeyStore ms_trustStore;
    private static ResourceSigningPolicyStore ms_sigPolStore;

    protected TrustedCertificates() {
    }

    public TrustedCertificates(X509Certificate[] certs) {
        this(certs, null);
    }

    public TrustedCertificates(X509Certificate[] certs, SigningPolicy[] policies) {
        int i;
        this.certSubjectDNMap = new HashMap();
        for (i = 0; i < certs.length; ++i) {
            if (certs[i] == null) continue;
            String dn = certs[i].getSubjectDN().toString();
            this.certSubjectDNMap.put(dn, certs[i]);
        }
        if (policies != null) {
            this.policyDNMap = new HashMap();
            for (i = 0; i < policies.length; ++i) {
                if (policies[i] == null) continue;
                this.policyDNMap.put(CertificateUtil.toGlobusID(policies[i].getCASubjectDN()), policies[i]);
            }
        }
    }

    public X509Certificate[] getCertificates() {
        if (this.certSubjectDNMap == null) {
            return null;
        }
        Collection certs = this.certSubjectDNMap.values();
        return certs.toArray(new X509Certificate[certs.size()]);
    }

    public X509Certificate getCertificate(String subject) {
        if (this.certSubjectDNMap == null) {
            return null;
        }
        return (X509Certificate)this.certSubjectDNMap.get(subject);
    }

    public SigningPolicy[] getSigningPolicies() {
        if (this.policyDNMap == null) {
            return null;
        }
        Collection values = this.policyDNMap.values();
        return this.policyDNMap.values().toArray(new SigningPolicy[values.size()]);
    }

    public SigningPolicy getSigningPolicy(String subject) {
        if (this.policyDNMap == null) {
            return null;
        }
        return (SigningPolicy)this.policyDNMap.get(subject);
    }

    public static X509Certificate[] loadCertificates(String locations) {
        TrustedCertificates tc = TrustedCertificates.load(locations);
        return tc == null ? null : tc.getCertificates();
    }

    public static TrustedCertificates load(String locations) {
        TrustedCertificates tc = new TrustedCertificates();
        tc.reload(locations);
        return tc;
    }

    public static FilenameFilter getCertFilter() {
        return certFileFilter;
    }

    private static KeyStore getTrustStore(String caCertsLocation) throws GeneralSecurityException, IOException {
        if (ms_trustStore != null) {
            return ms_trustStore;
        }
        String caCertsPattern = caCertsLocation + "/*.0";
        KeyStore keyStore = KeyStore.getInstance("PEMFilebasedKeyStore", "Globus");
        keyStore.load(KeyStoreParametersFactory.createTrustStoreParameters(caCertsPattern));
        ms_trustStore = keyStore;
        return keyStore;
    }

    private static ResourceSigningPolicyStore getSigPolStore(String caCertsLocation) throws GeneralSecurityException {
        ResourceSigningPolicyStore sigPolStore;
        if (ms_sigPolStore != null) {
            return ms_sigPolStore;
        }
        String sigPolPattern = caCertsLocation + "/*.signing_policy";
        ms_sigPolStore = sigPolStore = new ResourceSigningPolicyStore(new ResourceSigningPolicyStoreParameters(sigPolPattern));
        return sigPolStore;
    }

    public void refresh() {
        this.reload(null);
    }

    public synchronized void reload(String locations) {
        if (locations == null) {
            return;
        }
        this.changed = false;
        StringTokenizer tokens = new StringTokenizer(locations, ",");
        File caDir = null;
        HashMap<String, X509Certificate> newCertSubjectDNMap = new HashMap<String, X509Certificate>();
        HashMap<String, SigningPolicy> newSigningDNMap = new HashMap<String, SigningPolicy>();
        while (tokens.hasMoreTokens()) {
            caDir = new File(tokens.nextToken().toString().trim());
            if (!caDir.canRead()) {
                logger.debug((Object)("Cannot read: " + caDir.getAbsolutePath()));
                continue;
            }
            String caCertLocation = "file:" + caDir.getAbsolutePath();
            KeyStore trustStore = null;
            try {
                trustStore = TrustedCertificates.getTrustStore(caCertLocation);
                Collection<? extends Certificate> caCerts = KeyStoreUtil.getTrustedCertificates(trustStore, new X509CertSelector());
                for (X509Certificate x509Certificate : caCerts) {
                    if (!newCertSubjectDNMap.containsKey(x509Certificate.getSubjectDN().toString())) {
                        // empty if block
                    }
                    newCertSubjectDNMap.put(x509Certificate.getSubjectDN().toString(), x509Certificate);
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to create trust store", (Throwable)e);
            }
            try {
                ResourceSigningPolicyStore sigPolStore = TrustedCertificates.getSigPolStore(caCertLocation);
                Collection<? extends Certificate> caCerts = KeyStoreUtil.getTrustedCertificates(trustStore, new X509CertSelector());
                for (X509Certificate x509Certificate : caCerts) {
                    SigningPolicy policy;
                    X500Principal principal = x509Certificate.getSubjectX500Principal();
                    if (!newCertSubjectDNMap.containsKey(x509Certificate.getSubjectDN().toString())) continue;
                    try {
                        policy = sigPolStore.getSigningPolicy(principal);
                    }
                    catch (Exception e) {
                        if (this.invalidPolicies.contains(principal)) continue;
                        logger.warn((Object)"Invalid signing policy for CA certificate; skipping");
                        logger.debug((Object)"Invalid signing policy for CA certificate; skipping", (Throwable)e);
                        this.invalidPolicies.add(principal);
                        continue;
                    }
                    if (policy != null) {
                        newSigningDNMap.put(CertificateUtil.toGlobusID(policy.getCASubjectDN()), policy);
                        continue;
                    }
                    if (this.invalidPolicies.contains(principal)) continue;
                    logger.warn((Object)("no signing policy for ca cert " + x509Certificate.getSubjectDN()));
                    this.invalidPolicies.add(principal);
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to create signing policy store", (Throwable)e);
            }
        }
        this.changed = true;
        this.certSubjectDNMap = newCertSubjectDNMap;
        this.policyDNMap = newSigningDNMap;
        if (this.changed) {
            this.certList = null;
        }
    }

    private String getPolicyFileName(String caFileName) {
        return caFileName.substring(0, caFileName.lastIndexOf(".")) + SIGNING_POLICY_FILE_SUFFIX;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public static synchronized TrustedCertificates getDefaultTrustedCertificates() {
        return TrustedCertificates.getDefault();
    }

    public static void setDefaultTrustedCertificates(TrustedCertificates trusted) {
        trustedCertificates = trusted;
    }

    public static synchronized TrustedCertificates getDefault() {
        if (trustedCertificates == null) {
            trustedCertificates = new DefaultTrustedCertificates();
        }
        trustedCertificates.refresh();
        return trustedCertificates;
    }

    public String toString() {
        String returnStr = "";
        returnStr = this.certSubjectDNMap == null ? "Certificate list is empty." : this.certSubjectDNMap.toString();
        returnStr = this.policyDNMap == null ? returnStr + "Signing policy list is empty." : returnStr + this.policyDNMap.toString();
        return returnStr;
    }

    static {
        new ProviderLoader();
        certFileFilter = new CertFilter();
        trustedCertificates = null;
        SIGNING_POLICY_FILE_SUFFIX = ".signing_policy";
        ms_trustStore = null;
        ms_sigPolStore = null;
    }

    private static class DefaultTrustedCertificates
    extends TrustedCertificates {
        private DefaultTrustedCertificates() {
        }

        public void refresh() {
            this.reload(CoGProperties.getDefault().getCaCertLocations());
        }
    }

    public static class CertFilter
    implements FilenameFilter {
        public boolean accept(File dir, String file) {
            int length = file.length();
            return length > 2 && file.charAt(length - 2) == '.' && file.charAt(length - 1) >= '0' && file.charAt(length - 1) <= '9';
        }
    }
}

