/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.signer;

import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.zip.signer.signer.SignerInfo;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u001a\u000e\u0010\u0007\u001a\u0004\u0018\u00010\u0006*\u00020\u0002H\u0002\u00a8\u0006\b"}, d2={"getSignerInfo", "Lorg/jetbrains/zip/signer/signer/SignerInfo;", "Ljava/security/KeyStore;", "keyPassword", "", "alias", "", "getSingleKeyEntryAlias", "lib"})
public final class KeystoreUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SignerInfo getSignerInfo(@NotNull KeyStore $this$getSignerInfo, @NotNull char[] keyPassword, @Nullable String alias) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getSignerInfo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)keyPassword, (String)"keyPassword");
        String string = alias;
        String definedKeyAlias = string == null ? KeystoreUtilsKt.getSingleKeyEntryAlias($this$getSignerInfo) : string;
        boolean bl = $this$getSignerInfo.isKeyEntry(definedKeyAlias);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Keystore entry '" + definedKeyAlias + "' does not contain a key";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        Key key = $this$getSignerInfo.getKey(definedKeyAlias, keyPassword);
        if (key == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.security.PrivateKey");
        }
        PrivateKey key2 = (PrivateKey)key;
        Object object = $this$getSignerInfo.getCertificateChain(definedKeyAlias);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCertificateChain(definedKeyAlias)");
        Object[] $this$map$iv = (Object[])object;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Certificate certificate = (Certificate)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            if (it == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.security.cert.X509Certificate");
            }
            X509Certificate x509Certificate = (X509Certificate)it;
            collection.add(x509Certificate);
        }
        List certificateChain = (List)destination$iv$iv;
        object = certificateChain;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = !object.isEmpty();
        bl6 = false;
        bl7 = false;
        if (!bl8) {
            boolean bl9 = false;
            String string3 = "Keystore '" + definedKeyAlias + "' does not contain certificates";
            throw (Throwable)new IllegalArgumentException(string3.toString());
        }
        return new SignerInfo(certificateChain, key2);
    }

    private static final String getSingleKeyEntryAlias(KeyStore $this$getSingleKeyEntryAlias) {
        String definedKeyAlias = null;
        Enumeration<String> enumeration = $this$getSingleKeyEntryAlias.aliases();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"aliases()");
        boolean bl = false;
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration)), (Function1)((Function1)new Function1<String, Boolean>($this$getSingleKeyEntryAlias){
            final /* synthetic */ KeyStore $this_getSingleKeyEntryAlias;
            {
                this.$this_getSingleKeyEntryAlias = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(String it) {
                return this.$this_getSingleKeyEntryAlias.isKeyEntry(it);
            }
        }));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl2 = false;
            if (definedKeyAlias != null) {
                throw new IllegalArgumentException("Keystore contains multiple key entries. --ks-key-alias option must be used to specify which entry to use.");
            }
            definedKeyAlias = it;
        }
        return definedKeyAlias;
    }
}

