/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.metadata;

import com.google.protobuf.GeneratedMessageV3;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.ExperimentalUnsignedTypes;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.zip.signer.datasource.DataSource;
import org.jetbrains.zip.signer.metadata.Digest;
import org.jetbrains.zip.signer.metadata.SignerBlock;
import org.jetbrains.zip.signer.proto.DigestProto;
import org.jetbrains.zip.signer.proto.SignerBlockProto;
import org.jetbrains.zip.signer.proto.ZipMetadataProto;
import org.jetbrains.zip.signer.proto.ZipSignatureBlockProto;
import org.jetbrains.zip.signer.zip.ZipSectionsInformation;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0001\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B#\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007B+\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0012\u001a\u00020\u0013R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/zip/signer/metadata/ZipMetadata;", "", "digests", "", "Lorg/jetbrains/zip/signer/metadata/Digest;", "signers", "Lorg/jetbrains/zip/signer/metadata/SignerBlock;", "(Ljava/util/List;Ljava/util/List;)V", "protobufRepresentation", "Lorg/jetbrains/zip/signer/proto/ZipMetadataProto;", "(Ljava/util/List;Ljava/util/List;Lorg/jetbrains/zip/signer/proto/ZipMetadataProto;)V", "getDigests", "()Ljava/util/List;", "getSigners", "size", "", "getSize", "()I", "toByteArray", "", "Companion", "lib"})
@ExperimentalUnsignedTypes
public final class ZipMetadata {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Digest> digests;
    @NotNull
    private final List<SignerBlock> signers;
    @NotNull
    private final ZipMetadataProto protobufRepresentation;
    private final int size;
    private static final long SIGNATURE_BLOCK_MAGIC_HI = 3617552046287187010L;
    private static final long SIGNATURE_BLOCK_MAGIC_LO = 2334950737559900224L;
    private static final int signatureBlockHeaderSize = 8;
    private static final int signatureBlockFooterSize = 24;
    private static final int signatureBlockMetadataSize = 32;

    private ZipMetadata(List<Digest> digests, List<SignerBlock> signers, ZipMetadataProto protobufRepresentation) {
        this.digests = digests;
        this.signers = signers;
        this.protobufRepresentation = protobufRepresentation;
        this.size = 32 + this.protobufRepresentation.getSerializedSize();
    }

    @NotNull
    public final List<Digest> getDigests() {
        return this.digests;
    }

    @NotNull
    public final List<SignerBlock> getSigners() {
        return this.signers;
    }

    public ZipMetadata(@NotNull List<Digest> digests, @NotNull List<SignerBlock> signers) {
        GeneratedMessageV3 generatedMessageV3;
        SignerBlock it;
        Collection<DigestProto> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(digests, (String)"digests");
        Intrinsics.checkNotNullParameter(signers, (String)"signers");
        Iterable iterable = digests;
        ZipSignatureBlockProto.Builder builder = ZipSignatureBlockProto.newBuilder();
        ZipMetadataProto.Builder builder2 = ZipMetadataProto.newBuilder().setSignatureSchemeVersion(1);
        List<SignerBlock> list = signers;
        List<Digest> list2 = digests;
        ZipMetadata zipMetadata = this;
        boolean $i$f$map = false;
        void var6_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Digest digest = (Digest)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            generatedMessageV3 = ((Digest)((Object)it)).getProtobufRepresentation();
            collection.add((DigestProto)generatedMessageV3);
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = signers;
        builder = builder.addAllDigests((Iterable<? extends DigestProto>)collection);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (SignerBlock)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            generatedMessageV3 = it.getProtobufRepresentation();
            collection.add((DigestProto)generatedMessageV3);
        }
        collection = (List)destination$iv$iv;
        ZipMetadataProto zipMetadataProto = builder2.setContent(builder.addAllSigners((Iterable<? extends SignerBlockProto>)collection).build()).build();
        Intrinsics.checkNotNullExpressionValue((Object)zipMetadataProto, (String)"newBuilder()\n           \u2026   )\n            .build()");
        zipMetadata(list2, list, zipMetadataProto);
    }

    public final int getSize() {
        return this.size;
    }

    @NotNull
    public final byte[] toByteArray() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.size);
        boolean bl = false;
        boolean bl2 = false;
        ByteBuffer $this$toByteArray_u24lambda_u2d2 = byteBuffer;
        boolean bl3 = false;
        $this$toByteArray_u24lambda_u2d2.order(ByteOrder.LITTLE_ENDIAN);
        long blockSizeFieldValue = (long)this.getSize() - 8L;
        $this$toByteArray_u24lambda_u2d2.putLong(blockSizeFieldValue);
        $this$toByteArray_u24lambda_u2d2.put(this.protobufRepresentation.toByteArray());
        $this$toByteArray_u24lambda_u2d2.putLong(blockSizeFieldValue);
        $this$toByteArray_u24lambda_u2d2.putLong(2334950737559900224L);
        $this$toByteArray_u24lambda_u2d2.putLong(3617552046287187010L);
        byte[] byArray = $this$toByteArray_u24lambda_u2d2.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"with(ByteBuffer.allocate\u2026        array()\n        }");
        return byArray;
    }

    public /* synthetic */ ZipMetadata(List digests, List signers, ZipMetadataProto protobufRepresentation, DefaultConstructorMarker $constructor_marker) {
        this(digests, signers, protobufRepresentation);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/zip/signer/metadata/ZipMetadata$Companion;", "", "()V", "SIGNATURE_BLOCK_MAGIC_HI", "", "SIGNATURE_BLOCK_MAGIC_LO", "signatureBlockFooterSize", "", "signatureBlockHeaderSize", "signatureBlockMetadataSize", "findInZip", "Lorg/jetbrains/zip/signer/metadata/ZipMetadata;", "zipArchive", "Lorg/jetbrains/zip/signer/datasource/DataSource;", "zipSectionsInformation", "Lorg/jetbrains/zip/signer/zip/ZipSectionsInformation;", "lib"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final ZipMetadata findInZip(@NotNull DataSource zipArchive, @NotNull ZipSectionsInformation zipSectionsInformation) {
            Object object;
            SignerBlockProto it;
            Collection<Digest> collection;
            Iterable<SignerBlockProto> $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)zipArchive, (String)"zipArchive");
            Intrinsics.checkNotNullParameter((Object)zipSectionsInformation, (String)"zipSectionsInformation");
            long centralDirStartOffset = zipSectionsInformation.getCentralDirectoryOffset();
            if (centralDirStartOffset < 32L) {
                return null;
            }
            ByteBuffer byteBuffer = zipArchive.getByteBuffer(centralDirStartOffset - (long)24, 24);
            boolean bl = false;
            boolean bl2 = false;
            ByteBuffer $this$findInZip_u24lambda_u2d0 = byteBuffer;
            boolean bl3 = false;
            $this$findInZip_u24lambda_u2d0.order(ByteOrder.LITTLE_ENDIAN);
            ByteBuffer footer = byteBuffer;
            if (footer.getLong(8) != 2334950737559900224L || footer.getLong(16) != 3617552046287187010L) {
                return null;
            }
            long signatureBlockSizeInFooter = footer.getLong(0);
            if (signatureBlockSizeInFooter < (long)footer.capacity() || signatureBlockSizeInFooter > 0x7FFFFFF7L) {
                return null;
            }
            int totalSize = (int)(signatureBlockSizeInFooter + (long)8);
            long signingBlockOffset = centralDirStartOffset - (long)totalSize;
            if (signingBlockOffset < 0L) {
                return null;
            }
            ByteBuffer byteBuffer2 = zipArchive.getByteBuffer(signingBlockOffset, 8);
            boolean bl4 = false;
            boolean bl5 = false;
            ByteBuffer $this$findInZip_u24lambda_u2d32422 = byteBuffer2;
            boolean bl6 = false;
            $this$findInZip_u24lambda_u2d32422.order(ByteOrder.LITTLE_ENDIAN);
            ByteBuffer signatureBlockHeader = byteBuffer2;
            long signatureBlockSizeInHeader = signatureBlockHeader.getLong(0);
            if (signatureBlockSizeInHeader != signatureBlockSizeInFooter) {
                return null;
            }
            ZipMetadataProto protobufContent = ZipMetadataProto.parseFrom(zipArchive.getByteBuffer(signingBlockOffset + (long)8, totalSize - 32));
            boolean $this$findInZip_u24lambda_u2d32422 = protobufContent.getSignatureSchemeVersion() == 1;
            bl6 = false;
            boolean bl7 = false;
            bl7 = false;
            boolean bl8 = false;
            if (!$this$findInZip_u24lambda_u2d32422) {
                boolean bl9 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            List<DigestProto> $this$findInZip_u24lambda_u2d32422 = protobufContent.getContent().getDigestsList();
            Intrinsics.checkNotNullExpressionValue($this$findInZip_u24lambda_u2d32422, (String)"protobufContent.content.digestsList");
            Iterable<SignerBlockProto> $this$map$iv = (List<SignerBlockProto>)$this$findInZip_u24lambda_u2d32422;
            boolean $i$f$map = false;
            List<SignerBlockProto> list = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object t : $this$mapTo$iv$iv) {
                DigestProto digestProto = (DigestProto)t;
                collection = destination$iv$iv;
                boolean bl10 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                object = new Digest((DigestProto)((Object)it));
                collection.add((Digest)object);
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = protobufContent.getContent().getSignersList();
            Intrinsics.checkNotNullExpressionValue($this$map$iv, (String)"protobufContent.content.signersList");
            $this$map$iv = $this$map$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object object2 : $this$mapTo$iv$iv) {
                it = (SignerBlockProto)object2;
                object = destination$iv$iv;
                boolean bl11 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                SignerBlock signerBlock = new SignerBlock(it);
                object.add(signerBlock);
            }
            object = (List)destination$iv$iv;
            Intrinsics.checkNotNullExpressionValue((Object)protobufContent, (String)"protobufContent");
            DefaultConstructorMarker defaultConstructorMarker = null;
            ZipMetadataProto zipMetadataProto = protobufContent;
            Object object3 = object;
            Collection<Digest> collection2 = collection;
            return new ZipMetadata((List)collection2, (List)object3, zipMetadataProto, defaultConstructorMarker);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

