/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.serialization.ClassData;
import kotlin.reflect.jvm.internal.impl.serialization.ClassDataWithSource;
import kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassDataFinder;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProtoBasedClassDataFinder
implements ClassDataFinder {
    private final Map<ClassId, ProtoBuf.Class> classIdToProto;
    private final NameResolver nameResolver;
    private final Function1<ClassId, SourceElement> classSource;

    @NotNull
    public final Collection<ClassId> getAllClassIds$kotlin_core() {
        return this.classIdToProto.keySet();
    }

    @Override
    @Nullable
    public ClassDataWithSource findClassData(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        ProtoBuf.Class clazz = this.classIdToProto.get(classId);
        if (clazz == null) {
            return null;
        }
        ProtoBuf.Class classProto = clazz;
        return new ClassDataWithSource(new ClassData(this.nameResolver, classProto), (SourceElement)this.classSource.invoke((Object)classId));
    }

    /*
     * WARNING - void declaration
     */
    public ProtoBasedClassDataFinder(@NotNull ProtoBuf.PackageFragment proto, @NotNull NameResolver nameResolver, @NotNull Function1<? super ClassId, ? extends SourceElement> classSource) {
        Map map2;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        Intrinsics.checkParameterIsNotNull((Object)nameResolver, (String)"nameResolver");
        Intrinsics.checkParameterIsNotNull(classSource, (String)"classSource");
        this.nameResolver = nameResolver;
        this.classSource = classSource;
        Iterable iterable = proto.getClass_List();
        ProtoBasedClassDataFinder protoBasedClassDataFinder = this;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        void var7_7 = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            void klass;
            ProtoBuf.Class clazz = (ProtoBuf.Class)element$iv$iv;
            map2 = destination$iv$iv;
            ClassId classId = this.nameResolver.getClassId(klass.getFqName());
            map2.put(classId, element$iv$iv);
        }
        protoBasedClassDataFinder.classIdToProto = map2 = destination$iv$iv;
    }
}

