/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.maven;

import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.arguments.K2MetadataCompilerArguments;
import org.jetbrains.kotlin.cli.metadata.K2MetadataCompiler;
import org.jetbrains.kotlin.maven.KotlinCompileMojoBase;
import org.jetbrains.kotlin.maven.Util;

@Mojo(name="metadata", defaultPhase=LifecyclePhase.PROCESS_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class MetadataMojo
extends KotlinCompileMojoBase<K2MetadataCompilerArguments> {
    @Parameter(defaultValue="${project.compileClasspathElements}", required=true, readonly=true)
    public List<String> classpath;
    @Parameter(defaultValue="${project.testClasspathElements}", required=true, readonly=true)
    public List<String> testClasspath;

    @Override
    protected List<String> getRelatedSourceRoots(MavenProject project) {
        return Collections.emptyList();
    }

    @Override
    @NotNull
    protected CLICompiler<K2MetadataCompilerArguments> createCompiler() {
        return new K2MetadataCompiler();
    }

    @Override
    @NotNull
    protected K2MetadataCompilerArguments createCompilerArguments() {
        return new K2MetadataCompilerArguments();
    }

    @Override
    protected void configureSpecificCompilerArguments(@NotNull K2MetadataCompilerArguments arguments, @NotNull List<File> sourceRoots) throws MojoExecutionException {
        arguments.setDestination(this.output);
        if (!arguments.getMultiPlatform()) {
            this.getLog().info((CharSequence)"multiPlatform forced for metadata generation");
            arguments.setMultiPlatform(true);
        }
        List<String> classpathList = Util.filterClassPath(this.project.getBasedir(), this.classpath);
        classpathList.remove(this.project.getBuild().getOutputDirectory());
        if (!classpathList.isEmpty()) {
            String classPathString = StringUtil.join(classpathList, (String)File.pathSeparator);
            this.getLog().debug((CharSequence)("Classpath: " + classPathString));
            arguments.setClasspath(classPathString);
        }
    }
}

