/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.commons.io.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import org.jetbrains.kotlin.org.apache.commons.io.function.Uncheck;

public final class FilesUncheck {
    public static long copy(InputStream in, Path target2, CopyOption ... options) {
        return Uncheck.apply(Files::copy, in, target2, options);
    }

    public static long copy(Path source2, OutputStream out) {
        return Uncheck.apply(Files::copy, source2, out);
    }

    public static Path copy(Path source2, Path target2, CopyOption ... options) {
        return Uncheck.apply(Files::copy, source2, target2, options);
    }

    public static Path createDirectories(Path dir2, FileAttribute<?> ... attrs) {
        return Uncheck.apply(Files::createDirectories, dir2, attrs);
    }

    public static Path createDirectory(Path dir2, FileAttribute<?> ... attrs) {
        return Uncheck.apply(Files::createDirectory, dir2, attrs);
    }

    public static Path createFile(Path path, FileAttribute<?> ... attrs) {
        return Uncheck.apply(Files::createFile, path, attrs);
    }

    public static Path createLink(Path link2, Path existing) {
        return Uncheck.apply(Files::createLink, link2, existing);
    }

    public static Path createSymbolicLink(Path link2, Path target2, FileAttribute<?> ... attrs) {
        return Uncheck.apply(Files::createSymbolicLink, link2, target2, attrs);
    }

    public static Path createTempDirectory(Path dir2, String prefix, FileAttribute<?> ... attrs) {
        return Uncheck.apply(Files::createTempDirectory, dir2, prefix, attrs);
    }

    public static Path createTempDirectory(String prefix, FileAttribute<?> ... attrs) {
        return Uncheck.apply(Files::createTempDirectory, prefix, attrs);
    }

    public static Path createTempFile(Path dir2, String prefix, String suffix, FileAttribute<?> ... attrs) {
        return Uncheck.apply(Files::createTempFile, dir2, prefix, suffix, attrs);
    }

    public static Path createTempFile(String prefix, String suffix, FileAttribute<?> ... attrs) {
        return Uncheck.apply(Files::createTempFile, prefix, suffix, attrs);
    }

    public static void delete(Path path) {
        Uncheck.accept(Files::delete, path);
    }

    public static boolean deleteIfExists(Path path) {
        return Uncheck.apply(Files::deleteIfExists, path);
    }

    public static Stream<Path> find(Path start2, int maxDepth, BiPredicate<Path, BasicFileAttributes> matcher, FileVisitOption ... options) {
        return Uncheck.apply(Files::find, start2, maxDepth, matcher, options);
    }

    public static Object getAttribute(Path path, String attribute, LinkOption ... options) {
        return Uncheck.apply(Files::getAttribute, path, attribute, options);
    }

    public static FileStore getFileStore(Path path) {
        return Uncheck.apply(Files::getFileStore, path);
    }

    public static FileTime getLastModifiedTime(Path path, LinkOption ... options) {
        return Uncheck.apply(Files::getLastModifiedTime, path, options);
    }

    public static UserPrincipal getOwner(Path path, LinkOption ... options) {
        return Uncheck.apply(Files::getOwner, path, options);
    }

    public static Set<PosixFilePermission> getPosixFilePermissions(Path path, LinkOption ... options) {
        return Uncheck.apply(Files::getPosixFilePermissions, path, options);
    }

    public static boolean isHidden(Path path) {
        return Uncheck.apply(Files::isHidden, path);
    }

    public static boolean isSameFile(Path path, Path path2) {
        return Uncheck.apply(Files::isSameFile, path, path2);
    }

    public static Stream<String> lines(Path path) {
        return Uncheck.apply(Files::lines, path);
    }

    public static Stream<String> lines(Path path, Charset cs) {
        return Uncheck.apply(Files::lines, path, cs);
    }

    public static Stream<Path> list(Path dir2) {
        return Uncheck.apply(Files::list, dir2);
    }

    public static Path move(Path source2, Path target2, CopyOption ... options) {
        return Uncheck.apply(Files::move, source2, target2, options);
    }

    public static BufferedReader newBufferedReader(Path path) {
        return Uncheck.apply(Files::newBufferedReader, path);
    }

    public static BufferedReader newBufferedReader(Path path, Charset cs) {
        return Uncheck.apply(Files::newBufferedReader, path, cs);
    }

    public static BufferedWriter newBufferedWriter(Path path, Charset cs, OpenOption ... options) {
        return Uncheck.apply(Files::newBufferedWriter, path, cs, options);
    }

    public static BufferedWriter newBufferedWriter(Path path, OpenOption ... options) {
        return Uncheck.apply(Files::newBufferedWriter, path, options);
    }

    public static SeekableByteChannel newByteChannel(Path path, OpenOption ... options) {
        return Uncheck.apply(Files::newByteChannel, path, options);
    }

    public static SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) {
        return Uncheck.apply(Files::newByteChannel, path, options, attrs);
    }

    public static DirectoryStream<Path> newDirectoryStream(Path dir2) {
        return Uncheck.apply(Files::newDirectoryStream, dir2);
    }

    public static DirectoryStream<Path> newDirectoryStream(Path dir2, DirectoryStream.Filter<? super Path> filter2) {
        return Uncheck.apply(Files::newDirectoryStream, dir2, filter2);
    }

    public static DirectoryStream<Path> newDirectoryStream(Path dir2, String glob) {
        return Uncheck.apply(Files::newDirectoryStream, dir2, glob);
    }

    public static InputStream newInputStream(Path path, OpenOption ... options) {
        return Uncheck.apply(Files::newInputStream, path, options);
    }

    public static OutputStream newOutputStream(Path path, OpenOption ... options) {
        return Uncheck.apply(Files::newOutputStream, path, options);
    }

    public static String probeContentType(Path path) {
        return Uncheck.apply(Files::probeContentType, path);
    }

    public static byte[] readAllBytes(Path path) {
        return Uncheck.apply(Files::readAllBytes, path);
    }

    public static List<String> readAllLines(Path path) {
        return Uncheck.apply(Files::readAllLines, path);
    }

    public static List<String> readAllLines(Path path, Charset cs) {
        return Uncheck.apply(Files::readAllLines, path, cs);
    }

    public static <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) {
        return (A)Uncheck.apply(Files::readAttributes, path, type, options);
    }

    public static Map<String, Object> readAttributes(Path path, String attributes2, LinkOption ... options) {
        return Uncheck.apply(Files::readAttributes, path, attributes2, options);
    }

    public static Path readSymbolicLink(Path link2) {
        return Uncheck.apply(Files::readSymbolicLink, link2);
    }

    public static Path setAttribute(Path path, String attribute, Object value2, LinkOption ... options) {
        return Uncheck.apply(Files::setAttribute, path, attribute, value2, options);
    }

    public static Path setLastModifiedTime(Path path, FileTime time) {
        return Uncheck.apply(Files::setLastModifiedTime, path, time);
    }

    public static Path setOwner(Path path, UserPrincipal owner) {
        return Uncheck.apply(Files::setOwner, path, owner);
    }

    public static Path setPosixFilePermissions(Path path, Set<PosixFilePermission> perms) {
        return Uncheck.apply(Files::setPosixFilePermissions, path, perms);
    }

    public static long size(Path path) {
        return Uncheck.apply(Files::size, path);
    }

    public static Stream<Path> walk(Path start2, FileVisitOption ... options) {
        return Uncheck.apply(Files::walk, start2, options);
    }

    public static Stream<Path> walk(Path start2, int maxDepth, FileVisitOption ... options) {
        return Uncheck.apply(Files::walk, start2, maxDepth, options);
    }

    public static Path walkFileTree(Path start2, FileVisitor<? super Path> visitor2) {
        return Uncheck.apply(Files::walkFileTree, start2, visitor2);
    }

    public static Path walkFileTree(Path start2, Set<FileVisitOption> options, int maxDepth, FileVisitor<? super Path> visitor2) {
        return Uncheck.apply(Files::walkFileTree, start2, options, maxDepth, visitor2);
    }

    public static Path write(Path path, byte[] bytes, OpenOption ... options) {
        return Uncheck.apply(Files::write, path, bytes, options);
    }

    public static Path write(Path path, Iterable<? extends CharSequence> lines, Charset cs, OpenOption ... options) {
        return Uncheck.apply(Files::write, path, lines, cs, options);
    }

    public static Path write(Path path, Iterable<? extends CharSequence> lines, OpenOption ... options) {
        return Uncheck.apply(Files::write, path, lines, options);
    }

    private FilesUncheck() {
    }
}

