/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.commons.compress.harmony.unpack200.bytecode;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.kotlin.org.apache.commons.compress.harmony.unpack200.bytecode.CPClass;
import org.jetbrains.kotlin.org.apache.commons.compress.harmony.unpack200.bytecode.CPNameAndType;
import org.jetbrains.kotlin.org.apache.commons.compress.harmony.unpack200.bytecode.ClassConstantPool;
import org.jetbrains.kotlin.org.apache.commons.compress.harmony.unpack200.bytecode.ClassFileEntry;
import org.jetbrains.kotlin.org.apache.commons.compress.harmony.unpack200.bytecode.ConstantPoolEntry;

public class CPFieldRef
extends ConstantPoolEntry {
    CPClass className;
    transient int classNameIndex;
    private final CPNameAndType nameAndType;
    transient int nameAndTypeIndex;
    private boolean hashCodeComputed;
    private int cachedHashCode;

    public CPFieldRef(CPClass className, CPNameAndType descriptor2, int globalIndex) {
        super((byte)9, globalIndex);
        this.className = className;
        this.nameAndType = descriptor2;
    }

    @Override
    public boolean equals(Object obj2) {
        if (this == obj2) {
            return true;
        }
        if (obj2 == null) {
            return false;
        }
        if (this.getClass() != obj2.getClass()) {
            return false;
        }
        CPFieldRef other = (CPFieldRef)obj2;
        return Objects.equals(this.className, other.className) && Objects.equals(this.nameAndType, other.nameAndType);
    }

    private void generateHashCode() {
        this.hashCodeComputed = true;
        int PRIME = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.className == null ? 0 : this.className.hashCode());
        this.cachedHashCode = result2 = 31 * result2 + (this.nameAndType == null ? 0 : this.nameAndType.hashCode());
    }

    @Override
    protected ClassFileEntry[] getNestedClassFileEntries() {
        return new ClassFileEntry[]{this.className, this.nameAndType};
    }

    @Override
    public int hashCode() {
        if (!this.hashCodeComputed) {
            this.generateHashCode();
        }
        return this.cachedHashCode;
    }

    @Override
    protected void resolve(ClassConstantPool pool) {
        super.resolve(pool);
        this.nameAndTypeIndex = pool.indexOf(this.nameAndType);
        this.classNameIndex = pool.indexOf(this.className);
    }

    @Override
    public String toString() {
        return "FieldRef: " + this.className + "#" + this.nameAndType;
    }

    @Override
    protected void writeBody(DataOutputStream dos) throws IOException {
        dos.writeShort(this.classNameIndex);
        dos.writeShort(this.nameAndTypeIndex);
    }
}

