/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.tasks.publishing;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.openpgp.PGPSignature;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;
import org.gradle.workers.ClassLoaderWorkerSpec;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.KotlinToolingDiagnostics;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.ToolingDiagnostic;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.UsesKotlinToolingDiagnostics;
import org.jetbrains.kotlin.gradle.tasks.publishing.HelpersKt;

@DisableCachingByDefault(because="Result relies on a server call and has no outputs.")
@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0006\b'\u0018\u00002\u00020\u00012\u00020\u0002:\u0002./B\u000f\b\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010)\u001a\u00020*H\u0002J\b\u0010+\u001a\u00020*H\u0002J\b\u0010,\u001a\u00020*H\u0002J\b\u0010-\u001a\u00020*H\u0005R\u0014\u0010\u0006\u001a\u00020\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000eR\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000eR\u0014\u0010\u0017\u001a\u00020\u00188gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u001c8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00130\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u000eR \u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00130\"8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00130\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u000eR\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/publishing/CheckSigningTask;", "Lorg/gradle/api/DefaultTask;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/UsesKotlinToolingDiagnostics;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/gradle/workers/WorkerExecutor;)V", "bouncyCastleClasspath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getBouncyCastleClasspath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "exampleSignature", "Lorg/gradle/api/provider/Property;", "", "getExampleSignature", "()Lorg/gradle/api/provider/Property;", "gradleHomePath", "", "getGradleHomePath", "hasKeyPassword", "", "getHasKeyPassword", "keyId", "getKeyId", "keyringPath", "Lorg/gradle/api/file/RegularFileProperty;", "getKeyringPath", "()Lorg/gradle/api/file/RegularFileProperty;", "keyservers", "Lorg/gradle/api/provider/ListProperty;", "getKeyservers", "()Lorg/gradle/api/provider/ListProperty;", "offlineMode", "getOfflineMode", "publicationNamesWithSigning", "Lorg/gradle/api/provider/MapProperty;", "getPublicationNamesWithSigning", "()Lorg/gradle/api/provider/MapProperty;", "signatoryExists", "getSignatoryExists", "signatoryKeyId", "getSignatoryKeyId", "checkPublicKeyUploaded", "", "checkPublicationsHaveSigningEnabled", "checkSignatoryConfigured", "execute", "CheckKeyservers", "CheckKeyserversParameters", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nCheckSigningTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckSigningTask.kt\norg/jetbrains/kotlin/gradle/tasks/publishing/CheckSigningTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,248:1\n3199#2,10:249\n1549#2:259\n1620#2,3:260\n1851#2,2:263\n1851#2,2:265\n*S KotlinDebug\n*F\n+ 1 CheckSigningTask.kt\norg/jetbrains/kotlin/gradle/tasks/publishing/CheckSigningTask\n*L\n148#1:249,10\n165#1:259\n165#1:260,3\n211#1:263,2\n214#1:265,2\n*E\n"})
public abstract class CheckSigningTask
extends DefaultTask
implements UsesKotlinToolingDiagnostics {
    @NotNull
    private final WorkerExecutor workerExecutor;

    @Inject
    public CheckSigningTask(@NotNull WorkerExecutor workerExecutor) {
        Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
        this.workerExecutor = workerExecutor;
    }

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getKeyId();

    @Input
    @Optional
    @NotNull
    public abstract Property<Boolean> getHasKeyPassword();

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @NotNull
    public abstract RegularFileProperty getKeyringPath();

    @Input
    @NotNull
    public abstract MapProperty<String, Boolean> getPublicationNamesWithSigning();

    @Input
    @NotNull
    public abstract Property<Boolean> getSignatoryExists();

    @Input
    @NotNull
    public abstract Property<String> getGradleHomePath();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getSignatoryKeyId();

    @Input
    @Optional
    @NotNull
    public abstract Property<byte[]> getExampleSignature();

    @Input
    @NotNull
    public abstract ListProperty<String> getKeyservers();

    @Internal
    @NotNull
    public abstract ConfigurableFileCollection getBouncyCastleClasspath();

    @Internal
    @NotNull
    public abstract Property<Boolean> getOfflineMode();

    @TaskAction
    protected final void execute() {
        this.checkSignatoryConfigured();
        this.checkPublicKeyUploaded();
        this.checkPublicationsHaveSigningEnabled();
    }

    /*
     * WARNING - void declaration
     */
    private final void checkPublicationsHaveSigningEnabled() {
        Iterable $this$partition$iv = ((Map)this.getPublicationNamesWithSigning().get()).entrySet();
        boolean $i$f$partition = false;
        Iterable<Object> first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            Map.Entry entry2 = (Map.Entry)element$iv;
            boolean bl = false;
            Boolean signed = (Boolean)entry2.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)signed, (String)"signed");
            if (signed.booleanValue()) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List signedPublications = (List)pair.component1();
        List unsignedPublications = (List)pair.component2();
        if (signedPublications.isEmpty()) {
            this.reportDiagnostic(KotlinToolingDiagnostics.SigningMisconfigured.INSTANCE.invoke(StringsKt.trimIndent((String)"\n                    No publications are signed. Publishing to Maven Central will fail validation.\n                    \n                    To sign all publications you can add this to your build script:\n                    \n                    signing {\n                        sign(publishing.publications)\n                    }\n                "), "Please double check the settings used for signing.", "https://kotl.in/gradle-signing-plugin-what-to-sign"));
            return;
        }
        if (!((Collection)unsignedPublications).isEmpty()) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            first$iv = unsignedPublications;
            KotlinToolingDiagnostics.SomePublicationsNotSigned somePublicationsNotSigned = KotlinToolingDiagnostics.SomePublicationsNotSigned.INSTANCE;
            CheckSigningTask checkSigningTask = this;
            boolean $i$f$map = false;
            Iterator iterator2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Map.Entry entry3 = (Map.Entry)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add((String)it.getKey());
            }
            collection = (List)destination$iv$iv;
            checkSigningTask.reportDiagnostic(somePublicationsNotSigned.invoke((List<String>)collection));
        }
    }

    private final void checkPublicKeyUploaded() {
        Object object = this.getOfflineMode().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"offlineMode.get()");
        if (((Boolean)object).booleanValue()) {
            this.getLogger().warn("Skipping verification of public key with PGP keyservers because Gradle is running in offline mode.");
            return;
        }
        WorkQueue workQueue2 = this.workerExecutor.classLoaderIsolation(new Action(this){
            final /* synthetic */ CheckSigningTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(ClassLoaderWorkerSpec it) {
                Object[] objectArray = new Object[]{this.this$0.getBouncyCastleClasspath()};
                it.getClasspath().from(objectArray);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)workQueue2, (String)"private fun checkPublicK\u2026yservers)\n        }\n    }");
        WorkQueue workQueue3 = workQueue2;
        workQueue3.submit(CheckKeyservers.class, new Action(this){
            final /* synthetic */ CheckSigningTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(CheckKeyserversParameters parameters) {
                Property<String> property2 = parameters.getSignature();
                byte[] byArray = Base64.getEncoder().encode((byte[])this.this$0.getExampleSignature().get());
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoder().encode(exampleSignature.get())");
                property2.set((Object)StringsKt.decodeToString((byte[])byArray));
                parameters.getKeyservers().set((Provider)this.this$0.getKeyservers());
            }
        });
    }

    private final void checkSignatoryConfigured() {
        if (!((Boolean)this.getSignatoryExists().getOrElse((Object)false)).booleanValue()) {
            if (this.getKeyId().isPresent() || this.getKeyringPath().isPresent()) {
                String it;
                StringBuilder stringBuilder;
                List missingProperties = new ArrayList();
                List presentProperties = new ArrayList();
                if (this.getKeyId().isPresent()) {
                    ((Collection)presentProperties).add("* 'signing.keyId': " + (String)this.getKeyId().get());
                } else {
                    ((Collection)missingProperties).add("* 'signing.keyId' is not set. Please ensure you have the 'signing.keyId' property set to your key's ID.");
                }
                if (this.getKeyringPath().isPresent()) {
                    ((Collection)presentProperties).add("* 'signing.secretKeyRingFile': " + this.getKeyringPath().get());
                    if (!((RegularFile)this.getKeyringPath().get()).getAsFile().isFile()) {
                        ((Collection)missingProperties).add("* Looks like the path defined in 'signing.secretKeyRingFile' doesn't exist or cannot be read as a file.");
                    }
                } else {
                    ((Collection)missingProperties).add("* 'signing.secretKeyRingFile' is not set. Please ensure you have the 'signing.secretKeyRingFile' property set to your keyring's file path.");
                }
                Object object = this.getHasKeyPassword().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"hasKeyPassword.get()");
                if (((Boolean)object).booleanValue()) {
                    ((Collection)presentProperties).add("* 'signing.password' is set");
                } else {
                    ((Collection)missingProperties).add("* 'signing.password' is not set. Please ensure you have the 'signing.password' property set to your secret key's password.");
                }
                StringBuilder $this$checkSignatoryConfigured_u24lambda_u244 = stringBuilder = new StringBuilder();
                boolean bl = false;
                StringBuilder stringBuilder2 = $this$checkSignatoryConfigured_u24lambda_u244.append("Looks like you are trying to load the PGP key from disk:");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
                Iterable $this$forEach$iv = presentProperties;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (String)element$iv;
                    boolean bl2 = false;
                    StringBuilder stringBuilder3 = $this$checkSignatoryConfigured_u24lambda_u244.append(it);
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
                }
                Intrinsics.checkNotNullExpressionValue((Object)$this$checkSignatoryConfigured_u24lambda_u244.append('\n'), (String)"append('\\n')");
                StringBuilder stringBuilder4 = $this$checkSignatoryConfigured_u24lambda_u244.append("Some problems were found with the configuration:");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
                $this$forEach$iv = missingProperties;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (String)element$iv;
                    boolean bl3 = false;
                    StringBuilder stringBuilder5 = $this$checkSignatoryConfigured_u24lambda_u244.append(it);
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append('\\n')");
                }
                Intrinsics.checkNotNullExpressionValue((Object)$this$checkSignatoryConfigured_u24lambda_u244.append('\n'), (String)"append('\\n')");
                StringBuilder stringBuilder6 = $this$checkSignatoryConfigured_u24lambda_u244.append("Ensure that you have the missing properties set, for example by putting them into " + (String)this.getGradleHomePath().get() + File.separator + "gradle.properties:");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append('\\n')");
                StringBuilder stringBuilder7 = $this$checkSignatoryConfigured_u24lambda_u244.append(StringsKt.trimIndent((String)("\n                        signing.keyId=" + (String)this.getKeyId().getOrElse((Object)"<YOUR_KEY_ID>") + "\n                        signing.password=<YOUR_PASSWORD>\n                        signing.secretKeyRingFile=" + (this.getKeyringPath().isPresent() ? ((RegularFile)this.getKeyringPath().get()).getAsFile() : "<YOUR_KEYRING_FILE_PATH>") + "\n                    ")));
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append('\\n')");
                String string = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
                String errorMessage = string;
                this.reportDiagnostic(KotlinToolingDiagnostics.SigningMisconfigured.INSTANCE.invoke(errorMessage, "Please double check the settings used for signing.", "https://kotl.in/gradle-signing-signatory-credentials"));
                return;
            }
            this.reportDiagnostic(KotlinToolingDiagnostics.SigningMisconfigured.INSTANCE.invoke(StringsKt.trimIndent((String)"\n                    Could not detect a signing configuration.\n                    \n                    Please note: if you do not have a signing key, you can generate one by running the 'generatePgpKeys' task.\n                "), "Please ensure you provide the required Gradle properties pointing to your signing key or configure an in-memory key.", "https://kotl.in/gradle-signing-signatory-credentials"));
        }
    }

    @Override
    public void reportDiagnostic(@NotNull ToolingDiagnostic diagnostic) {
        UsesKotlinToolingDiagnostics.DefaultImpls.reportDiagnostic(this, diagnostic);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b \u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\nH\u0016R\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/publishing/CheckSigningTask$CheckKeyservers;", "Lorg/gradle/workers/WorkAction;", "Lorg/jetbrains/kotlin/gradle/tasks/publishing/CheckSigningTask$CheckKeyserversParameters;", "()V", "keyIdHex", "", "Lorg/bouncycastle/openpgp/PGPSignature;", "getKeyIdHex", "(Lorg/bouncycastle/openpgp/PGPSignature;)Ljava/lang/String;", "execute", "", "Companion", "kotlin-gradle-plugin_common"})
    @SourceDebugExtension(value={"SMAP\nCheckSigningTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckSigningTask.kt\norg/jetbrains/kotlin/gradle/tasks/publishing/CheckSigningTask$CheckKeyservers\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,248:1\n1549#2:249\n1620#2,3:250\n1743#2,3:253\n*S KotlinDebug\n*F\n+ 1 CheckSigningTask.kt\norg/jetbrains/kotlin/gradle/tasks/publishing/CheckSigningTask$CheckKeyservers\n*L\n102#1:249\n102#1:250,3\n102#1:253,3\n*E\n"})
    public static abstract class CheckKeyservers
    implements WorkAction<CheckKeyserversParameters> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private static final Logger logger;

        private final String getKeyIdHex(PGPSignature $this$keyIdHex) {
            return HelpersKt.keyIdToHex($this$keyIdHex.getKeyID());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public void execute() {
            boolean keyFound;
            Object longKeyId;
            block25: {
                boolean bl;
                void $this$mapTo$iv$iv;
                byte[] byArray = Base64.getDecoder().decode((String)((CheckKeyserversParameters)this.getParameters()).getSignature().get());
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getDecoder().decode(parameters.signature.get())");
                Object object = byArray;
                object = (Closeable)new BCPGInputStream((InputStream)new ByteArrayInputStream((byte[])object));
                Throwable throwable = null;
                try {
                    Object it = (BCPGInputStream)object;
                    boolean bl2 = false;
                    it = this.getKeyIdHex(new PGPSignature(it));
                }
                catch (Throwable it) {
                    throwable = it;
                    throw it;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                longKeyId = it;
                Object object2 = ((CheckKeyserversParameters)this.getParameters()).getKeyservers().get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameters.keyservers.get()");
                Iterable $this$map$iv = (Iterable)object2;
                boolean $i$f$map = false;
                Iterable bl2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(URI.create((String)it + "/pks/lookup?op=get&search=0x" + (String)longKeyId).toURL());
                }
                Iterable $this$any$iv = (List)destination$iv$iv;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        boolean bl4;
                        block24: {
                            URL url = (URL)element$iv;
                            boolean bl5 = false;
                            URLConnection uRLConnection = url.openConnection();
                            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
                            HttpURLConnection connection = (HttpURLConnection)uRLConnection;
                            try {
                                InputStream inputStream = connection.getInputStream();
                                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"connection.inputStream");
                                Closeable closeable = inputStream;
                                Object bl3 = Charsets.UTF_8;
                                closeable = new InputStreamReader((InputStream)closeable, (Charset)bl3);
                                bl3 = null;
                                try {
                                    InputStreamReader it = (InputStreamReader)closeable;
                                    boolean bl6 = false;
                                    logger.quiet("Public key found on keyserver: '" + connection.getURL().getHost() + '\'');
                                    Unit unit = Unit.INSTANCE;
                                }
                                catch (Throwable throwable2) {
                                    bl3 = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)bl3);
                                }
                                boolean bl7 = true;
                                bl4 = bl7;
                            }
                            catch (IOException e) {
                                if (connection.getResponseCode() == 404) {
                                    boolean bl8 = false;
                                    bl4 = bl8;
                                    break block24;
                                }
                                throw e;
                            }
                            finally {
                                connection.disconnect();
                            }
                        }
                        if (!bl4) continue;
                        bl = true;
                        break block25;
                    }
                    bl = keyFound = false;
                }
            }
            if (!keyFound) {
                boolean bl = false;
                StringBuilder stringBuilder = new StringBuilder().append("\n                None of the keyservers contain the public key with id: ").append(StringsKt.takeLast((String)longKeyId, (int)8)).append("\n                Keyservers checked: ");
                Object object = ((CheckKeyserversParameters)this.getParameters()).getKeyservers().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.keyservers.get()");
                String string = StringsKt.trimIndent((String)stringBuilder.append(CollectionsKt.joinToString$default((Iterable)((Iterable)object), null, null, null, (int)0, null, null, (int)63, null)).append("\n                \n                You can upload your key to a keyserver with:\n                \n                gradlew uploadPublicPgpKey --keyring=PATH/TO/ARMORED_ASCII_PUBLIC_KEY.asc\n                \n                See https://kotl.in/sonatype-distributing-public-key for more details.\n            ").toString());
                throw new IllegalStateException(string.toString());
            }
        }

        static {
            Logger logger2 = Logging.getLogger(CheckKeyservers.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(CheckKeyservers::class.java)");
            logger = logger2;
        }

        @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/publishing/CheckSigningTask$CheckKeyservers$Companion;", "", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin-gradle-plugin_common"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b`\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/publishing/CheckSigningTask$CheckKeyserversParameters;", "Lorg/gradle/workers/WorkParameters;", "keyservers", "Lorg/gradle/api/provider/ListProperty;", "", "getKeyservers", "()Lorg/gradle/api/provider/ListProperty;", "signature", "Lorg/gradle/api/provider/Property;", "getSignature", "()Lorg/gradle/api/provider/Property;", "kotlin-gradle-plugin_common"})
    public static interface CheckKeyserversParameters
    extends WorkParameters {
        @NotNull
        public Property<String> getSignature();

        @NotNull
        public ListProperty<String> getKeyservers();
    }
}

