/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.sources.android.configurator;

import com.android.build.gradle.api.AndroidSourceDirectorySet;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.api.BaseVariant;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinAndroidTarget;
import org.jetbrains.kotlin.gradle.plugin.sources.KotlinSourceSetFactory;
import org.jetbrains.kotlin.gradle.plugin.sources.android.configurator.KotlinAndroidSourceSetConfigurator;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/sources/android/configurator/MultiplatformAndroidResourceDirConfigurator;", "Lorg/jetbrains/kotlin/gradle/plugin/sources/android/configurator/KotlinAndroidSourceSetConfigurator;", "()V", "configure", "", "target", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinAndroidTarget;", "kotlinSourceSet", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSet;", "androidSourceSet", "Lcom/android/build/gradle/api/AndroidSourceSet;", "Lorg/jetbrains/kotlin/gradle/utils/DeprecatedAndroidSourceSet;", "kotlin-gradle-plugin_common"})
public final class MultiplatformAndroidResourceDirConfigurator
implements KotlinAndroidSourceSetConfigurator {
    @NotNull
    public static final MultiplatformAndroidResourceDirConfigurator INSTANCE = new MultiplatformAndroidResourceDirConfigurator();

    private MultiplatformAndroidResourceDirConfigurator() {
    }

    @Override
    public void configure(@NotNull KotlinAndroidTarget target2, @NotNull KotlinSourceSet kotlinSourceSet, @NotNull AndroidSourceSet androidSourceSet) {
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter((Object)kotlinSourceSet, (String)"kotlinSourceSet");
        Intrinsics.checkNotNullParameter((Object)androidSourceSet, (String)"androidSourceSet");
        if (Intrinsics.areEqual((Object)kotlinSourceSet.getName(), (Object)androidSourceSet.getName())) {
            return;
        }
        Project project = target2.getProject();
        AndroidSourceDirectorySet androidSourceDirectorySet = androidSourceSet.getResources();
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)kotlinSourceSet.getResources().getSrcDirs(), (String)"kotlinSourceSet.resources.srcDirs");
        androidSourceDirectorySet.srcDirs(objectArray);
        if (!((Collection)androidSourceSet.getResources().getSrcDirs()).isEmpty()) {
            AndroidSourceDirectorySet androidSourceDirectorySet2 = androidSourceSet.getResources();
            String string = kotlinSourceSet.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"kotlinSourceSet.name");
            androidSourceDirectorySet2.srcDir((Object)KotlinSourceSetFactory.Companion.defaultSourceFolder(project, string, "resources"));
            objectArray = new Object[]{androidSourceSet.getResources().getSrcDirs()};
            kotlinSourceSet.getResources().srcDirs(objectArray);
        }
        if (!((Collection)androidSourceSet.getAssets().getSrcDirs()).isEmpty()) {
            AndroidSourceDirectorySet androidSourceDirectorySet3 = androidSourceSet.getAssets();
            String string = kotlinSourceSet.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"kotlinSourceSet.name");
            androidSourceDirectorySet3.srcDir((Object)KotlinSourceSetFactory.Companion.defaultSourceFolder(project, string, "assets"));
        }
        if (!((Collection)androidSourceSet.getRes().getSrcDirs()).isEmpty()) {
            AndroidSourceDirectorySet androidSourceDirectorySet4 = androidSourceSet.getRes();
            String string = kotlinSourceSet.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"kotlinSourceSet.name");
            androidSourceDirectorySet4.srcDir((Object)KotlinSourceSetFactory.Companion.defaultSourceFolder(project, string, "res"));
        }
        if (!((Collection)androidSourceSet.getAidl().getSrcDirs()).isEmpty()) {
            AndroidSourceDirectorySet androidSourceDirectorySet5 = androidSourceSet.getAidl();
            String string = kotlinSourceSet.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"kotlinSourceSet.name");
            androidSourceDirectorySet5.srcDir((Object)KotlinSourceSetFactory.Companion.defaultSourceFolder(project, string, "aidl"));
        }
        if (!((Collection)androidSourceSet.getRenderscript().getSrcDirs()).isEmpty()) {
            AndroidSourceDirectorySet androidSourceDirectorySet6 = androidSourceSet.getRenderscript();
            String string = kotlinSourceSet.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"kotlinSourceSet.name");
            androidSourceDirectorySet6.srcDir((Object)KotlinSourceSetFactory.Companion.defaultSourceFolder(project, string, "rs"));
        }
        if (!((Collection)androidSourceSet.getJni().getSrcDirs()).isEmpty()) {
            AndroidSourceDirectorySet androidSourceDirectorySet7 = androidSourceSet.getJni();
            String string = kotlinSourceSet.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"kotlinSourceSet.name");
            androidSourceDirectorySet7.srcDir((Object)KotlinSourceSetFactory.Companion.defaultSourceFolder(project, string, "jni"));
        }
        if (!((Collection)androidSourceSet.getJniLibs().getSrcDirs()).isEmpty()) {
            AndroidSourceDirectorySet androidSourceDirectorySet8 = androidSourceSet.getJniLibs();
            String string = kotlinSourceSet.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"kotlinSourceSet.name");
            androidSourceDirectorySet8.srcDir((Object)KotlinSourceSetFactory.Companion.defaultSourceFolder(project, string, "jniLibs"));
        }
        if (!((Collection)androidSourceSet.getShaders().getSrcDirs()).isEmpty()) {
            AndroidSourceDirectorySet androidSourceDirectorySet9 = androidSourceSet.getShaders();
            String string = kotlinSourceSet.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"kotlinSourceSet.name");
            androidSourceDirectorySet9.srcDir((Object)KotlinSourceSetFactory.Companion.defaultSourceFolder(project, string, "shaders"));
        }
    }

    @Override
    public void configureWithVariant(@NotNull KotlinAndroidTarget target2, @NotNull KotlinSourceSet kotlinSourceSet, @NotNull BaseVariant variant) {
        KotlinAndroidSourceSetConfigurator.DefaultImpls.configureWithVariant(this, target2, kotlinSourceSet, variant);
    }
}

