/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.sources.android.checker;

import com.android.Version;
import com.android.build.gradle.api.AndroidSourceSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.AndroidGradlePluginVersion;
import org.jetbrains.kotlin.gradle.plugin.AndroidGradlePluginVersionKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.KotlinToolingDiagnostics;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.KotlinToolingDiagnosticsCollector;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.KotlinToolingDiagnosticsCollectorKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinAndroidTarget;
import org.jetbrains.kotlin.gradle.plugin.sources.android.KotlinAndroidSourceSetLayout;
import org.jetbrains.kotlin.gradle.plugin.sources.android.checker.KotlinAndroidSourceSetLayoutChecker;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\r\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/sources/android/checker/MultiplatformLayoutV2AgpRequirementChecker;", "Lorg/jetbrains/kotlin/gradle/plugin/sources/android/checker/KotlinAndroidSourceSetLayoutChecker;", "()V", "minimumRequiredAgpVersion", "Lorg/jetbrains/kotlin/gradle/plugin/AndroidGradlePluginVersion;", "getMinimumRequiredAgpVersion$kotlin_gradle_plugin_common", "()Lorg/jetbrains/kotlin/gradle/plugin/AndroidGradlePluginVersion;", "checkBeforeLayoutApplied", "", "diagnosticsCollector", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnosticsCollector;", "target", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinAndroidTarget;", "layout", "Lorg/jetbrains/kotlin/gradle/plugin/sources/android/KotlinAndroidSourceSetLayout;", "isAgpRequirementMet", "", "isAgpRequirementMet$kotlin_gradle_plugin_common", "kotlin-gradle-plugin_common"})
public final class MultiplatformLayoutV2AgpRequirementChecker
implements KotlinAndroidSourceSetLayoutChecker {
    @NotNull
    public static final MultiplatformLayoutV2AgpRequirementChecker INSTANCE = new MultiplatformLayoutV2AgpRequirementChecker();
    @NotNull
    private static final AndroidGradlePluginVersion minimumRequiredAgpVersion = new AndroidGradlePluginVersion(7, 0, 0, null, 8, null);

    private MultiplatformLayoutV2AgpRequirementChecker() {
    }

    @NotNull
    public final AndroidGradlePluginVersion getMinimumRequiredAgpVersion$kotlin_gradle_plugin_common() {
        return minimumRequiredAgpVersion;
    }

    @Override
    public void checkBeforeLayoutApplied(@NotNull KotlinToolingDiagnosticsCollector diagnosticsCollector, @NotNull KotlinAndroidTarget target2, @NotNull KotlinAndroidSourceSetLayout layout) {
        Intrinsics.checkNotNullParameter((Object)diagnosticsCollector, (String)"diagnosticsCollector");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        if (!this.isAgpRequirementMet$kotlin_gradle_plugin_common()) {
            Project project = target2.getProject();
            String string = minimumRequiredAgpVersion.toString();
            String string2 = Version.ANDROID_GRADLE_PLUGIN_VERSION;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ANDROID_GRADLE_PLUGIN_VERSION");
            KotlinToolingDiagnosticsCollectorKt.reportOncePerGradleBuild$default(diagnosticsCollector, project, KotlinToolingDiagnostics.AgpRequirementNotMetForAndroidSourceSetLayoutV2.INSTANCE.invoke(string, string2), null, 4, null);
        }
    }

    public final boolean isAgpRequirementMet$kotlin_gradle_plugin_common() {
        return AndroidGradlePluginVersionKt.isAtLeast(AndroidGradlePluginVersion.Companion.getCurrentOrNull(), minimumRequiredAgpVersion);
    }

    @Override
    public void checkCreatedSourceSet(@NotNull KotlinToolingDiagnosticsCollector diagnosticsCollector, @NotNull KotlinAndroidTarget target2, @NotNull KotlinAndroidSourceSetLayout layout, @NotNull KotlinSourceSet kotlinSourceSet, @NotNull AndroidSourceSet androidSourceSet) {
        KotlinAndroidSourceSetLayoutChecker.DefaultImpls.checkCreatedSourceSet(this, diagnosticsCollector, target2, layout, kotlinSourceSet, androidSourceSet);
    }
}

