/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.sources.android;

import com.android.build.gradle.api.BaseVariant;
import com.android.builder.model.SourceProvider;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinAndroidTarget;
import org.jetbrains.kotlin.gradle.plugin.sources.android.AndroidBaseSourceSetName;
import org.jetbrains.kotlin.gradle.plugin.sources.android.AndroidVariantType;
import org.jetbrains.kotlin.gradle.plugin.sources.android.AndroidVariantTypeKt;
import org.jetbrains.kotlin.gradle.plugin.sources.android.KotlinAndroidSourceSetInfoKt;
import org.jetbrains.kotlin.gradle.plugin.sources.android.KotlinAndroidSourceSetNaming;
import org.jetbrains.kotlin.gradle.utils.StringUtilsKt;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010H\u0016J$\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\u00020\u0007*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/sources/android/MultiplatformLayoutV2KotlinAndroidSourceSetNaming;", "Lorg/jetbrains/kotlin/gradle/plugin/sources/android/KotlinAndroidSourceSetNaming;", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "kotlinName", "", "Lorg/jetbrains/kotlin/gradle/plugin/sources/android/AndroidBaseSourceSetName;", "getKotlinName", "(Lorg/jetbrains/kotlin/gradle/plugin/sources/android/AndroidBaseSourceSetName;)Ljava/lang/String;", "defaultKotlinSourceSetName", "target", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinAndroidTarget;", "variant", "Lcom/android/build/gradle/api/BaseVariant;", "Lorg/jetbrains/kotlin/gradle/utils/DeprecatedAndroidBaseVariant;", "kotlinSourceSetName", "disambiguationClassifier", "androidSourceSetName", "type", "Lorg/jetbrains/kotlin/gradle/plugin/sources/android/AndroidVariantType;", "replaceAndroidBaseSourceSetName", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nMultiplatformLayoutV2KotlinAndroidSourceSetNaming.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiplatformLayoutV2KotlinAndroidSourceSetNaming.kt\norg/jetbrains/kotlin/gradle/plugin/sources/android/MultiplatformLayoutV2KotlinAndroidSourceSetNaming\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n1#2:62\n*E\n"})
public final class MultiplatformLayoutV2KotlinAndroidSourceSetNaming
implements KotlinAndroidSourceSetNaming {
    @NotNull
    public static final MultiplatformLayoutV2KotlinAndroidSourceSetNaming INSTANCE = new MultiplatformLayoutV2KotlinAndroidSourceSetNaming();
    private static final Logger logger = Logging.getLogger(INSTANCE.getClass());

    private MultiplatformLayoutV2KotlinAndroidSourceSetNaming() {
    }

    private final String getKotlinName(AndroidBaseSourceSetName $this$kotlinName) {
        String string;
        AndroidBaseSourceSetName androidBaseSourceSetName = $this$kotlinName;
        if (Intrinsics.areEqual((Object)androidBaseSourceSetName, (Object)AndroidBaseSourceSetName.Main.INSTANCE)) {
            string = "main";
        } else if (Intrinsics.areEqual((Object)androidBaseSourceSetName, (Object)AndroidBaseSourceSetName.Test.INSTANCE)) {
            string = "unitTest";
        } else if (Intrinsics.areEqual((Object)androidBaseSourceSetName, (Object)AndroidBaseSourceSetName.AndroidTest.INSTANCE)) {
            string = "instrumentedTest";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @Override
    @Nullable
    public String kotlinSourceSetName(@NotNull String disambiguationClassifier, @NotNull String androidSourceSetName, @Nullable AndroidVariantType type) {
        Intrinsics.checkNotNullParameter((Object)disambiguationClassifier, (String)"disambiguationClassifier");
        Intrinsics.checkNotNullParameter((Object)androidSourceSetName, (String)"androidSourceSetName");
        AndroidVariantType androidVariantType = type;
        if (androidVariantType == null) {
            AndroidBaseSourceSetName androidBaseSourceSetName = AndroidBaseSourceSetName.Companion.byName(androidSourceSetName);
            androidVariantType = androidBaseSourceSetName != null ? AndroidVariantTypeKt.getVariantType(androidBaseSourceSetName) : null;
            if (androidVariantType == null) {
                return null;
            }
        }
        AndroidVariantType knownType = androidVariantType;
        String[] stringArray = new String[]{disambiguationClassifier, this.replaceAndroidBaseSourceSetName(androidSourceSetName, knownType)};
        return StringUtilsKt.lowerCamelCaseName(stringArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public String defaultKotlinSourceSetName(@NotNull KotlinAndroidTarget target2, @NotNull BaseVariant variant) {
        String kotlinSourceSetName;
        String string;
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        MultiplatformLayoutV2KotlinAndroidSourceSetNaming $this$defaultKotlinSourceSetName_u24lambda_u242 = this;
        boolean bl = false;
        AndroidBaseSourceSetName androidBaseSourceSetName = AndroidVariantTypeKt.getAndroidBaseSourceSetName(AndroidVariantTypeKt.getType(variant));
        if (androidBaseSourceSetName == null) {
            string = null;
        } else {
            Object v4;
            block6: {
                void it;
                AndroidBaseSourceSetName baseSourceSetName = androidBaseSourceSetName;
                String[] stringArray = new String[3];
                AndroidBaseSourceSetName androidBaseSourceSetName2 = baseSourceSetName;
                Object object = androidBaseSourceSetName2;
                int n = 0;
                String[] stringArray2 = stringArray;
                boolean bl2 = false;
                boolean bl3 = !Intrinsics.areEqual((Object)it, (Object)AndroidBaseSourceSetName.Main.INSTANCE);
                AndroidBaseSourceSetName androidBaseSourceSetName3 = bl3 ? androidBaseSourceSetName2 : null;
                stringArray2[n] = androidBaseSourceSetName3 != null ? androidBaseSourceSetName3.getName() : null;
                stringArray[1] = variant.getFlavorName();
                stringArray[2] = variant.getBuildType().getName();
                String androidSourceSetName = StringUtilsKt.lowerCamelCaseName(stringArray);
                List list = variant.getSourceSets();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"variant.sourceSets");
                object = list;
                Iterator iterator2 = object.iterator();
                while (iterator2.hasNext()) {
                    Object t = iterator2.next();
                    SourceProvider it2 = (SourceProvider)t;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)it2.getName(), (Object)androidSourceSetName)) continue;
                    v4 = t;
                    break block6;
                }
                v4 = null;
            }
            SourceProvider sourceProvider = v4;
            if (sourceProvider == null) {
                string = null;
            } else {
                SourceProvider androidSourceSet = sourceProvider;
                KotlinSourceSet kotlinSourceSet = KotlinAndroidSourceSetInfoKt.findKotlinSourceSet(target2.getProject(), androidSourceSet);
                string = kotlinSourceSet != null ? kotlinSourceSet.getName() : null;
            }
        }
        if ((kotlinSourceSetName = string) == null) {
            logger.warn("Can't determine 'defaultKotlinSourceSet' for android compilation: " + variant.getName());
        }
        return kotlinSourceSetName;
    }

    private final String replaceAndroidBaseSourceSetName(String androidSourceSetName, AndroidVariantType type) {
        if (type == AndroidVariantType.Main) {
            return androidSourceSetName;
        }
        AndroidBaseSourceSetName androidBaseSourceSetName = AndroidVariantTypeKt.getAndroidBaseSourceSetName(type);
        if (androidBaseSourceSetName == null) {
            return androidSourceSetName;
        }
        AndroidBaseSourceSetName androidBaseSourceSetName2 = androidBaseSourceSetName;
        String[] stringArray = new String[]{this.getKotlinName(androidBaseSourceSetName2), StringsKt.removePrefix((String)androidSourceSetName, (CharSequence)androidBaseSourceSetName2.getName())};
        return StringUtilsKt.lowerCamelCaseName(stringArray);
    }
}

