/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.thirdparty.publicsuffix;

import org.jetbrains.kotlin.com.google.common.annotations.Beta;
import org.jetbrains.kotlin.com.google.common.annotations.GwtCompatible;

@Beta
@GwtCompatible
public enum PublicSuffixType {
    PRIVATE(':', ','),
    REGISTRY('!', '?');

    private final char innerNodeCode;
    private final char leafNodeCode;

    private PublicSuffixType(char innerNodeCode, char leafNodeCode) {
        this.innerNodeCode = innerNodeCode;
        this.leafNodeCode = leafNodeCode;
    }

    char getLeafNodeCode() {
        return this.leafNodeCode;
    }

    char getInnerNodeCode() {
        return this.innerNodeCode;
    }

    static PublicSuffixType fromCode(char code) {
        for (PublicSuffixType value2 : PublicSuffixType.values()) {
            if (value2.getInnerNodeCode() != code && value2.getLeafNodeCode() != code) continue;
            return value2;
        }
        throw new IllegalArgumentException("No enum corresponding to given code: " + code);
    }
}

