/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.repl;

import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.AbstractList;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.repl.ILineId;
import org.jetbrains.kotlin.cli.common.repl.IReplStageHistory;
import org.jetbrains.kotlin.cli.common.repl.ReplHistoryRecord;

@Metadata(k=1, mv={2, 0, 0}, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0012\b\u0017\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00040\u00032\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00040\u00060\u0005B-\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ+\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\r2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J*\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00040\u00062\u0006\u0010\u0014\u001a\u00020\u0013H\u0096\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J#\u0010\u0017\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004\u0018\u00010\u0006H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u0019H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001d\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\u00192\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001e\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ+\u0010\"\u001a\u00020\u00102\f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\f\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006H\u0002\u00a2\u0006\u0004\b\"\u0010#R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010$R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010$R\u001a\u0010\n\u001a\u00020\t8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\n\u0010%\u001a\u0004\b&\u0010'R\u0014\u0010*\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/cli/common/repl/AggregatedReplStateHistory;", "T1", "T2", "Lorg/jetbrains/kotlin/cli/common/repl/IReplStageHistory;", "Lkotlin/Pair;", "Lkotlin/collections/AbstractList;", "Lorg/jetbrains/kotlin/cli/common/repl/ReplHistoryRecord;", "history1", "history2", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "lock", "<init>", "(Lorg/jetbrains/kotlin/cli/common/repl/IReplStageHistory;Lorg/jetbrains/kotlin/cli/common/repl/IReplStageHistory;Ljava/util/concurrent/locks/ReentrantReadWriteLock;)V", "Lorg/jetbrains/kotlin/cli/common/repl/ILineId;", "id", "item", "", "push", "(Lorg/jetbrains/kotlin/cli/common/repl/ILineId;Lkotlin/Pair;)V", "", "index", "get", "(I)Lorg/jetbrains/kotlin/cli/common/repl/ReplHistoryRecord;", "pop", "()Lorg/jetbrains/kotlin/cli/common/repl/ReplHistoryRecord;", "", "reset", "()Ljava/lang/Iterable;", "resetTo", "(Lorg/jetbrains/kotlin/cli/common/repl/ILineId;)Ljava/lang/Iterable;", "assertSameSize", "()V", "r1", "r2", "assertSameId", "(Lorg/jetbrains/kotlin/cli/common/repl/ReplHistoryRecord;Lorg/jetbrains/kotlin/cli/common/repl/ReplHistoryRecord;)V", "Lorg/jetbrains/kotlin/cli/common/repl/IReplStageHistory;", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getLock", "()Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getSize", "()I", "size", "cli-common"}, xi=48)
@Deprecated(message="You're using a Kotlin compiler class bundled into KGP for its internal needs.\nThis is discouraged and will not be supported in future releases.\nThe class in this artifact is scheduled for removal in Kotlin 2.2. Please define dependency on it in an alternative way.\nSee https://kotl.in/gradle/internal-compiler-symbols for more details")
public class AggregatedReplStateHistory<T1, T2>
extends AbstractList<ReplHistoryRecord<? extends Pair<? extends T1, ? extends T2>>>
implements IReplStageHistory<Pair<? extends T1, ? extends T2>> {
    @NotNull
    private final IReplStageHistory<T1> history1;
    @NotNull
    private final IReplStageHistory<T2> history2;
    @NotNull
    private final ReentrantReadWriteLock lock;

    public AggregatedReplStateHistory(@NotNull IReplStageHistory<T1> history1, @NotNull IReplStageHistory<T2> history2, @NotNull ReentrantReadWriteLock lock2) {
        Intrinsics.checkNotNullParameter(history1, (String)"history1");
        Intrinsics.checkNotNullParameter(history2, (String)"history2");
        Intrinsics.checkNotNullParameter((Object)lock2, (String)"lock");
        this.history1 = history1;
        this.history2 = history2;
        this.lock = lock2;
    }

    public /* synthetic */ AggregatedReplStateHistory(IReplStageHistory iReplStageHistory, IReplStageHistory iReplStageHistory2, ReentrantReadWriteLock reentrantReadWriteLock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            reentrantReadWriteLock = new ReentrantReadWriteLock();
        }
        this(iReplStageHistory, iReplStageHistory2, reentrantReadWriteLock);
    }

    @Override
    @NotNull
    public ReentrantReadWriteLock getLock() {
        return this.lock;
    }

    public int getSize() {
        return Math.min(this.history1.size(), this.history2.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void push(@NotNull ILineId id, @NotNull Pair<? extends T1, ? extends T2> item) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(item, (String)"item");
        ReentrantReadWriteLock reentrantReadWriteLock = this.getLock();
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int j = 0; j < n; ++j) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this.assertSameSize();
            this.history1.push(id, item.getFirst());
            this.history2.push(id, item.getSecond());
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int j = 0; j < n; ++j) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ReplHistoryRecord<Pair<T1, T2>> get(int index) {
        ReplHistoryRecord<Pair<T1, T2>> replHistoryRecord;
        ReentrantReadWriteLock.ReadLock readLock = this.getLock().readLock();
        readLock.lock();
        try {
            boolean bl = false;
            this.assertSameSize();
            ReplHistoryRecord r1 = (ReplHistoryRecord)this.history1.get(index);
            ReplHistoryRecord r2 = (ReplHistoryRecord)this.history2.get(index);
            this.assertSameId(r1, r2);
            replHistoryRecord = new ReplHistoryRecord<Pair<T1, T2>>(r1.getId(), TuplesKt.to(r1.getItem(), r2.getItem()));
        }
        finally {
            readLock.unlock();
        }
        return replHistoryRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ReplHistoryRecord<Pair<T1, T2>> pop() {
        ReplHistoryRecord<Pair<T1, T2>> replHistoryRecord;
        ReentrantReadWriteLock reentrantReadWriteLock = this.getLock();
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int j = 0; j < n; ++j) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this.assertSameSize();
            ReplHistoryRecord<T1> r1 = this.history1.pop();
            ReplHistoryRecord<T2> r2 = this.history2.pop();
            if (r1 == null && r2 == null) {
                ReplHistoryRecord<Pair<T1, T2>> replHistoryRecord2 = null;
                return replHistoryRecord2;
            }
            if (r1 == null || r2 == null) {
                throw new IllegalStateException("Aggregated history mismatch: " + r1 + " vs " + r2);
            }
            this.assertSameId(r1, r2);
            replHistoryRecord = new ReplHistoryRecord<Pair<T1, T2>>(r1.getId(), TuplesKt.to(r1.getItem(), r2.getItem()));
        }
        finally {
            for (int r1 = 0; r1 < n; ++r1) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        return replHistoryRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Iterable<ILineId> reset() {
        List list;
        ReentrantReadWriteLock reentrantReadWriteLock = this.getLock();
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int j = 0; j < n; ++j) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this.assertSameSize();
            List i1 = CollectionsKt.toList(this.history1.reset());
            List i2 = CollectionsKt.toList(this.history2.reset());
            if (!Intrinsics.areEqual((Object)i1, (Object)i2)) {
                throw new IllegalStateException("Aggregated history reset lines mismatch: " + i1 + " != " + i2);
            }
            list = i1;
        }
        finally {
            for (int j = 0; j < n; ++j) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Iterable<ILineId> resetTo(@NotNull ILineId id) {
        List list;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ReentrantReadWriteLock reentrantReadWriteLock = this.getLock();
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int j = 0; j < n; ++j) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this.assertSameSize();
            List i1 = CollectionsKt.toList(this.history1.resetTo(id));
            List i2 = CollectionsKt.toList(this.history2.resetTo(id));
            if (!Intrinsics.areEqual((Object)i1, (Object)i2)) {
                throw new IllegalStateException("Aggregated history reset lines mismatch: " + i1 + " != " + i2);
            }
            list = i1;
        }
        finally {
            for (int j = 0; j < n; ++j) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        return list;
    }

    private final void assertSameSize() {
        if (this.history1.size() != this.history2.size()) {
            throw new IllegalStateException("Aggregated history sizes mismatch: " + this.history1.size() + " != " + this.history2.size());
        }
    }

    private final void assertSameId(ReplHistoryRecord<? extends T1> r1, ReplHistoryRecord<? extends T2> r2) {
        if (!Intrinsics.areEqual((Object)r1.getId(), (Object)r2.getId())) {
            throw new IllegalStateException("Aggregated history mismatch: " + r1.getId() + " != " + r2.getId());
        }
    }
}

