/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import java.util.EnumSet;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CompilerSystemProperties;
import org.jetbrains.kotlin.cli.common.PropertiesKt;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.org.fusesource.jansi.Ansi;
import org.jetbrains.kotlin.org.fusesource.jansi.AnsiConsole;
import org.jetbrains.kotlin.org.fusesource.jansi.internal.CLibrary;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(k=1, mv={2, 0, 0}, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0006\b'\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0013\b\u0007\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ)\u0010\u000e\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0019\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\fH$\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0015\u0010\bJ\r\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\r\u0010\u0019\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0019\u0010\u0018R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001a\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/cli/common/messages/PlainTextMessageRenderer;", "Lorg/jetbrains/kotlin/cli/common/messages/MessageRenderer;", "", "colorEnabled", "<init>", "(Z)V", "", "renderPreamble", "()Ljava/lang/String;", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "severity", "message", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSourceLocation;", "location", "render", "(Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;Ljava/lang/String;Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSourceLocation;)Ljava/lang/String;", "getPath", "(Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSourceLocation;)Ljava/lang/String;", "usage", "renderUsage", "(Ljava/lang/String;)Ljava/lang/String;", "renderConclusion", "", "enableColorsIfNeeded", "()V", "disableColorsIfNeeded", "Z", "Companion", "cli"}, xi=48)
@Deprecated(message="You're using a Kotlin compiler class bundled into KGP for its internal needs.\nThis is discouraged and will not be supported in future releases.\nThe class in this artifact is scheduled for removal in Kotlin 2.2. Please define dependency on it in an alternative way.\nSee https://kotl.in/gradle/internal-compiler-symbols for more details")
public abstract class PlainTextMessageRenderer
implements MessageRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean colorEnabled;
    private static final boolean COLOR_ENABLED;
    @NotNull
    private static final String LINE_SEPARATOR;
    @NotNull
    private static final Set<CompilerMessageSeverity> IMPORTANT_MESSAGE_SEVERITIES;

    @JvmOverloads
    public PlainTextMessageRenderer(boolean colorEnabled) {
        this.colorEnabled = colorEnabled;
    }

    public /* synthetic */ PlainTextMessageRenderer(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = COLOR_ENABLED;
        }
        this(bl);
    }

    @Override
    @NotNull
    public String renderPreamble() {
        return "";
    }

    @Override
    @NotNull
    public String render(@NotNull CompilerMessageSeverity severity, @NotNull String message2, @Nullable CompilerMessageSourceLocation location) {
        StringBuilder stringBuilder;
        String path;
        Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        StringBuilder result2 = new StringBuilder();
        CompilerMessageSourceLocation compilerMessageSourceLocation = location;
        int line = compilerMessageSourceLocation != null ? compilerMessageSourceLocation.getLine() : -1;
        CompilerMessageSourceLocation compilerMessageSourceLocation2 = location;
        int column = compilerMessageSourceLocation2 != null ? compilerMessageSourceLocation2.getColumn() : -1;
        CompilerMessageSourceLocation compilerMessageSourceLocation3 = location;
        int lineEnd = compilerMessageSourceLocation3 != null ? compilerMessageSourceLocation3.getLineEnd() : -1;
        CompilerMessageSourceLocation compilerMessageSourceLocation4 = location;
        int columnEnd = compilerMessageSourceLocation4 != null ? compilerMessageSourceLocation4.getColumnEnd() : -1;
        CompilerMessageSourceLocation compilerMessageSourceLocation5 = location;
        String lineContent = compilerMessageSourceLocation5 != null ? compilerMessageSourceLocation5.getLineContent() : null;
        CompilerMessageSourceLocation compilerMessageSourceLocation6 = location;
        String string = path = compilerMessageSourceLocation6 != null ? this.getPath(compilerMessageSourceLocation6) : null;
        if (path != null) {
            result2.append(path);
            result2.append(":");
            if (line > 0) {
                result2.append(line).append(":");
                if (column > 0) {
                    result2.append(column).append(":");
                }
            }
            result2.append(" ");
        }
        if (this.colorEnabled) {
            String decapitalized;
            int firstNewline;
            Ansi ansi = Ansi.ansi().bold().fg(PlainTextMessageRenderer.Companion.severityColor(severity)).a(severity.getPresentableName()).a(": ").reset();
            Intrinsics.checkNotNullExpressionValue((Object)ansi, (String)"reset(...)");
            Ansi ansi2 = ansi;
            if (IMPORTANT_MESSAGE_SEVERITIES.contains((Object)severity)) {
                ansi2.bold();
            }
            if ((firstNewline = StringsKt.indexOf$default((CharSequence)(decapitalized = PlainTextMessageRenderer.Companion.decapitalizeIfNeeded(message2)), (String)LINE_SEPARATOR, (int)0, (boolean)false, (int)6, null)) < 0) {
                stringBuilder = result2.append(ansi2.a(decapitalized).reset());
            } else {
                String string2 = decapitalized.substring(0, firstNewline);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                Ansi ansi3 = ansi2.a(string2).reset();
                String string3 = decapitalized.substring(firstNewline);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                stringBuilder = result2.append(ansi3.a(string3));
            }
        } else {
            result2.append(severity.getPresentableName());
            result2.append(": ");
            stringBuilder = result2.append(PlainTextMessageRenderer.Companion.decapitalizeIfNeeded(message2));
        }
        if (lineContent != null && 1 <= column && column <= lineContent.length() + 1) {
            result2.append(LINE_SEPARATOR);
            result2.append(lineContent);
            result2.append(LINE_SEPARATOR);
            result2.append(StringsKt.repeat((CharSequence)" ", (int)(column - 1)));
            StringBuilder stringBuilder2 = lineEnd > line ? result2.append(StringsKt.repeat((CharSequence)"^", (int)(lineContent.length() - column + 1))) : (lineEnd == line && columnEnd > column ? result2.append(StringsKt.repeat((CharSequence)"^", (int)(columnEnd - column))) : result2.append("^"));
        }
        String string4 = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        return string4;
    }

    @Nullable
    protected abstract String getPath(@NotNull CompilerMessageSourceLocation var1);

    @Override
    @NotNull
    public String renderUsage(@NotNull String usage) {
        Intrinsics.checkNotNullParameter((Object)usage, (String)"usage");
        return usage;
    }

    @Override
    @NotNull
    public String renderConclusion() {
        return "";
    }

    public final void enableColorsIfNeeded() {
        if (this.colorEnabled) {
            AnsiConsole.systemInstall();
        }
    }

    public final void disableColorsIfNeeded() {
        if (this.colorEnabled) {
            AnsiConsole.systemUninstall();
        }
    }

    @JvmOverloads
    public PlainTextMessageRenderer() {
        this(false, 1, null);
    }

    static {
        boolean isStderrATty = false;
        String kotlinColorsEnabled = CompilerSystemProperties.KOTLIN_COLORS_ENABLED_PROPERTY.getValue();
        if (!PropertiesKt.isWindows() && Intrinsics.areEqual((Object)"true", (Object)kotlinColorsEnabled)) {
            try {
                isStderrATty = CLibrary.isatty((int)CLibrary.STDERR_FILENO) != 0;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
        }
        COLOR_ENABLED = isStderrATty || Intrinsics.areEqual((Object)"always", (Object)kotlinColorsEnabled);
        String string = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator(...)");
        LINE_SEPARATOR = string;
        EnumSet<Enum> enumSet = EnumSet.of((Enum)CompilerMessageSeverity.EXCEPTION, (Enum)CompilerMessageSeverity.ERROR, (Enum)CompilerMessageSeverity.STRONG_WARNING, (Enum)CompilerMessageSeverity.WARNING, (Enum)CompilerMessageSeverity.FIXED_WARNING);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
        IMPORTANT_MESSAGE_SEVERITIES = enumSet;
    }

    @Metadata(k=1, mv={2, 0, 0}, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0003\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fR\u0014\u0010\u000e\u001a\u00020\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/cli/common/messages/PlainTextMessageRenderer$Companion;", "", "<init>", "()V", "", "message", "decapitalizeIfNeeded", "(Ljava/lang/String;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "severity", "Lorg/jetbrains/kotlin/org/fusesource/jansi/Ansi$Color;", "severityColor", "(Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;)Lorg/jetbrains/kotlin/org/fusesource/jansi/Ansi$Color;", "", "COLOR_ENABLED", "Z", "LINE_SEPARATOR", "Ljava/lang/String;", "", "IMPORTANT_MESSAGE_SEVERITIES", "Ljava/util/Set;", "cli"}, xi=48)
    @Deprecated(message="You're using a Kotlin compiler class bundled into KGP for its internal needs.\nThis is discouraged and will not be supported in future releases.\nThe class in this artifact is scheduled for removal in Kotlin 2.2. Please define dependency on it in an alternative way.\nSee https://kotl.in/gradle/internal-compiler-symbols for more details")
    public static final class Companion {
        private Companion() {
        }

        private final String decapitalizeIfNeeded(String message2) {
            if (StringsKt.startsWith$default((String)message2, (String)"Java", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)message2, (String)"Kotlin", (boolean)false, (int)2, null)) {
                return message2;
            }
            if (message2.length() >= 2 && Character.isUpperCase(message2.charAt(0)) && Character.isUpperCase(message2.charAt(1))) {
                return message2;
            }
            return CapitalizeDecapitalizeKt.decapitalizeAsciiOnly(message2);
        }

        private final Ansi.Color severityColor(CompilerMessageSeverity severity) {
            Ansi.Color color;
            switch (WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
                case 1: 
                case 2: {
                    color = Ansi.Color.RED;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    color = Ansi.Color.YELLOW;
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    color = Ansi.Color.BLUE;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return color;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(k=3, mv={2, 0, 0}, d1={}, d2={}, xi=48)
        @Deprecated(message="You're using a Kotlin compiler class bundled into KGP for its internal needs.\nThis is discouraged and will not be supported in future releases.\nThe class in this artifact is scheduled for removal in Kotlin 2.2. Please define dependency on it in an alternative way.\nSee https://kotl.in/gradle/internal-compiler-symbols for more details")
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[CompilerMessageSeverity.values().length];
                try {
                    nArray[CompilerMessageSeverity.EXCEPTION.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CompilerMessageSeverity.ERROR.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CompilerMessageSeverity.STRONG_WARNING.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CompilerMessageSeverity.WARNING.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CompilerMessageSeverity.FIXED_WARNING.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CompilerMessageSeverity.INFO.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CompilerMessageSeverity.LOGGING.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CompilerMessageSeverity.OUTPUT.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

