/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.messages.serviceMessages;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jetbrains.buildServer.messages.serviceMessages.BlockClosed;
import jetbrains.buildServer.messages.serviceMessages.BlockOpened;
import jetbrains.buildServer.messages.serviceMessages.BuildNumber;
import jetbrains.buildServer.messages.serviceMessages.BuildStatisticValue;
import jetbrains.buildServer.messages.serviceMessages.BuildStatus;
import jetbrains.buildServer.messages.serviceMessages.CompilationFinished;
import jetbrains.buildServer.messages.serviceMessages.CompilationStarted;
import jetbrains.buildServer.messages.serviceMessages.InternalErrorMessage;
import jetbrains.buildServer.messages.serviceMessages.MapSerializerUtil;
import jetbrains.buildServer.messages.serviceMessages.Message;
import jetbrains.buildServer.messages.serviceMessages.ProgressFinish;
import jetbrains.buildServer.messages.serviceMessages.ProgressMessage;
import jetbrains.buildServer.messages.serviceMessages.ProgressStart;
import jetbrains.buildServer.messages.serviceMessages.PublishArtifacts;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageParserCallback;
import jetbrains.buildServer.messages.serviceMessages.TestFailed;
import jetbrains.buildServer.messages.serviceMessages.TestFinished;
import jetbrains.buildServer.messages.serviceMessages.TestIgnored;
import jetbrains.buildServer.messages.serviceMessages.TestNavigationInfo;
import jetbrains.buildServer.messages.serviceMessages.TestStarted;
import jetbrains.buildServer.messages.serviceMessages.TestStdErr;
import jetbrains.buildServer.messages.serviceMessages.TestStdOut;
import jetbrains.buildServer.messages.serviceMessages.TestSuiteFinished;
import jetbrains.buildServer.messages.serviceMessages.TestSuiteStarted;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceMessagesParser {
    private boolean myValidateRequiredAttributes = true;
    private Map<String, Class<? extends ServiceMessage>> myServiceMessageTypes = SERVICE_MESSAGE_CLASSES;
    @NotNull
    private static final Map<String, Class<? extends ServiceMessage>> SERVICE_MESSAGE_CLASSES = new HashMap<String, Class<? extends ServiceMessage>>();

    public void setValidateRequiredAttributes(boolean validateRequiredAttributes) {
        this.myValidateRequiredAttributes = validateRequiredAttributes;
    }

    public void parse(@NotNull String text, @NotNull ServiceMessageParserCallback parserCallback) {
        if (text == null) {
            ServiceMessagesParser.$$$reportNull$$$0(0);
        }
        if (parserCallback == null) {
            ServiceMessagesParser.$$$reportNull$$$0(1);
        }
        for (Pair<String, Boolean> parsed : ServiceMessagesParser.splitTextToServiceMessagesAndRegularText(text)) {
            if (parsed.getSecond().booleanValue()) {
                try {
                    parserCallback.serviceMessage(this.doParse(parsed.getFirst()));
                }
                catch (ParseException e) {
                    parserCallback.parseException(e, ServiceMessagesParser.appendPrefixAndSuffix(parsed.getFirst()));
                }
                continue;
            }
            if (parsed.getFirst().startsWith("##teamcity[")) {
                parserCallback.parseException(new ParseException("The service message is invalid because it does not end with ] character: " + parsed.getFirst(), 0), parsed.getFirst());
                continue;
            }
            parserCallback.regularText(parsed.getFirst());
        }
    }

    @NotNull
    private static List<Pair<String, Boolean>> splitTextToServiceMessagesAndRegularText(@NotNull String text) {
        if (text == null) {
            ServiceMessagesParser.$$$reportNull$$$0(2);
        }
        ArrayList<Pair<String, Boolean>> pairs = new ArrayList<Pair<String, Boolean>>();
        int currentIndex = 0;
        while (currentIndex < text.length()) {
            int messageStartPos = text.indexOf("##teamcity[", currentIndex);
            if (messageStartPos == -1) {
                ServiceMessagesParser.addMessageToListIfNotEmpty(pairs, text.substring(currentIndex), false);
                ArrayList<Pair<String, Boolean>> arrayList = pairs;
                if (arrayList == null) {
                    ServiceMessagesParser.$$$reportNull$$$0(3);
                }
                return arrayList;
            }
            ServiceMessagesParser.addMessageToListIfNotEmpty(pairs, text.substring(currentIndex, messageStartPos), false);
            int messageEndPos = ServiceMessagesParser.findMessageEnd(text, messageStartPos);
            if (messageEndPos == -1) {
                ServiceMessagesParser.addMessageToListIfNotEmpty(pairs, text.substring(messageStartPos), false);
                ArrayList<Pair<String, Boolean>> arrayList = pairs;
                if (arrayList == null) {
                    ServiceMessagesParser.$$$reportNull$$$0(4);
                }
                return arrayList;
            }
            ServiceMessagesParser.addMessageToListIfNotEmpty(pairs, text.substring(messageStartPos + "##teamcity[".length(), messageEndPos - "]".length()).trim(), true);
            currentIndex = messageEndPos;
        }
        ArrayList<Pair<String, Boolean>> arrayList = pairs;
        if (arrayList == null) {
            ServiceMessagesParser.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static void addMessageToListIfNotEmpty(@NotNull List<Pair<String, Boolean>> pairs, @NotNull String message2, boolean isServiceMessage) {
        if (pairs == null) {
            ServiceMessagesParser.$$$reportNull$$$0(6);
        }
        if (message2 == null) {
            ServiceMessagesParser.$$$reportNull$$$0(7);
        }
        if (message2.length() != 0) {
            pairs.add(Pair.create(message2, isServiceMessage));
        }
    }

    private static int findMessageEnd(@NotNull String text, int messageStartPos) {
        if (text == null) {
            ServiceMessagesParser.$$$reportNull$$$0(8);
        }
        int pos = messageStartPos;
        while ((pos = text.indexOf("]", pos + 1)) != -1 && text.charAt(pos - 1) == MapSerializerUtil.STD_ESCAPER2.escapeCharacter()) {
        }
        return pos == -1 ? -1 : pos + 1;
    }

    @NotNull
    private ServiceMessage doParse(@NotNull String text) throws ParseException {
        ServiceMessage serviceMessage;
        int sepIndex;
        if (text == null) {
            ServiceMessagesParser.$$$reportNull$$$0(9);
        }
        String key = (sepIndex = ServiceMessagesParser.indexOfAnyWhitespace(text)) == -1 ? text : text.substring(0, sepIndex);
        String argumentsStr = sepIndex == -1 ? null : text.substring(sepIndex).trim();
        Class<? extends ServiceMessage> clazz = this.myServiceMessageTypes.get(key);
        try {
            ServiceMessage msg = clazz == null ? new ServiceMessage() : clazz.newInstance();
            msg.init(key, argumentsStr);
            if (this.myValidateRequiredAttributes) {
                msg.validate();
            }
            serviceMessage = msg;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (serviceMessage == null) {
            ServiceMessagesParser.$$$reportNull$$$0(10);
        }
        return serviceMessage;
    }

    private static int indexOfAnyWhitespace(@NotNull String text) {
        if (text == null) {
            ServiceMessagesParser.$$$reportNull$$$0(11);
        }
        for (int i2 = 0; i2 < text.length(); ++i2) {
            if (!Character.isWhitespace(text.charAt(i2))) continue;
            return i2;
        }
        return -1;
    }

    static String appendPrefixAndSuffix(String text) {
        return "##teamcity[" + text + "]";
    }

    static {
        SERVICE_MESSAGE_CLASSES.put("progressMessage", ProgressMessage.class);
        SERVICE_MESSAGE_CLASSES.put("progressStart", ProgressStart.class);
        SERVICE_MESSAGE_CLASSES.put("progressFinish", ProgressFinish.class);
        SERVICE_MESSAGE_CLASSES.put("publishArtifacts", PublishArtifacts.class);
        SERVICE_MESSAGE_CLASSES.put("testSuiteStarted", TestSuiteStarted.class);
        SERVICE_MESSAGE_CLASSES.put("testSuiteFinished", TestSuiteFinished.class);
        SERVICE_MESSAGE_CLASSES.put("testStarted", TestStarted.class);
        SERVICE_MESSAGE_CLASSES.put("testFailed", TestFailed.class);
        SERVICE_MESSAGE_CLASSES.put("testFinished", TestFinished.class);
        SERVICE_MESSAGE_CLASSES.put("testIgnored", TestIgnored.class);
        SERVICE_MESSAGE_CLASSES.put("testStdOut", TestStdOut.class);
        SERVICE_MESSAGE_CLASSES.put("testStdErr", TestStdErr.class);
        SERVICE_MESSAGE_CLASSES.put("buildStatus", BuildStatus.class);
        SERVICE_MESSAGE_CLASSES.put("buildNumber", BuildNumber.class);
        SERVICE_MESSAGE_CLASSES.put("buildStatisticValue", BuildStatisticValue.class);
        SERVICE_MESSAGE_CLASSES.put("testNavigationInfo", TestNavigationInfo.class);
        SERVICE_MESSAGE_CLASSES.put("blockOpened", BlockOpened.class);
        SERVICE_MESSAGE_CLASSES.put("blockClosed", BlockClosed.class);
        SERVICE_MESSAGE_CLASSES.put("compilationStarted", CompilationStarted.class);
        SERVICE_MESSAGE_CLASSES.put("compilationFinished", CompilationFinished.class);
        SERVICE_MESSAGE_CLASSES.put("message", Message.class);
        SERVICE_MESSAGE_CLASSES.put("internalError", InternalErrorMessage.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parserCallback";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/messages/serviceMessages/ServiceMessagesParser";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pairs";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/messages/serviceMessages/ServiceMessagesParser";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "splitTextToServiceMessagesAndRegularText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "doParse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "splitTextToServiceMessagesAndRegularText";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addMessageToListIfNotEmpty";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findMessageEnd";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doParse";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "indexOfAnyWhitespace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Pair<T1, T2> {
        private final T1 myFirst;
        private final T2 mySecond;

        private Pair(T1 first, T2 second) {
            this.myFirst = first;
            this.mySecond = second;
        }

        public T1 getFirst() {
            return this.myFirst;
        }

        public T2 getSecond() {
            return this.mySecond;
        }

        public static <T1, T2> Pair<T1, T2> create(T1 first, T2 second) {
            return new Pair<T1, T2>(first, second);
        }
    }
}

