/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.commons.compress.harmony.unpack200.bytecode;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.kotlin.org.apache.commons.compress.harmony.unpack200.bytecode.Attribute;
import org.jetbrains.kotlin.org.apache.commons.compress.harmony.unpack200.bytecode.CPUTF8;
import org.jetbrains.kotlin.org.apache.commons.compress.harmony.unpack200.bytecode.ClassConstantPool;
import org.jetbrains.kotlin.org.apache.commons.compress.harmony.unpack200.bytecode.ClassFileEntry;

public class ConstantValueAttribute
extends Attribute {
    private static CPUTF8 attributeName;
    private int constantIndex;
    private final ClassFileEntry entry;

    public static void setAttributeName(CPUTF8 cpUTF8Value) {
        attributeName = cpUTF8Value;
    }

    public ConstantValueAttribute(ClassFileEntry entry2) {
        super(attributeName);
        this.entry = Objects.requireNonNull(entry2, "entry");
    }

    @Override
    public boolean equals(Object obj2) {
        if (this == obj2) {
            return true;
        }
        if (!super.equals(obj2)) {
            return false;
        }
        if (this.getClass() != obj2.getClass()) {
            return false;
        }
        ConstantValueAttribute other = (ConstantValueAttribute)obj2;
        return Objects.equals(this.entry, other.entry);
    }

    @Override
    protected int getLength() {
        return 2;
    }

    @Override
    protected ClassFileEntry[] getNestedClassFileEntries() {
        return new ClassFileEntry[]{this.getAttributeName(), this.entry};
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.entry == null ? 0 : this.entry.hashCode());
        return result2;
    }

    @Override
    protected void resolve(ClassConstantPool pool) {
        super.resolve(pool);
        this.entry.resolve(pool);
        this.constantIndex = pool.indexOf(this.entry);
    }

    @Override
    public String toString() {
        return "Constant:" + this.entry;
    }

    @Override
    protected void writeBody(DataOutputStream dos) throws IOException {
        dos.writeShort(this.constantIndex);
    }
}

