/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.utils;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceSpec;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.utils.GradleUtilsKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0010\u001a\u00020\u0016*\u00020\r2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00160\u0018H\u0000\u001aP\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001a\"\u000e\b\u0000\u0010\u001b*\b\u0012\u0004\u0012\u0002H\u001d0\u001c\"\b\b\u0001\u0010\u001d*\u00020\u001e*\u00020\f2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001b0 2\u0014\b\u0002\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001d0#0\"H\u0000\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0002*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0018\u0010\t\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0004\"\u0018\u0010\u000b\u001a\u00020\f*\u00020\r8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\"\u0018\u0010\u0010\u001a\u00020\r*\u00020\r8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\"\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u0001*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006$"}, d2={"buildNameCompat", "", "Lorg/gradle/api/artifacts/component/BuildIdentifier;", "getBuildNameCompat", "(Lorg/gradle/api/artifacts/component/BuildIdentifier;)Ljava/lang/String;", "buildOrNull", "Lorg/gradle/api/artifacts/component/ComponentIdentifier;", "getBuildOrNull", "(Lorg/gradle/api/artifacts/component/ComponentIdentifier;)Lorg/gradle/api/artifacts/component/BuildIdentifier;", "buildPathCompat", "getBuildPathCompat", "compositeBuildRootGradle", "Lorg/gradle/api/invocation/Gradle;", "Lorg/gradle/api/Project;", "getCompositeBuildRootGradle", "(Lorg/gradle/api/Project;)Lorg/gradle/api/invocation/Gradle;", "compositeBuildRootProject", "getCompositeBuildRootProject", "(Lorg/gradle/api/Project;)Lorg/gradle/api/Project;", "projectPathOrNull", "getProjectPathOrNull", "(Lorg/gradle/api/artifacts/component/ComponentIdentifier;)Ljava/lang/String;", "", "block", "Lkotlin/Function1;", "registerClassLoaderScopedBuildService", "Lorg/gradle/api/provider/Provider;", "T", "Lorg/gradle/api/services/BuildService;", "P", "Lorg/gradle/api/services/BuildServiceParameters;", "serviceClass", "Lkotlin/reflect/KClass;", "configureAction", "Lorg/gradle/api/Action;", "Lorg/gradle/api/services/BuildServiceSpec;", "kotlin-gradle-plugin_common"})
public final class GradleUtilsKt {
    @NotNull
    public static final Gradle getCompositeBuildRootGradle(@NotNull Project $this$compositeBuildRootGradle) {
        Intrinsics.checkNotNullParameter((Object)$this$compositeBuildRootGradle, (String)"<this>");
        return (Gradle)SequencesKt.last((Sequence)SequencesKt.generateSequence((Object)$this$compositeBuildRootGradle.getProject().getGradle(), (Function1)compositeBuildRootGradle.1.INSTANCE));
    }

    @NotNull
    public static final Project getCompositeBuildRootProject(@NotNull Project $this$compositeBuildRootProject) {
        Intrinsics.checkNotNullParameter((Object)$this$compositeBuildRootProject, (String)"<this>");
        Project project = GradleUtilsKt.getCompositeBuildRootGradle($this$compositeBuildRootProject).getRootProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"compositeBuildRootGradle.rootProject");
        return project;
    }

    public static final void compositeBuildRootProject(@NotNull Project $this$compositeBuildRootProject, @NotNull Function1<? super Project, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$compositeBuildRootProject, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        GradleUtilsKt.getCompositeBuildRootGradle($this$compositeBuildRootProject).rootProject(new Action(block){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void execute(Object p0) {
                this.function.invoke(p0);
            }
        });
    }

    @NotNull
    public static final <T extends BuildService<P>, P extends BuildServiceParameters> Provider<T> registerClassLoaderScopedBuildService(@NotNull Gradle $this$registerClassLoaderScopedBuildService, @NotNull KClass<T> serviceClass, @NotNull Action<BuildServiceSpec<P>> configureAction2) {
        Intrinsics.checkNotNullParameter((Object)$this$registerClassLoaderScopedBuildService, (String)"<this>");
        Intrinsics.checkNotNullParameter(serviceClass, (String)"serviceClass");
        Intrinsics.checkNotNullParameter(configureAction2, (String)"configureAction");
        String serviceName = serviceClass.getSimpleName() + '_' + JvmClassMappingKt.getJavaClass(serviceClass).getClassLoader().hashCode();
        Provider provider = $this$registerClassLoaderScopedBuildService.getSharedServices().registerIfAbsent(serviceName, JvmClassMappingKt.getJavaClass(serviceClass), configureAction2);
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"sharedServices.registerI\u2026ss.java, configureAction)");
        return provider;
    }

    public static /* synthetic */ Provider registerClassLoaderScopedBuildService$default(Gradle gradle, KClass kClass, Action action2, int n, Object object) {
        if ((n & 2) != 0) {
            action2 = registerClassLoaderScopedBuildService.1.INSTANCE;
        }
        return GradleUtilsKt.registerClassLoaderScopedBuildService(gradle, kClass, action2);
    }

    @NotNull
    public static final String getBuildNameCompat(@NotNull BuildIdentifier $this$buildNameCompat) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$buildNameCompat, (String)"<this>");
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"8.2")) >= 0) {
            if (Intrinsics.areEqual((Object)$this$buildNameCompat.getBuildPath(), (Object)":")) {
                string = ":";
            } else {
                String string2 = $this$buildNameCompat.getBuildPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"buildPath");
                String[] stringArray = new String[]{":"};
                string = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)string2, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
            }
        } else {
            String string3 = $this$buildNameCompat.getName();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this.name");
        }
        return string;
    }

    @NotNull
    public static final String getBuildPathCompat(@NotNull BuildIdentifier $this$buildPathCompat) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$buildPathCompat, (String)"<this>");
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"8.2")) >= 0) {
            String string2 = $this$buildPathCompat.getBuildPath();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"buildPath");
        } else {
            String string3 = $this$buildPathCompat.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"name");
            if (StringsKt.startsWith$default((String)string3, (String)":", (boolean)false, (int)2, null)) {
                String string4 = $this$buildPathCompat.getName();
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"name");
            } else {
                string = ':' + $this$buildPathCompat.getName();
            }
        }
        return string;
    }

    @Nullable
    public static final BuildIdentifier getBuildOrNull(@NotNull ComponentIdentifier $this$buildOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$buildOrNull, (String)"<this>");
        ProjectComponentIdentifier projectComponentIdentifier = $this$buildOrNull instanceof ProjectComponentIdentifier ? (ProjectComponentIdentifier)$this$buildOrNull : null;
        return projectComponentIdentifier != null ? projectComponentIdentifier.getBuild() : null;
    }

    @Nullable
    public static final String getProjectPathOrNull(@NotNull ComponentIdentifier $this$projectPathOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$projectPathOrNull, (String)"<this>");
        ProjectComponentIdentifier projectComponentIdentifier = $this$projectPathOrNull instanceof ProjectComponentIdentifier ? (ProjectComponentIdentifier)$this$projectPathOrNull : null;
        return projectComponentIdentifier != null ? projectComponentIdentifier.getProjectPath() : null;
    }
}

